<!doctype html>
<html lang="en">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <link rel="shortcut icon" href="<?php echo e(url('site')); ?>/assets/images/favicon.png">
    <title><?php echo e(env('APP_NAME')); ?> - Os melhores eventos estão aqui!</title>
    <link href="<?php echo e(url('site')); ?>/assets/plugins/aos/aos.min.css" rel="stylesheet">
    <link href="<?php echo e(url('site')); ?>/assets/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet">
    <link href="<?php echo e(url('site')); ?>/assets/plugins/fontawesome/css/all.min.css" rel="stylesheet">
    <link href="<?php echo e(url('site')); ?>/assets/plugins/OwlCarousel2/css/owl.carousel.min.css" rel="stylesheet">
    <link href="<?php echo e(url('site')); ?>/assets/plugins/OwlCarousel2/css/owl.theme.default.min.css" rel="stylesheet">
    <link href="<?php echo e(url('site')); ?>/assets/plugins/jquery-fancyfileuploader/fancy-file-uploader/fancy_fileupload.css"
        rel="stylesheet">
    <link href="<?php echo e(url('site')); ?>/assets/plugins/ion.rangeSlider/ion.rangeSlider.min.css" rel="stylesheet">
    <link href="<?php echo e(url('site')); ?>/assets/plugins/magnific-popup/magnific-popup.css" rel="stylesheet">
    <link href="<?php echo e(url('site')); ?>/assets/plugins/select2/select2.min.css" rel="stylesheet">
    <link href="<?php echo e(url('site')); ?>/assets/plugins/select2-bootstrap-5/select2-bootstrap-5-theme.min.css"
        rel="stylesheet">

    <!-- Custom style for this template -->
    <link href="<?php echo e(url('site')); ?>/assets/css/style.css" rel="stylesheet">
    <div class="sempreDireita">
        <a href="javascript:void(0)" data-bs-toggle="modal" data-bs-target="#modal-central-de-ajuda">
            <img src="<?php echo e(url('site/assets/images/interrogation-mark.png')); ?>" width="20" style="margin-right: 5px">
            Central de Ajuda
        </a>
    </div>
    <meta name="description" content="<?php echo $__env->yieldContent('description'); ?>">
    <link rel="canonical" href="" />
    <meta property="og:url" content="<?php echo $__env->yieldContent('url'); ?>">
    <meta property="og:type" content="website" />
    <meta property="og:title" content="<?php echo $__env->yieldContent('titulo'); ?>" />
    <meta property="og:description" content="<?php echo $__env->yieldContent('description'); ?>" />
    <meta property="og:image" content="<?php echo $__env->yieldContent('image'); ?>" />
    <meta property="og:image:secure_url" content="<?php echo $__env->yieldContent('image'); ?>" />
    <script src="https://www.google.com/recaptcha/api.js"></script>
</head>

<body>
    <div id="ec-overlay" class="d-none">
        <div class="ec-ellipsis">
            <div></div>
            <div></div>
            <div></div>
            <div></div>
        </div>
    </div>
    <nav class="navbar navbar-expand-lg navbar-light bg-white sticky-top" style="border-bottom: 2px solid#1166B0;">
        <div class="container">
            <a class="navbar-brand" href="<?php echo e(route('site.home')); ?>">
                <img src="<?php echo e(url('site')); ?>/assets/images/logo.png" alt="">
            </a>
            <div class="d-flex order-lg-2">
                <div class="btn btn-outline-primary d-none d-sm-flex fw-medium gap-2 hstack rounded-2"
                    style="cursor: default;">
                    <span class="d-none d-sm-inline-block btn-cliente">
                        <a class="fs-14" href="https://vendas.ticketmaker.com.br/Login" target="_blank"
                            rel="noopener noreferrer">Login</a>
                    </span>
                    <div class="vr d-none d-sm-inline-block"></div>
                    <span class="d-none d-sm-inline-block btn-cliente">
                        <a class="fs-14" href="https://vendas.ticketmaker.com.br/Login" target="_blank"
                            rel="noopener noreferrer">Cadastre-se</a>
                    </span>
                </div>
                <button class="navbar-toggler" type="button" data-bs-toggle="collapse"
                    data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent"
                    aria-expanded="false" aria-label="Toggle navigation">
                    <span id="nav-icon">
                        <span></span>
                        <span></span>
                        <span></span>
                    </span>
                </button>
            </div>

            <div class="collapse navbar-collapse margin-menu" id="navbarSupportedContent">
                <ul class="navbar-nav m-auto mb-2 mb-lg-0">
                    <li class="nav-item"><a class="nav-link" href="<?php echo e(route('site.home')); ?>">Home</a></li>
                    <li class="nav-item"><a class="nav-link" href="https://organizador.ticketmaker.com.br/">Organize seu
                            Evento</a></li>
                    <li class="nav-item">
                        <a class="nav-link" href="javascript:void(0)" data-bs-toggle="modal"
                            data-bs-target="#modal-estados">
                            <img src="<?php echo e(url('site')); ?>/assets/images/location.png" width="20">
                            <span
                                id="menu-estado"><?php echo e(empty(session()->get('estado')) || session()->get('estado') == 'All' ? 'Selecione seu estado' : $escreve_estado[session()->get('estado')]); ?></span>
                            <i class="fa fa-angle-down" style="margin-left: 10px"></i>
                        </a>
                    </li>
                    <li style="text-align: center;">
                        <div class="input-group-busca mb-2">
                            <input id="buscar" type="text"
                                placeholder="Buscar por eventos, categorias e locais" class="form-busca shadow">
                            <button class="btn btn-white btn-busca shadow" type="button">
                                <i class="fa fa-search text-blue"></i>
                            </button>
                        </div>
                    </li>
                </ul>
                <div class="d-sm-none">
                    <a href="https://vendas.ticketmaker.com.br/Login"
                        class="btn btn-primary d-flex gap-2 hstack justify-content-center rounded-3">
                        <i class="fa-solid fa-user"></i>
                        <div class="vr d-none d-sm-inline-block"></div>
                        <span>Login</span>
                    </a>
                </div>
                <div class="mt-1 d-sm-none">
                    <a href="https://vendas.ticketmaker.com.br/Login/Cadastro"
                        class="btn btn-primary d-flex gap-2 hstack justify-content-center rounded-3">
                        <i class="fa-solid fa-user-plus"></i>
                        <div class="vr d-none d-sm-inline-block"></div>
                        <span>Cadastre-se</span>
                    </a>
                </div>
            </div>
        </div>
    </nav>
    <?php echo $__env->yieldContent('content'); ?>
    <footer class="footer-dark main-footer overflow-hidden position-relative pt-5">
        <div class="container pt-4">
            <div class="py-5">
                <!-- start app download content -->
                <div class="bg-ticket-maker rounded-4 top-footer">
                    <div
                        class="col-xxl-10 col-md-11 col-10 d-flex flex-md-row flex-column-reverse align-items-md-end align-items-center mx-auto px-0 gap-4">
                        <img class="app-image flex-shrink-0" src="<?php echo e(url('site')); ?>/assets/images/phone-mpckup.png"
                            width="270" alt="Mobile app">
                        <div
                            class="align-items-lg-center align-self-center d-flex flex-column flex-lg-row ps-xxl-4 pt-5 py-md-3 text-center text-md-start">
                            <div class="me-md-5">
                                <h4 class="text-white fs-20">Os melhores eventos estão aqui!</h4>
                                <p class="mb-lg-0 text-white">Baixe nosso app e confira todos os eventos disponíveis.
                                    Descubra o seu próximo rolê na Ticket Maker.</p>
                            </div>
                            <div class="d-flex flex-shrink-0 flex-wrap gap-3 justify-content-center">
                                <!-- start apple store button -->
                                <a target="_blank"
                                    class="align-items-center app-btn d-flex px-3 py-2 rounded-3 text-decoration-none text-white border"
                                    href="https://apps.apple.com/br/app/ticket-maker/id1535492459"> <i
                                        class="fa-apple fab fs-28 me-2"></i>
                                    <div> <span class="fs-13 d-block">Available on the</span> <span
                                            class="fs-17 text-capitalize">App Store</span> </div>
                                </a>
                                <!-- end /. apple store button -->
                                <a target="_blank"
                                    class="align-items-center app-btn d-flex fs-11 px-3 py-2 rounded-3 text-decoration-none text-white border"
                                    href="https://play.google.com/store/apps/details?id=digita.ticketmaker.app&hl=pt_BR&gl=US&pli=1">
                                    <i class="fab fa-google-play fs-25 me-2"></i>
                                    <div> <span class="fs-13 d-block">Get it on</span> <span
                                            class="fs-17 text-capitalize">Google Play</span> </div>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="border-top py-5">
                <div class="footer-row row gy-5 g-sm-5 gx-xxl-6">
                    <div class="border-end col-lg-4 col-md-7 col-sm-6">
                        <h5 class="fw-bold mb-4">Informações de contato</h5>
                        <div class="rounded-4 p-4 mb-4">
                            <h6 class="text-white-50 mb-3">Telefone:</h6>
                            <a class="align-items-center d-block d-flex whatsapp-number" href="#"><i
                                    class="fa fa-phone fs-12 me-2"></i>
                                <span class="fs-12 fw-semibold"><?php echo e(env('TELEFONE')); ?></span>
                            </a>

                            <h6 class="text-white-50 mb-3 mt-3">Email:</h6>
                            <a class="align-items-center d-block d-flex whatsapp-number"
                                href="<?php echo e(env('EMAIL')); ?>"><i class="fa fa-envelope fs-12 me-2"></i>
                                <span class="fs-12 fw-semibold"><?php echo e(env('EMAIL')); ?></span>
                            </a>
                        </div>
                    </div>
                    <div class="border-end col-lg-4 col-md-5 col-sm-6">
                        <h5 class="fw-bold mb-4"><?php echo e(env('APP_NAME')); ?></h5>
                        <p>CNPJ: 11.233.543/0001-75</p>
                        <p><?php echo e(env('ENDERECO')); ?></p>
                    </div>
                    <div class="col-lg-4">
                        <h5 class="fw-bold mb-4">Redes Sociais</h5>
                        <!-- start social icon -->
                        <ul class="d-flex flex-wrap gap-2 list-unstyled mb-0 social-icon">
                            <li>
                                <a href="https://www.instagram.com/ticket.maker/" target="_blank"
                                    class="rounded-circle align-items-center d-flex fs-19 icon-wrap justify-content-center rounded-2 text-white inst">
                                    <i class="fab fa-instagram"></i>
                                </a>
                            </li>
                            
                        </ul>
                        <!-- /. end social icon -->
                    </div>
                </div>
            </div>
        </div>
        <div class="container border-top">
            <div class="align-items-center g-3 py-4 row">
                <div class="col-lg-auto order-md-first">
                    <ul class="list-unstyled list-separator mb-2 footer-nav">
                        <li class="list-inline-item"><a href="<?php echo e(route('site.quem.somos')); ?>">Quem Somos</a></li>
                        <li class="list-inline-item"><a href="<?php echo e(route('site.servicos')); ?>">Serviços</a></li>
                        <li class="list-inline-item"><a href="<?php echo e(route('site.politica.reembolso')); ?>">Política de
                                Reembolso</a></li>
                        <li class="list-inline-item"><a href="<?php echo e(route('site.politica.privacidade')); ?>">Política de
                                Privacidade</a></li>
                        <li class="list-inline-item"><a href="<?php echo e(route('site.politica.cookies')); ?>">Política de
                                Cookies</a></li>
                    </ul>
                </div>
                <div class="col-lg">
                    <div class="align-items-center row " style="float: right;">
                        <div class="col-sm-auto copy fs-12 pull-right">© <?php echo e(date('Y')); ?> <?php echo e(env('APP_NAME')); ?>.
                            Todos os direitos reservados.</div>
                    </div>
                </div>
            </div>
        </div>
    </footer>

    <div class="modal fade" id="modal-estados" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered  modal-sm">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title fs-18">Selecione um Estado</h5>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="mb-3 menu pb-2">
                                <div class="col-auto">
                                    <div class="form-check">
                                        <input name="estado" <?php echo e(session()->get('estado') == 'All' ? 'checked' : ''); ?>

                                            class="form-check-input estado-radio" type="radio" value="All"
                                            id="all">
                                        <label class="form-check-label" for="all">
                                            Todos os Estados
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <?php $__currentLoopData = $set_estado; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $estado): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="mb-3 menu pb-2">
                                    <div class="col-auto">
                                        <div class="form-check">

                                            <?php if(isset($escreve_estado[$estado['estado']])): ?>
                                                <input name="estado" <?php echo e(session()->get('estado') == $estado['estado'] ? 'checked' : ''); ?> class="form-check-input estado-radio" type="radio" value="<?php echo e($estado['estado']); ?>" id="<?php echo e(setUri($estado['estado'])); ?>">
                                                <label class="form-check-label" for="<?php echo e(setUri($estado['estado'])); ?>">
                                                    <?php echo e($escreve_estado[$estado['estado']]); ?>

                                                </label>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="modal-busca" tabindex="-1" style="background: transparent;">
        <div class="modal-dialog modal-dialog-centered  modal-lg">
            <div class="modal-content" style="background: transparent;">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-sm-12">
                            <!-- start search content -->
                            <div class="bg-white d-flex position-relative search-wrapper">
                                <div class="align-items-center d-flex search-field w-100">
                                    <div class="svg-icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                            fill="currentColor" class="bi bi-search" viewBox="0 0 16 16">
                                            <path
                                                d="M11.742 10.344a6.5 6.5 0 1 0-1.397 1.398h-.001c.03.04.062.078.098.115l3.85 3.85a1 1 0 0 0 1.415-1.414l-3.85-3.85a1.007 1.007 0 0 0-.115-.1zM12 6.5a5.5 5.5 0 1 1-11 0 5.5 5.5 0 0 1 11 0z">
                                            </path>
                                        </svg>
                                    </div>
                                    <!-- start input -->
                                    <input type="email" class="form-control search-input"
                                        placeholder="O que você está procurando?">
                                    <!-- end /. input -->
                                </div>
                                <input type="submit" value="Buscar" class="btn btn-primary rounded-5 mt-3 mt-md-0">
                            </div>
                            <!-- end /. search content -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div id="modal-central-de-ajuda" class="modal fade" tabindex="-1" role="dialog"
        aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-xl">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="myModalLabel">Central de Ajuda</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form action="<?php echo e(route('contato.store')); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="row">
                            <h5 class="text-primary">ATENÇÃO!</h5>
                            <h5 class="mb-5">Solicitações de cancelamentos devem ser realizadas pelo titular do
                                registro.</h5>
                            <div class="col-md-4 col-xl-4">
                                <div class="mb-4">
                                    <label class="required fw-medium mb-2">Nome Completo</label>
                                    <input value="<?php echo e(old('nome')); ?>" name="nome" type="text"
                                        class="form-control" id="firstName" placeholder="Nome Completo"
                                        required="">
                                </div>
                                <div class="mb-4">
                                    <label class="required fw-medium mb-2">Assunto </label>
                                    <input required value="<?php echo e(old('assunto')); ?>" name="assunto" type="text"
                                        class="form-control" placeholder="Assunto">
                                </div>
                                <div class="mb-4" style="margin-top: 45px;">
                                    <label class="required fw-medium mb-2">Número do Registro </label>
                                    <input required value="<?php echo e(old('registro')); ?>" name="registro" type="text"
                                        class="form-control" placeholder="Número do Registro">
                                </div>
                            </div>
                            <div class="col-md-4 col-xl-4">
                                <div class="mb-4">
                                    <label class="required fw-medium mb-2">Telefone (whatsapp) </label>
                                    <input required value="<?php echo e(old('celular')); ?>" name="celular" type="tel"
                                        class="form-control" id="celular" placeholder="Telefone (whatsapp)">
                                </div>
                                <div class="mb-4">
                                    <label class="required fw-medium mb-2">Como podemos te ajudar? </label>
                                    <select required name="ajuda" id="" class="form-control">
                                        <option value="">—Escolha uma opção—</option>
                                        <option
                                            <?php echo e(old('ajuda') == 'Problema com o pagamento do meu pedido' ? 'selected' : ''); ?>

                                            value="Problema com o pagamento do meu pedido">Problema com o pagamento do
                                            meu
                                            pedido</option>
                                        <option <?php echo e(old('ajuda') == 'Acessar meus ingressos' ? 'selected' : ''); ?>

                                            value="Acessar meus ingressos">Acessar meus ingressos</option>
                                        <option
                                            <?php echo e(old('ajuda') == 'Repassar / trocar meu ingresso para outra pessoa' ? 'selected' : ''); ?>

                                            value="Repassar / trocar meu ingresso para outra pessoa">Repassar / trocar
                                            meu
                                            ingresso para outra pessoa</option>
                                        <option
                                            <?php echo e(old('ajuda') == 'Dúvidas para comprar / retirar ingressos' ? 'selected' : ''); ?>

                                            value="Dúvidas para comprar / retirar ingressos">Dúvidas para comprar /
                                            retirar
                                            ingressos</option>
                                        <option
                                            <?php echo e(old('ajuda') == 'Dúvidas sobre cancelamento e reembolso' ? 'selected' : ''); ?>

                                            value="Dúvidas sobre cancelamento e reembolso">Dúvidas sobre cancelamento e
                                            reembolso</option>
                                        <option
                                            <?php echo e(old('ajuda') == 'Corrigir / alterar algum dado do meu ingresso ou formulário' ? 'selected' : ''); ?>

                                            value="Corrigir / alterar algum dado do meu ingresso ou formulário">
                                            Corrigir /
                                            alterar algum dado do meu ingresso ou formulário</option>
                                        <option <?php echo e(old('ajuda') == 'Informações sobre o evento' ? 'selected' : ''); ?>

                                            value="Informações sobre o evento">Informações sobre o evento</option>
                                        <option
                                            <?php echo e(old('ajuda') == 'Quero falar com a organização do evento' ? 'selected' : ''); ?>

                                            value="Quero falar com a organização do evento">Quero falar com a
                                            organização
                                            do evento</option>
                                        <option <?php echo e(old('ajuda') == 'Sugestão ou feedback' ? 'selected' : ''); ?>

                                            value="Sugestão ou feedback">Sugestão ou feedback</option>
                                        <option <?php echo e(old('ajuda') == 'Outro assunto' ? 'selected' : ''); ?>

                                            value="Outro assunto">Outro assunto</option>
                                    </select>
                                </div>
                                <div class="mb-4">
                                    <label class="required fw-medium mb-2">Data do evento (informe a data do evento que
                                        participou ou deseja participar) </label>
                                    <input required value="<?php echo e(old('data_evento')); ?>" name="data_evento"
                                        type="date" class="form-control"
                                        laceholder="Data do evento (informe a data do evento que participou ou deseja participar) ">
                                </div>
                            </div>
                            <div class="col-md-4 col-xl-4">
                                <div class="mb-4">
                                    <label class="required fw-medium mb-2">E-mail</label>
                                    <input required value="<?php echo e(old('email')); ?>" name="email" type="email"
                                        class="form-control" id="email" placeholder="E-mail">
                                </div>
                                <div class="mb-4">
                                    <label class="required fw-medium mb-2">Descrição </label>
                                    <textarea name="msg" class="form-control" rows="7" placeholder="Informe como podemos lhe ajudar"><?php echo e(old('msg')); ?></textarea>
                                </div>
                                <div class="g-recaptcha" data-sitekey="<?php echo e(env('RECAPTCHA_SITE_KEY')); ?>"></div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <div class="row">
                            <div class="col-6">
                                <button type="submit" class="btn btn-primary">Enviar</button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
    <input name="cookieData" type="hidden" data-cookie-customDialogSelector="null" data-cookie-colorText="#424a4d"
        data-cookie-colorBg="rgba(234, 239, 241, 0.99)" data-cookie-textButton="Aceitar e Fechar"
        data-cookie-colorButton="" data-cookie-colorLink="#424a4d" data-cookie-underlineLink="true"
        data-cookie-text="Utilizamos cookies e outras tecnologias para personalizar conteúdo e anúncios, fornecer recursos de mídia social de seu interesse e analisar o tráfego. Ao utilizar nossos serviços, você concorda com tal monitoramento. Informamos ainda que atualizamos nossa <a href='<?php echo e(route('site.politica.privacidade')); ?>'>Política de Privacidade</a> e <a href='<?php echo e(route('site.politica.cookies')); ?>'>Política de Cookies</a>.">

    <!-- end /. footer -->
    <!-- Optional JavaScript -->
    <script src="<?php echo e(url('site')); ?>/assets/plugins/jQuery/jquery.min.js"></script>
    <script src="<?php echo e(url('site')); ?>/assets/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="<?php echo e(url('site')); ?>/assets/plugins/aos/aos.min.js"></script>
    <script src="<?php echo e(url('site')); ?>/assets/plugins/macy/macy.js"></script>
    <script src="<?php echo e(url('site')); ?>/assets/plugins/simple-parallax/simpleParallax.min.js"></script>
    <script src="<?php echo e(url('site')); ?>/assets/plugins/OwlCarousel2/owl.carousel.min.js"></script>
    <script src="<?php echo e(url('site')); ?>/assets/plugins/theia-sticky-sidebar/ResizeSensor.min.js"></script>
    <script src="<?php echo e(url('site')); ?>/assets/plugins/theia-sticky-sidebar/theia-sticky-sidebar.min.js"></script>
    <script src="<?php echo e(url('site')); ?>/assets/plugins/waypoints/jquery.waypoints.min.js"></script>
    <script src="<?php echo e(url('site')); ?>/assets/plugins/counter-up/jquery.counterup.min.js"></script>
    <script src="<?php echo e(url('site')); ?>/assets/plugins/jquery-fancyfileuploader/fancy-file-uploader/jquery.ui.widget.js">
    </script>
    <script src="<?php echo e(url('site')); ?>/assets/plugins/jquery-fancyfileuploader/fancy-file-uploader/jquery.fileupload.js">
    </script>
    <script
        src="<?php echo e(url('site')); ?>/assets/plugins/jquery-fancyfileuploader/fancy-file-uploader/jquery.iframe-transport.js">
    </script>
    <script
        src="<?php echo e(url('site')); ?>/assets/plugins/jquery-fancyfileuploader/fancy-file-uploader/jquery.fancy-fileupload.js">
    </script>
    <script src="<?php echo e(url('site')); ?>/assets/plugins/ion.rangeSlider/ion.rangeSlider.min.js"></script>
    <script src="<?php echo e(url('site')); ?>/assets/plugins/magnific-popup/jquery.magnific-popup.min.js"></script>
    <script src="<?php echo e(url('site')); ?>/assets/plugins/select2/select2.min.js"></script>
    <!-- Custom script for this template -->
    <script src="<?php echo e(url('site')); ?>/assets/js/script.js"></script>

    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>


    <script>


        // Adicione um identificador exclusivo para os radio buttons, por exemplo, a classe 'estado-radio'
        var escreve_estado = {
            'ALAGOAS': 'Alagoas',
            'AMAPÁ': 'Amapá',
            'AMAZONAS': 'Amazonas',
            'BAHIA': 'Bahia',
            'CEARÁ': 'Ceará',
            'DISTRITO FEDERAL': 'Distrito Federal',
            'ESPÍRITO SANTO': 'Espírito Santo',
            'GOIÁS': 'Goiás',
            'MARANHÃO': 'Maranhão',
            'MATO GROSSO': 'Mato Grosso',
            'MATO GROSSO DO SUL': 'Mato Grosso do Sul',
            'MINAS GERAIS': 'Minas Gerais',
            'PARÁ': 'Pará',
            'PARAÍBA': 'Paraíba',
            'PARANÁ': 'Paraná',
            'PERNAMBUCO': 'Pernambuco',
            'PIAUÍ': 'Piauí',
            'RIO DE JANEIRO': 'Rio de Janeiro',
            'RIO GRANDE DO NORTE': 'Rio Grande do Norte',
            'RIO GRANDE DO SUL': 'Rio Grande do Sul',
            'RONDÔNIA': 'Rondônia',
            'RORAIMA': 'Roraima',
            'SANTA CATARINA': 'Santa Catarina',
            'SÃO PAULO': 'São Paulo',
            'SERGIPE': 'Sergipe',
            'TOCANTINS': 'Tocantins',
            // Adicione outros estados conforme necessário
        };

        var eventoExecutado = false;
        $('.estado-radio').change(function() {
            eventoExecutado = true;
            var estadoSelecionado = $('input[name="estado"]:checked').val();

            // Faça a chamada AJAX somente se um radio button estiver selecionado
            if (estadoSelecionado) {
                $('#modal-estados').modal('hide');
                $("#ec-overlay").removeClass('d-none');
                $('#navbarSupportedContent').collapse('hide');
                $("#nav-icon").removeClass('open');

                $('#carregando').removeClass('d-none');
                $('#top10').addClass('d-none');

                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });

                $.ajax({
                    url: "<?php echo e(route('get.eventos.estado')); ?>",
                    method: 'POST',
                    data: {
                        estado: estadoSelecionado
                    },
                    success: function(result) {
                        $("#ec-overlay").addClass('d-none');
                        var nomeEstado = escreve_estado[estadoSelecionado] ||
                            ''; // Obtém o nome do estado
                        if (nomeEstado) {
                            $("#box_estado").removeClass('d-none');
                        } else {
                            $("#box_estado").addClass('d-none');
                        }
                        $("#estado_nome").text(nomeEstado);
                        $("#titulo").text('');
                        $("#box_titulo").addClass('d-none');
                        $("#menu-estado").text(estadoSelecionado == 'All' ? 'Todos os estados' :
                            nomeEstado);
                        $('#modal-estados').modal('hide');
                        $("#eventos").html(result);

                        $.ajax({
                            url: "<?php echo e(route('get.eventos.top10')); ?>",
                            method: 'POST',
                            data: {
                                estado: estadoSelecionado
                            },
                            success: function(result) {
                                $('#carregando').addClass('d-none');
                                $('#top10').removeClass('d-none');
                                $("#top10").html(result);
                                if ($('.blog-carousel').data('owl.carousel')) {
                                    $('.blog-carousel').trigger('destroy.owl.carousel');
                                }
                                initCarousel();


                                $.ajax({
                                    url: "<?php echo e(route('get.eventos.hoje')); ?>",
                                    method: 'POST',
                                    data: {
                                        estado: estadoSelecionado
                                    },
                                    success: function(result) {
                                        $("#eventos-hoje").html(result);
                                    }
                                });

                            }
                        });
                    }
                });
            }
        });
        $(document).ready(function() {
            <?php if(count($set_estado) > 1): ?>
                <?php if(empty(session()->get('estado'))): ?>
                    eventoExecutado = true;
                    $('#modal-estados').modal('show');
                <?php endif; ?>
            <?php endif; ?>
        });

        function initCarousel() {
            if ($('.blog-carousel').length) {
                var owl = $(".blog-carousel");

                owl.owlCarousel({
                    loop: false,
                    margin: 24,
                    rewind: false,
                    nav: false,
                    navText: [
                        '<i class="fa-solid fa-arrow-left"></i>',
                        '<i class="fa-solid fa-arrow-right"></i>'
                    ],
                    responsive: {
                        0: {
                            items: 2,
                        },
                        576: {
                            items: 2,
                        },
                        992: {
                            items: 4,
                        }
                    }
                })
            }
        }


        function CategoriaShow(elemento) {
            var categoria = $(elemento).data('value');
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: "<?php echo e(route('get.eventos.categoria')); ?>",
                method: 'POST',
                data: {
                    categoria
                },
                success: function(result) {
                    $("#box_titulo_categoria").removeClass('d-none');
                    $("#eventos").html(result);
                    $("#titulo").text(categoria);
                    window.location.href = '#proximos-eventos';
                    console.log(categoria);
                }
            });
        }

        $(document).ready(function() {
            $("#buscar").keyup(function() {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    url: "<?php echo e(route('buscar')); ?>",
                    method: 'POST',
                    data: {
                        buscar: $("#buscar").val()
                    },
                    success: function(result) {
                        $("#eventos").html(result);
                        window.location.href = '#proximos-eventos';
                    }
                });
            });
        });

        function Add(id) {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: "<?php echo e(route('add.view')); ?>",
                method: 'POST',
                data: {
                    id
                }
            });
        }


        $(document).ready(function() {
            <?php if(session('success')): ?>
                Swal.fire({
                    icon: "success",
                    title: "Obrigado",
                    text: "<?php echo e(session('success')); ?>",
                    showConfirmButton: true,
                    customClass: {
                        confirmButton: 'btn btn-primary' // Adicione a classe desejada ao botão de confirmação
                    },
                });
                setTimeout(() => {
                    Swal.close();
                }, 3000);
            <?php endif; ?>

            <?php if(session('error')): ?>
                Swal.fire({
                    icon: "error",
                    title: "Atenção",
                    text: "<?php echo e(session('error')); ?>",
                    showConfirmButton: true,
                    customClass: {
                        confirmButton: 'btn btn-primary' // Adicione a classe desejada ao botão de confirmação
                    },
                });
                setTimeout(() => {
                    Swal.close();
                    $('#modal-central-de-ajuda').modal('show');
                }, 3000);
            <?php endif; ?>

        });
    </script>

    <script src="<?php echo e(url('site')); ?>/assets/js/cookie-alert.js"></script>

    <?php echo $__env->yieldContent('js'); ?>
</body>

</html>
<?php /**PATH F:\Laravel\TicketMaker\resources\views/site/index.blade.php ENDPATH**/ ?>