<!doctype html>
<html lang="en">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <link rel="shortcut icon" href="<?php echo e(url('site')); ?>/assets/images/favicon.png">
    <title><?php echo e(env('APP_NAME')); ?> - Os melhores eventos estão aqui!</title>
    <link href="<?php echo e(url('site')); ?>/assets/plugins/aos/aos.min.css" rel="stylesheet">
    <link href="<?php echo e(url('site')); ?>/assets/plugins/bootstrap/css/bootstrap.min.css?v=6" rel="stylesheet">
    <link href="<?php echo e(url('site')); ?>/assets/plugins/fontawesome/css/all.min.css" rel="stylesheet">
    <link href="<?php echo e(url('site')); ?>/assets/plugins/OwlCarousel2/css/owl.carousel.min.css?v=5" rel="stylesheet">
    <link href="<?php echo e(url('site')); ?>/assets/plugins/OwlCarousel2/css/owl.theme.default.min.css" rel="stylesheet">
    <link href="<?php echo e(url('site')); ?>/assets/plugins/jquery-fancyfileuploader/fancy-file-uploader/fancy_fileupload.css"
        rel="stylesheet">
    <link href="<?php echo e(url('site')); ?>/assets/plugins/ion.rangeSlider/ion.rangeSlider.min.css" rel="stylesheet">
    <link href="<?php echo e(url('site')); ?>/assets/plugins/magnific-popup/magnific-popup.css" rel="stylesheet">
    <link href="<?php echo e(url('site')); ?>/assets/plugins/select2/select2.min.css" rel="stylesheet">
    <link href="<?php echo e(url('site')); ?>/assets/plugins/select2-bootstrap-5/select2-bootstrap-5-theme.min.css"
        rel="stylesheet">

    <!-- Custom style for this template -->
    <link href="<?php echo e(url('site')); ?>/assets/css/style.css?v=<?php echo e(rand()); ?>" rel="stylesheet">
    <div class="sempreDireita">
        <a href="javascript:void(0)" data-bs-toggle="modal" data-bs-target="#modal-central-de-ajuda">
            <img src="<?php echo e(url('site/assets/images/interrogation-mark.png')); ?>" width="20" style="margin-right: 5px">
            Central de Ajuda
        </a>
    </div>
    <meta name="description" content="<?php echo $__env->yieldContent('description'); ?>">
    <link rel="canonical" href="" />
    <meta property="og:url" content="<?php echo $__env->yieldContent('url'); ?>">
    <meta property="og:type" content="website" />
    <meta property="og:title" content="<?php echo $__env->yieldContent('titulo'); ?>" />
    <meta property="og:description" content="<?php echo $__env->yieldContent('description'); ?>" />
    <meta property="og:image" content="<?php echo $__env->yieldContent('image'); ?>" />
    <meta property="og:image:secure_url" content="<?php echo $__env->yieldContent('image'); ?>" />

    <script src="https://www.google.com/recaptcha/api.js"></script>
    <style>
        .text-danger {
            color: red;
        }
    </style>
    <?php echo $__env->yieldContent('css'); ?>
</head>

<body>
    <div id="ec-overlay" class="d-none">
        <div class="ec-ellipsis">
            <div></div>
            <div></div>
            <div></div>
            <div></div>
        </div>
    </div>
    <nav class="bg-white navbar navbar-expand-lg navbar-light sticky-top" style="border-bottom: 2px solid#1166B0;">
        <div class="container">
            <a class="navbar-brand" href="<?php echo e(route('site.home')); ?>">
                <img src="<?php echo e(url('site')); ?>/assets/images/logo.png" alt="">
            </a>
            <div class="d-flex order-lg-2">
                <div class="gap-2 btn btn-outline-primary d-none d-sm-flex fw-medium hstack rounded-2"
                    style="cursor: default;">
                    <span class="d-none d-sm-inline-block btn-cliente">
                        <a class="fs-14" href="https://vendas.ticketmaker.com.br/Login" target="_blank"
                            rel="noopener noreferrer">Login</a>
                    </span>
                    <div class="vr d-none d-sm-inline-block"></div>
                    <span class="d-none d-sm-inline-block btn-cliente">
                        <a class="fs-14" href="https://vendas.ticketmaker.com.br/Login" target="_blank"
                            rel="noopener noreferrer">Cadastre-se</a>
                    </span>
                </div>
                <button class="navbar-toggler" type="button" data-bs-toggle="collapse"
                    data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent"
                    aria-expanded="false" aria-label="Toggle navigation">
                    <span id="nav-icon">
                        <span></span>
                        <span></span>
                        <span></span>
                    </span>
                </button>
            </div>

            <div class="collapse navbar-collapse margin-menu" id="navbarSupportedContent">
                <ul class="m-auto mb-2 navbar-nav mb-lg-0">
                    <li class="nav-item"><a class="nav-link" href="<?php echo e(route('site.home')); ?>">Home</a></li>
                    <li class="nav-item"><a class="nav-link" href="https://organizador.ticketmaker.com.br/">Organize seu
                            Evento</a></li>
                    <li class="nav-item">
                        <a class="nav-link" href="javascript:void(0)" data-bs-toggle="modal"
                            data-bs-target="#modal-estados">
                            <img src="<?php echo e(url('site')); ?>/assets/images/location.png" width="20">
                            <span
                                id="menu-estado"><?php echo e(empty(session()->get('estado')) || session()->get('estado') == 'All' ? 'Selecione seu estado' : session()->get('estado')); ?></span>
                            <i class="fa fa-angle-down" style="margin-left: 10px"></i>
                        </a>
                    </li>
                    <li style="text-align: center;" class="d-none d-md-block">
                        <div class="mb-2 input-group-busca">
                            <input id="buscar" type="text"
                                placeholder="Buscar por eventos, categorias e locais" class="shadow form-busca">
                            <button class="shadow btn btn-white btn-busca" type="button">
                                <i class="fa fa-search text-blue"></i>
                            </button>
                        </div>
                    </li>
                </ul>
                <div class="d-sm-none">
                    <a href="https://vendas.ticketmaker.com.br/Login"
                        class="gap-2 btn btn-primary d-flex hstack justify-content-center rounded-3">
                        <i class="fa-solid fa-user"></i>
                        <div class="vr d-none d-sm-inline-block"></div>
                        <span>Login</span>
                    </a>
                </div>
                <div class="mt-1 d-sm-none">
                    <a href="https://vendas.ticketmaker.com.br/Login/Cadastro"
                        class="gap-2 btn btn-primary d-flex hstack justify-content-center rounded-3">
                        <i class="fa-solid fa-user-plus"></i>
                        <div class="vr d-none d-sm-inline-block"></div>
                        <span>Cadastre-se</span>
                    </a>
                </div>
            </div>
        </div>
    </nav>
    <?php echo $__env->yieldContent('content'); ?>
    <footer class="pt-5 overflow-hidden footer-dark main-footer position-relative">
        <div class="container pt-4">
            <div class="py-5">
                <!-- start app download content -->
                <div class="bg-ticket-maker rounded-4 top-footer">
                    <div
                        class="gap-4 px-0 mx-auto col-xxl-10 col-md-11 col-10 d-flex flex-md-row flex-column-reverse align-items-md-end align-items-center">
                        <img class="flex-shrink-0 app-image" src="<?php echo e(url('site')); ?>/assets/images/phone-mpckup.png"
                            width="270" alt="Mobile app">
                        <div
                            class="pt-5 text-center align-items-lg-center align-self-center d-flex flex-column flex-lg-row ps-xxl-4 py-md-3 text-md-start">
                            <div class="me-md-5">
                                <h4 class="text-white fs-20">Os melhores eventos estão aqui!</h4>
                                <p class="text-white mb-lg-0">Baixe nosso app e confira todos os eventos disponíveis.
                                    Descubra o seu próximo rolê na Ticket Maker.</p>
                            </div>
                            <div class="flex-wrap flex-shrink-0 gap-3 d-flex justify-content-center">
                                <!-- start apple store button -->
                                <a target="_blank"
                                    class="px-3 py-2 text-white border align-items-center app-btn d-flex rounded-3 text-decoration-none"
                                    href="https://apps.apple.com/br/app/ticket-maker/id1535492459"> <i
                                        class="fa-apple fab fs-28 me-2"></i>
                                    <div> <span class="fs-13 d-block">Available on the</span> <span
                                            class="fs-17 text-capitalize">App Store</span> </div>
                                </a>
                                <!-- end /. apple store button -->
                                <a target="_blank"
                                    class="px-3 py-2 text-white border align-items-center app-btn d-flex fs-11 rounded-3 text-decoration-none"
                                    href="https://play.google.com/store/apps/details?id=digita.ticketmaker.app&hl=pt_BR&gl=US&pli=1">
                                    <i class="fab fa-google-play fs-25 me-2"></i>
                                    <div> <span class="fs-13 d-block">Get it on</span> <span
                                            class="fs-17 text-capitalize">Google Play</span> </div>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="py-5 border-top">
                <div class="footer-row row gy-5 g-sm-5 gx-xxl-6">
                    <div class="border-end col-lg-4 col-md-7 col-sm-6">
                        <h5 class="mb-4 fw-bold">Informações de contato</h5>
                        <div class="p-4 mb-4 rounded-4">
                            <h6 class="mb-3 text-white-50">Telefone:</h6>
                            <a class="align-items-center d-block d-flex whatsapp-number" href="#"><i
                                    class="fa fa-phone fs-12 me-2"></i>
                                <span class="fs-12 fw-semibold"><?php echo e(env('TELEFONE')); ?></span>
                            </a>

                            <h6 class="mt-3 mb-3 text-white-50">Email:</h6>
                            <a class="align-items-center d-block d-flex whatsapp-number"
                                href="<?php echo e(env('EMAIL')); ?>"><i class="fa fa-envelope fs-12 me-2"></i>
                                <span class="fs-12 fw-semibold"><?php echo e(env('EMAIL')); ?></span>
                            </a>
                        </div>
                    </div>
                    <div class="border-end col-lg-4 col-md-5 col-sm-6">
                        <h5 class="mb-4 fw-bold"><?php echo e(env('APP_NAME')); ?></h5>
                        <p>CNPJ: 11.233.543/0001-75</p>
                        <p><?php echo e(env('ENDERECO')); ?></p>
                    </div>
                    <div class="col-lg-4">
                        <h5 class="mb-4 fw-bold">Redes Sociais</h5>
                        <!-- start social icon -->
                        <ul class="flex-wrap gap-2 mb-0 d-flex list-unstyled social-icon">
                            <li>
                                <a href="https://www.instagram.com/ticket.maker/" target="_blank"
                                    class="text-white rounded-circle align-items-center d-flex fs-19 icon-wrap justify-content-center rounded-2 inst">
                                    <i class="fab fa-instagram"></i>
                                </a>
                            </li>
                            
                        </ul>
                        <!-- /. end social icon -->
                    </div>
                </div>
            </div>
        </div>
        <div class="container border-top">
            <div class="py-4 align-items-center g-3 row">
                <div class="col-lg-auto order-md-first">
                    <ul class="mb-2 list-unstyled list-separator footer-nav">
                        <li class="list-inline-item"><a href="<?php echo e(route('site.quem.somos')); ?>">Quem Somos</a></li>
                        <li class="list-inline-item"><a href="<?php echo e(route('site.servicos')); ?>">Serviços</a></li>
                        <li class="list-inline-item"><a href="<?php echo e(route('site.politica.reembolso')); ?>">Política de
                                Reembolso</a></li>
                        <li class="list-inline-item"><a href="<?php echo e(route('site.politica.privacidade')); ?>">Política de
                                Privacidade</a></li>
                        <li class="list-inline-item"><a href="<?php echo e(route('site.politica.cookies')); ?>">Política de
                                Cookies</a></li>
                    </ul>
                </div>
                <div class="col-lg">
                    <div class="align-items-center row " style="float: right;">
                        <div class="col-sm-auto copy fs-12 pull-right">© <?php echo e(date('Y')); ?> <?php echo e(env('APP_NAME')); ?>.
                            Todos os direitos reservados.</div>
                    </div>
                </div>
            </div>
        </div>
    </footer>

    <div class="modal fade" id="campanha" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered modal">
            <div class="modal-content" style="background: none; border:none;">
                <div class="modal-body" style="background: none; border:none; position: relative;">
                    <!-- Ícone de Fechar -->
                    <button onclick="CloseCampanha()"
                        style="position: absolute; top: 10px; right: 10px; background: white; border-radius: 50%; width: 30px; height: 30px; border: none; display: flex; align-items: center; justify-content: center; box-shadow: 0px 0px 10px rgba(0,0,0,0.2); cursor: pointer;">
                        <span style="font-size: 20px; font-weight: bold;">&times;</span>
                    </button>

                    <a href="javascript:void(0)" onclick="javascript:OpenCampanha()">
                        <img src="<?php echo e(url('/storage/campanhas/carnaval-2025.jpg')); ?>" style="width:100%;">
                    </a>
                </div>
            </div>
        </div>
    </div>




    <div class="modal fade" id="modal-estados" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered modal-sm">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title fs-18">Selecione um Estado</h5>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="pb-2 mb-3 menu">
                                <div class="col-auto">
                                    <div class="form-check">
                                        <input name="estado" <?php echo e(session()->get('estado') == 'All' ? 'checked' : ''); ?>

                                            class="form-check-input estado-radio" type="radio" value="All"
                                            id="all">
                                        <label class="form-check-label" for="all">
                                            Todos os Estados
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <?php $__currentLoopData = $set_estado; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $estado): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="pb-2 mb-3 menu">
                                    <div class="col-auto">
                                        <div class="form-check">
                                            <?php if(isset($estado->nome)): ?>
                                                <input name="estado"  <?php echo e(session()->get('estado') == $estado->nome ? 'checked' : ''); ?> class="form-check-input estado-radio" type="radio" value="<?php echo e($estado->nome); ?>" id="<?php echo e(setUri($estado->nome)); ?>">
                                                <label class="form-check-label"
                                                    for="<?php echo e(setUri($estado->nome)); ?>">
                                                    <?php echo e($estado->nome); ?>

                                                </label>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <div class="modal fade" id="modal-busca" tabindex="-1" style="background: transparent;">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content" style="background: transparent;">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-sm-12">
                            <!-- start search content -->
                            <div class="bg-white d-flex position-relative search-wrapper">
                                <div class="align-items-center d-flex search-field w-100">
                                    <div class="svg-icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                            fill="currentColor" class="bi bi-search" viewBox="0 0 16 16">
                                            <path
                                                d="M11.742 10.344a6.5 6.5 0 1 0-1.397 1.398h-.001c.03.04.062.078.098.115l3.85 3.85a1 1 0 0 0 1.415-1.414l-3.85-3.85a1.007 1.007 0 0 0-.115-.1zM12 6.5a5.5 5.5 0 1 1-11 0 5.5 5.5 0 0 1 11 0z">
                                            </path>
                                        </svg>
                                    </div>
                                    <!-- start input -->
                                    <input type="email" class="form-control search-input"
                                        placeholder="O que você está procurando?">
                                    <!-- end /. input -->
                                </div>
                                <input type="submit" value="Buscar" class="mt-3 btn btn-primary rounded-5 mt-md-0">
                            </div>
                            <!-- end /. search content -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div id="modal-central-de-ajuda" class="modal fade" tabindex="-1" role="dialog"
        aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-xl">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="myModalLabel">Central de Ajuda</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form action="<?php echo e(route('contato.store')); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="row">
                            <h5 class="text-primary">ATENÇÃO!</h5>
                            <h5 class="mb-5 text-danger">Solicitações de cancelamentos devem ser realizadas pelo
                                titular do registro.</h5>
                            <div class="col-md-4 col-xl-4">
                                <div class="mb-4">
                                    <label class="mb-2 required fw-medium">Nome Completo</label>
                                    <input value="<?php echo e(old('nome')); ?>" name="nome" type="text"
                                        class="form-control" id="firstName" placeholder="Nome Completo"
                                        required="">
                                </div>
                                <div class="mb-4">
                                    <label class="mb-2 required fw-medium">Assunto </label>
                                    <input required value="<?php echo e(old('assunto')); ?>" name="assunto" type="text"
                                        class="form-control" placeholder="Assunto">
                                </div>
                                <div class="mb-4" style="margin-top: 45px;">
                                    <label class="mb-2 required fw-medium">Número do Registro </label>
                                    <input required value="<?php echo e(old('registro')); ?>" name="registro" type="text"
                                        class="form-control" placeholder="Número do Registro">
                                </div>
                            </div>
                            <div class="col-md-4 col-xl-4">
                                <div class="mb-4">
                                    <label class="mb-2 required fw-medium">Telefone (whatsapp) </label>
                                    <input required value="<?php echo e(old('celular')); ?>" name="celular" type="tel"
                                        class="form-control" id="celular" placeholder="Telefone (whatsapp)">
                                </div>
                                <div class="mb-4">
                                    <label class="mb-2 required fw-medium">Como podemos te ajudar? </label>
                                    <select required name="ajuda" id="" class="form-control">
                                        <option value="">—Escolha uma opção—</option>
                                        <option <?php echo e(old('ajuda') == 'Problema com o pagamento do meu pedido' ? 'selected' : ''); ?> value="Problema com o pagamento do meu pedido">Problema com o pagamento do meu pedido</option>
                                        <option <?php echo e(old('ajuda') == 'Acessar meus ingressos' ? 'selected' : ''); ?>

                                            value="Acessar meus ingressos">Acessar meus ingressos</option>
                                        <option
                                            <?php echo e(old('ajuda') == 'Repassar / trocar meu ingresso para outra pessoa' ? 'selected' : ''); ?>

                                            value="Repassar / trocar meu ingresso para outra pessoa">Repassar / trocar
                                            meu
                                            ingresso para outra pessoa</option>
                                        <option
                                            <?php echo e(old('ajuda') == 'Dúvidas para comprar / retirar ingressos' ? 'selected' : ''); ?>

                                            value="Dúvidas para comprar / retirar ingressos">Dúvidas para comprar /
                                            retirar
                                            ingressos</option>
                                        <option
                                            <?php echo e(old('ajuda') == 'Dúvidas sobre cancelamento e reembolso' ? 'selected' : ''); ?>

                                            value="Dúvidas sobre cancelamento e reembolso">Dúvidas sobre cancelamento e
                                            reembolso</option>
                                        <option
                                            <?php echo e(old('ajuda') == 'Corrigir / alterar algum dado do meu ingresso ou formulário' ? 'selected' : ''); ?>

                                            value="Corrigir / alterar algum dado do meu ingresso ou formulário">
                                            Corrigir /
                                            alterar algum dado do meu ingresso ou formulário</option>
                                        <option <?php echo e(old('ajuda') == 'Informações sobre o evento' ? 'selected' : ''); ?>

                                            value="Informações sobre o evento">Informações sobre o evento</option>
                                        <option
                                            <?php echo e(old('ajuda') == 'Quero falar com a organização do evento' ? 'selected' : ''); ?>

                                            value="Quero falar com a organização do evento">Quero falar com a
                                            organização
                                            do evento</option>
                                        <option <?php echo e(old('ajuda') == 'Sugestão ou feedback' ? 'selected' : ''); ?>

                                            value="Sugestão ou feedback">Sugestão ou feedback</option>
                                        <option <?php echo e(old('ajuda') == 'Outro assunto' ? 'selected' : ''); ?>

                                            value="Outro assunto">Outro assunto</option>
                                    </select>
                                </div>
                                <div class="mb-4">
                                    <label class="mb-2 required fw-medium">Data do evento (informe a data do evento que
                                        participou ou deseja participar) </label>
                                    <input required value="<?php echo e(old('data_evento')); ?>" name="data_evento"
                                        type="date" class="form-control"
                                        laceholder="Data do evento (informe a data do evento que participou ou deseja participar) ">
                                </div>
                            </div>
                            <div class="col-md-4 col-xl-4">
                                <div class="mb-4">
                                    <label class="mb-2 required fw-medium">E-mail</label>
                                    <input required value="<?php echo e(old('email')); ?>" name="email" type="email"
                                        class="form-control" id="email" placeholder="E-mail">
                                </div>
                                <div class="mb-4">
                                    <label class="mb-2 required fw-medium">Descrição</label>
                                    <textarea name="msg" class="form-control" rows="7" placeholder="Informe como podemos lhe ajudar"><?php echo e(old('msg')); ?></textarea>
                                    <p id="charCount">0/500 <span class="d-none" id="Alert500">Limite de caracteres
                                            atingido!</span></p>
                                </div>
                                <div class="g-recaptcha" data-sitekey="<?php echo e(env('RECAPTCHA_SITE_KEY')); ?>"></div>
                            </div>
                        </div>
                    </div>
                    <?php if(!empty($config->status)): ?>
                        <?php if($config->status == '1'): ?>
                            <?php if(empty($bloqueado)): ?>
                                <div class="modal-footer">
                                    <div class="row">
                                        <div class="col-6">
                                            <button type="submit" class="btn btn-primary">Enviar</button>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>
                        <?php endif; ?>
                    <?php endif; ?>
                </form>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
    <input name="cookieData" type="hidden" data-cookie-customDialogSelector="null" data-cookie-colorText="#424a4d"
        data-cookie-colorBg="rgba(234, 239, 241, 0.99)" data-cookie-textButton="Aceitar e Fechar"
        data-cookie-colorButton="" data-cookie-colorLink="#424a4d" data-cookie-underlineLink="true"
        data-cookie-text="Utilizamos cookies e outras tecnologias para personalizar conteúdo e anúncios, fornecer recursos de mídia social de seu interesse e analisar o tráfego. Ao utilizar nossos serviços, você concorda com tal monitoramento. Informamos ainda que atualizamos nossa <a href='<?php echo e(route('site.politica.privacidade')); ?>'>Política de Privacidade</a> e <a href='<?php echo e(route('site.politica.cookies')); ?>'>Política de Cookies</a>.">

    <!-- end /. footer -->
    <!-- Optional JavaScript -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="<?php echo e(url('site')); ?>/assets/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="<?php echo e(url('site')); ?>/assets/plugins/aos/aos.min.js"></script>
    <script src="<?php echo e(url('site')); ?>/assets/plugins/macy/macy.js"></script>
    <script src="<?php echo e(url('site')); ?>/assets/plugins/simple-parallax/simpleParallax.min.js"></script>
    <script src="<?php echo e(url('site')); ?>/assets/plugins/OwlCarousel2/owl.carousel.min.js"></script>
    <script src="<?php echo e(url('site')); ?>/assets/plugins/theia-sticky-sidebar/ResizeSensor.min.js"></script>
    <script src="<?php echo e(url('site')); ?>/assets/plugins/theia-sticky-sidebar/theia-sticky-sidebar.min.js"></script>
    <script src="<?php echo e(url('site')); ?>/assets/plugins/waypoints/jquery.waypoints.min.js"></script>
    <script src="<?php echo e(url('site')); ?>/assets/plugins/counter-up/jquery.counterup.min.js"></script>
    <script src="<?php echo e(url('site')); ?>/assets/plugins/jquery-fancyfileuploader/fancy-file-uploader/jquery.ui.widget.js">
    </script>
    <script src="<?php echo e(url('site')); ?>/assets/plugins/jquery-fancyfileuploader/fancy-file-uploader/jquery.fileupload.js">
    </script>
    <script
        src="<?php echo e(url('site')); ?>/assets/plugins/jquery-fancyfileuploader/fancy-file-uploader/jquery.iframe-transport.js">
    </script>
    <script
        src="<?php echo e(url('site')); ?>/assets/plugins/jquery-fancyfileuploader/fancy-file-uploader/jquery.fancy-fileupload.js">
    </script>
    <script src="<?php echo e(url('site')); ?>/assets/plugins/ion.rangeSlider/ion.rangeSlider.min.js"></script>
    <script src="<?php echo e(url('site')); ?>/assets/plugins/magnific-popup/jquery.magnific-popup.min.js"></script>
    <script src="<?php echo e(url('site')); ?>/assets/plugins/select2/select2.min.js"></script>
    <!-- Custom script for this template -->
    <script src="<?php echo e(url('site')); ?>/assets/js/script.js"></script>


    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <script>

        var eventoExecutado = false;
        $('.estado-radio').change(function() {
            eventoExecutado = true;
            var estadoSelecionado = $('input[name="estado"]:checked').val();

            // Faça a chamada AJAX somente se um radio button estiver selecionado
            if (estadoSelecionado) {
                $('#modal-estados').modal('hide');
                $("#ec-overlay").removeClass('d-none');
                $('#navbarSupportedContent').collapse('hide');
                $("#nav-icon").removeClass('open');

                $('#carregando').removeClass('d-none');
                $('#top10').addClass('d-none');

                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });

                $.ajax({
                    url: "<?php echo e(route('get.anuncios.estado')); ?>",
                    method: 'POST',
                    data: {
                        estado: estadoSelecionado
                    },
                    success: function(result) {
                        $("#ec-overlay").addClass('d-none');
                        var nomeEstado = estadoSelecionado; // Obtém o nome do estado
                        if (nomeEstado) {
                            $("#box_estado").removeClass('d-none');
                        } else {
                            $("#box_estado").addClass('d-none');
                        }
                        if (nomeEstado == 'All') {
                            $("#box_estado").addClass('d-none');
                        } else {
                            $("#estado_nome").text(nomeEstado);
                        }


                        $("#titulo").text('');
                        $("#box_titulo").addClass('d-none');
                        $("#menu-estado").text(estadoSelecionado == 'All' ? 'Todos os estados' : nomeEstado);
                        $('#modal-estados').modal('hide');

                        $("#eventos").html(result);

                        if(estadoSelecionado == 'All' || estadoSelecionado == 'Bahia'){
                            $('#campanha').modal('show');
                        }


                        $.ajax({
                            url: "<?php echo e(route('get.eventos.top10')); ?>",
                            method: 'POST',
                            data: {
                                estado: estadoSelecionado
                            },
                            success: function(result) {
                                $('#carregando').addClass('d-none');
                                $('#top10').removeClass('d-none');
                                $("#top10").html(result);
                                if ($('.blog-carousel').data('owl.carousel')) {
                                    $('.blog-carousel').trigger('destroy.owl.carousel');
                                }
                                initCarousel();


                                $.ajax({
                                    url: "<?php echo e(route('get.eventos.hoje')); ?>",
                                    method: 'POST',
                                    data: {
                                        estado: estadoSelecionado
                                    },
                                    success: function(result) {
                                        $("#eventos-hoje").html(result);
                                    }
                                });

                            }
                        });
                    }
                });
            }
        });


        function initCarousel() {
            if ($('.blog-carousel').length) {
                var owl = $(".blog-carousel");

                owl.owlCarousel({
                    loop: false,
                    margin: 24,
                    rewind: false,
                    nav: false,
                    navText: [
                        '<i class="fa-solid fa-arrow-left"></i>',
                        '<i class="fa-solid fa-arrow-right"></i>'
                    ],
                    responsive: {
                        0: {
                            items: 2,
                        },
                        576: {
                            items: 2,
                        },
                        992: {
                            items: 4,
                        }
                    }
                })
            }
        }

        function CategoriaShow(elemento) {
            var categoria = $(elemento).data('value');
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: "<?php echo e(route('get.eventos.categoria')); ?>",
                method: 'POST',
                data: {
                    categoria
                },
                success: function(result) {
                    $("#box_titulo_categoria").removeClass('d-none');
                    $("#eventos").html(result);
                    if (categoria != 'All') {
                        $("#titulo").text(categoria);
                    } else {
                        $("#box_titulo_categoria").addClass('d-none');
                    }
                    window.location.href = '#proximos-eventos';
                }
            });
        }

        $(document).ready(function() {
            $(".buscar").keyup(function() {

                var inputValue = $(this).val();

                if (inputValue.length > 3) {
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });

                    $.ajax({
                        url: "<?php echo e(route('buscar')); ?>",
                        method: 'POST',
                        data: {
                            buscar: inputValue
                        },
                        success: function(result) {
                            $("#eventos").html(result);
                            window.location.href = '#proximos-eventos';
                        }
                    });
                }
            });
            $("#buscar").keyup(function() {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    url: "<?php echo e(route('buscar')); ?>",
                    method: 'POST',
                    data: {
                        buscar: $("#buscar").val()
                    },
                    success: function(result) {
                        $("#eventos").html(result);
                        window.location.href = '#proximos-eventos';
                    }
                });
            });
        });

        function Add(id) {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: "<?php echo e(route('add.view')); ?>",
                method: 'POST',
                data: {
                    id
                }
            });
        }


        $(document).ready(function() {
            <?php if(session('success')): ?>
                Swal.fire({
                    icon: "success",
                    title: "Obrigado",
                    text: "<?php echo e(session('success')); ?>",
                    showConfirmButton: true,
                    customClass: {
                        confirmButton: 'btn btn-primary' // Adicione a classe desejada ao botão de confirmação
                    },
                });
                setTimeout(() => {
                    Swal.close();
                }, 3000);
            <?php endif; ?>

            <?php if(session('error')): ?>
                Swal.fire({
                    icon: "error",
                    title: "Atenção",
                    text: "<?php echo e(session('error')); ?>",
                    showConfirmButton: true,
                    customClass: {
                        confirmButton: 'btn btn-primary' // Adicione a classe desejada ao botão de confirmação
                    },
                });
                setTimeout(() => {
                    Swal.close();
                    $('#modal-central-de-ajuda').modal('show');
                }, 3000);
            <?php endif; ?>
        });

        document.addEventListener('DOMContentLoaded', function() {
            var msgTextarea = document.querySelector('textarea[name="msg"]');
            var charCountElement = document.getElementById('charCount');
            var sendButton = document.querySelector('button[type="submit"]');

            // Atualiza a contagem inicialmente com o valor atual do textarea
            updateCharacterCount(msgTextarea.value.length);

            if (msgTextarea && sendButton) {
                msgTextarea.addEventListener('input', function() {
                    var charCount = msgTextarea.value.length;
                    updateCharacterCount(charCount);
                });
            }

            function updateCharacterCount(charCount) {
                charCountElement.textContent = `${charCount}/500`;

                // Aplica a classe text-danger se exceder 500 caracteres e a remove se estiver abaixo
                if (charCount > 500) {
                    charCountElement.classList.add('text-danger');
                    sendButton.style.display = 'none';
                    $("#Alert500").removeClass('d-none');
                } else {
                    charCountElement.classList.remove('text-danger');
                    sendButton.style.display = '';
                    $("#Alert500").addClass('d-none');
                }
            }
        });

       <?php if(empty(session()->get('estado'))): ?>
            setTimeout(() => {
                $('#modal-estados').modal('show');
            }, 3000);
        <?php endif; ?>

        function CloseCampanha() {
            console.log('Fechando modal');
            $('#campanha').modal('hide');
        }
        function OpenCampanha() {
            console.log('Fechando modal');
            $('#campanha').modal('hide');
            $('#alerta-geral').modal('show');
        }
    </script>



    <script src="<?php echo e(url('site')); ?>/assets/js/cookie-alert.js"></script>

    <?php echo $__env->yieldContent('js'); ?>
</body>

</html>
<?php /**PATH F:\Laravel\AgendaMaconica2025\resources\views/site/index.blade.php ENDPATH**/ ?>