@extends('base.base')
@section('titulo', Auth::user()->name)
@section('content')
    <div class="content-wrapper">
        <div class="container-full">
            <!-- Content Header (Page header) -->
            <div class="content-header">
                <div class="d-flex align-items-center">
                    <div class="me-auto">
                        <h3 class="page-title">{{ Auth::user()->name }}</h3>
                    </div>
                    <div class="form-group">
                        <a class="btn btn-primary btn-sm" href="javascript:void(0)" data-bs-toggle="modal" data-bs-target=".modalUser"> <span><i class="fa fa-user-plus"></i> Novo Usuário</span> </a>
                    </div>
                </div>
            </div>
            <section class="content">
                <div class="row">
                    <div class="col-12 col-lg-6">
                        <div class="box">
                            <div class="box-header bg-dark">
                                <h4 class="box-title">Preço {{ env('EMPRESA') }}</h4>
                            </div>
                            <div class="box-body">
                                <form action="{{ route('perfil.update') }}" method="post" enctype="multipart/form-data">
                                    @csrf
                                    <div class="row">
                                    <div class="mb-3 col-sm-12">
                                        <label class="form-label"  for="imageInput">
                                            <img src="{{ !empty(Auth::user()->foto) ? url("storage/".Auth::user()->foto."") : url('storage/images/sem-foto.jpeg') }}" id="selectedImage" width="150" style="border-radius: 20px;">
                                            <br>
                                            Clique para anexar Foto, tamanho máximo 8Mb
                                        </label>
                                        <input name="image" type="file" class="form-control" style="display: none" id="imageInput" accept="image/*">
                                    </div>
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label class="fw-700 fs-16 form-label">Nome</label>
                                            <input name="name" value="{{ Auth::user()->name }} {{ Auth::user()->sobrenome }}" id="name" type="text"
                                                class="form-control" placeholder="Nome">
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label class="fw-700 fs-16 form-label">E-mail</label>
                                            <input name="email" value="{{ Auth::user()->email }}" type="text" class="form-control" placeholder="E-mail">
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label class="fw-700 fs-16 form-label">E-mail</label>
                                            <input disabled value="{{ Auth::user()->funcao }}" type="text" class="form-control">
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label class="fw-700 fs-16 form-label">Comissionamento</label>
                                            <input disabled value="{{ Auth::user()->comissao }}" id="comissao" type="text" class="form-control">
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label class="fw-700 fs-16 form-label">Senha</label>
                                            <input name="password" type="password" class="form-control">
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label class="fw-700 fs-16 form-label">Confirme a senha</label>
                                            <input name="password_confirm" type="password" class="form-control">
                                        </div>
                                    </div>
                                    @if(Auth::user()->Permissao && Auth::user()->Permissao->where('rule', 'caixa_fechar')->count() > 0)
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label class="fw-700 fs-16 form-label">Senha Financeira</label>
                                                <input name="financeira" type="password" class="form-control">
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label class="fw-700 fs-16 form-label">Confirme a Senha Financeira</label>
                                                <input name="financeira_confirm" type="password" class="form-control">
                                            </div>
                                        </div>
                                    @endif
                                    <div id="precos-container"></div>
                                    <div class="col-md-12">
                                        <button type="submit" class="btn btn-primary"> <i class="fa fa-check"></i> Atualizar</button>
                                    </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
@endsection
@section('css')
    <script src="{{ url('admin') }}/assets/plugins/global/plugins.bundle.js"></script>
@endsection
@section('js')
    <script src="{{ url('adm') }}/assets/vendor_components/sweetalert/sweetalert.min.js"></script>
    <script src="{{ url('adm') }}/assets/vendor_components/sweetalert/jquery.sweet-alert.custom.js"></script>
    <script>
        @if (session('success'))
            swal(
                "Sucesso",
                "{{ session('success') }}",
                "success"
            );
        @endif
        @if (session('error'))
            swal(
                "Erro",
                "{{ session('error') }}",
                "error"
            );
        @endif
    </script>
@endsection
