@extends('base.base')
@section('titulo', 'Usuários')
@section('content')
    <div class="content-wrapper">
        <div class="container-full">
            <!-- Content Header (Page header) -->
            <div class="content-header">
                <div class="d-flex align-items-center">
                    <div class="me-auto">
                        <h3 class="page-title">Usuários</h3>
                    </div>
                    @if(Auth::user()->Permissao && Auth::user()->Permissao->where('rule', 'usuarios_create')->count() > 0)
                        <div class="form-group">
                            <a class="btn btn-primary btn-sm" href="javascript:void(0)" data-bs-toggle="modal" data-bs-target=".modalUser"> <span><i class="fa fa-user-plus"></i> Novo Usuário</span> </a>
                        </div>
                    @endif
                </div>
            </div>
            <section class="content">
                <div class="row">
                    <div class="col-lg-12">
                        <table id="example" class="table table-center table-hover datatable">
                            <thead class="thead-light">
                                <tr>
                                    <th>Nome</th>
                                    <th>Contato</th>
                                    <th>Função</th>
                                    <th>Último Login</th>
                                    <th>Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($usuarios as $usuario)
                                    <tr>
                                        <td>{{ $usuario->name }}</td>
                                        <td>{{ $usuario->celular }}</td>
                                        <td>
                                            <span class="badge badge-pill badge-danger">{{ $usuario->funcao }}</span>
                                        </td>
                                        <td>{{ !empty($usuario->last_login_at) ? date('d/m/Y H:i:s', strtotime($usuario->last_login_at)) : 'Nunca logou' }}
                                        </td>
                                        <td>
                                            @if(Auth::user()->Permissao && Auth::user()->Permissao->where('rule', 'usuarios_update')->count() > 0)
                                                <a href="javascript:Editar({{ $usuario->id }})" class="btn btn-sm btn-success me-5"><i class="fa fa-user me-5"></i> Gerenciar</a>
                                                <a href="javascript:Permissoes({{ $usuario->id }})" class="btn btn-sm btn-success me-5"><i class="fa fa-user me-5"></i> Permissões</a>
                                                @if (Auth::user()->id == 1)
                                                    <a href="#" class="btn btn-sm btn-success me-5"><i class="fa fa-user me-5"></i> Logar</a>
                                                @endif
                                            @endif
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </section>

            <div class="modal fade modalUser" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel"
                aria-hidden="true" style="display: none;">
                <div class="modal-dialog modal-lg">
                    <div class="modal-content" id="result_user">
                        <div class="modal-header">
                            <h4 class="modal-title" id="myLargeModalLabel">Cadastrar Usuário</h4>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <form action="{{ route('user.store') }}" method="post">
                            @csrf
                            <div class="modal-body">
                                @csrf
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label class="fw-700 fs-16 form-label">Nome</label>
                                            <input name="name" value="{{ old('name') }}" id="name" type="text"
                                                class="form-control" placeholder="Nome">
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label class="fw-700 fs-16 form-label">E-mail</label>
                                            <input name="email" value="{{ old('email') }}" type="text"
                                                class="form-control" placeholder="E-mail">
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label class="fw-700 fs-16 form-label">Celular</label>
                                            <input name="celular" value="{{ old('celular') }}" id="celular" type="text" class="form-control" placeholder="Celular">
                                        </div>
                                    </div>
                                    <div class="col-lg-12 col-md-3 col-12">
                                        <div class="form-group">
                                            <label class="fw-700 fs-16 form-label">Cargo/Função</label>
                                            <select name="funcao" id="funcao" class="form-select"
                                                data-placeholder="Choose a Category" tabindex="1">
                                                <option value="Administrativo">Administrativo</option>
                                                <option value="Auxiliar Veterinário">Auxiliar Veterinário</option>
                                                <option value="Auxiliar Veterinária">Auxiliar Veterinária</option>
                                                <option value="Contabilidade">Contabilidade</option>
                                                <option value="Recepcionista">Recepcionista</option>
                                                <option value="Tosador">Tosador</option>
                                                <option value="Tosadora">Tosadora</option>
                                                <option value="Veterinário">Veterinário</option>
                                                <option value="Veterinária">Veterinária</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-12 d-none">
                                        <div class="form-group">
                                            <label class="fw-700 fs-16 form-label">CRMV</label>
                                            <input name="crmv" value="{{ old('crmv') }}" id="crmv" type="text"
                                                class="form-control" placeholder="Nome">
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label class="fw-700 fs-16 form-label">Comissionamento (Apenas números)</label>
                                            <input name="comissao" value="{{ old('comissao') }}" id="comissao"
                                                type="text" class="form-control" placeholder="Comissionamento">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-danger text-start"
                                    data-bs-dismiss="modal">Fechar</button>
                                <button type="submit" class="btn btn-primary text-start">Cadastrar</button>
                            </div>
                        </form>
                    </div>
                    <!-- /.modal-content -->
                </div>
                <!-- /.modal-dialog -->
            </div>

            <div class="modal fade Permissoes" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel"
                aria-hidden="true" style="display: none;">
                <div class="modal-dialog modal-lg">
                    <div class="modal-content" id="result_user_rules">
                        <div class="modal-header">
                            <h4 class="modal-title" id="myLargeModalLabel">Permissão de acesso</h4>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div id="result_permissoes"></div>
                    </div>
                    <!-- /.modal-content -->
                </div>
                <!-- /.modal-dialog -->
            </div>

        </div>
    </div>
@endsection
@section('css')
    <script src="{{ url('admin') }}/assets/plugins/global/plugins.bundle.js"></script>
@endsection
@section('js')

<script src="{{ url('adm') }}/assets/vendor_components/formatter/formatter.js"></script>
<script src="{{ url('adm') }}/assets/vendor_components/formatter/jquery.formatter.js"></script>
<script src="{{ url('adm') }}/src/js/pages/formatter.js"></script>
    <script src="{{ url('adm') }}/assets/vendor_components/sweetalert/sweetalert.min.js"></script>
    <script src="{{ url('adm') }}/assets/vendor_components/sweetalert/jquery.sweet-alert.custom.js"></script>
    <script>
        @if (session('success'))
            swal(
                "Sucesso",
                "{{ session('success') }}",
                "success"
            );
        @endif

        function Editar(id) {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: "{{ route('user.show') }}",
                method: 'POST',
                data: {
                    id
                },
                success: function(result) {
                    $("#result_user").html(result);
                    $(".modalUser").modal('show');
                }
            });
        }

        function Permissoes(id) {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: "{{ route('user.permissoes') }}",
                method: 'POST',
                data: {
                    id
                },
                success: function(result) {
                    $("#result_permissoes").html(result);
                    $(".Permissoes").modal('show');
                }
            });
        }

        var funcaoSelect = document.getElementById("funcao");
        var divVeterinario = document.querySelector(".col-md-12.d-none");

        funcaoSelect.addEventListener("change", function() {
        if (funcaoSelect.value === "Veterinário" || funcaoSelect.value === "Veterinária") {
            divVeterinario.classList.remove("d-none");
        } else {
            divVeterinario.classList.add("d-none");
        }
        });

        function marcarTodos() {
        var checkboxes = document.querySelectorAll('input[type="checkbox"]');
        for (var i = 0; i < checkboxes.length; i++) {
            checkboxes[i].checked = document.getElementById('all').checked;
        }
    }

    </script>
@endsection
