@extends('base.base')
@section('titulo', 'Editar Slide')
@section('content')
    <div class="content-wrapper">
        <div class="container-full">
            <div class="content-header">
                <div class="d-flex align-items-center">
                    <div class="me-auto">
                        <h3 class="page-title">Editar Slide</h3>
                    </div>
                </div>
            </div>
            <!-- Main content -->
            <section class="content">
                <div class="row">
                    <div class="col-6">
                        <div class="box">
                            <div class="box-header">
                                <div class="box-body">
                                    <form action="{{ route('slide.update', $slide->id) }}" method="post"
                                        enctype="multipart/form-data">
                                        @csrf
                                        @if ($slide->evento_id > 0)
                                            <div class="form-group row">
                                                <label class="col-form-label col-md-2">Eventos</label>
                                                <div class="col-md-10">
                                                    <select class="form-control select2" name="evento_id" id="evento_id">
                                                        <option value="0">Sem Evento</option>
                                                        @foreach ($eventos as $evento)
                                                            <option
                                                                {{ $evento['id'] == $slide->evento_id ? 'selected' : '' }} value="{{ $evento['banner'] }},{{ $evento['titulo'] }},{{ $evento['local'] }},{{ $evento['link'] }},{{ $evento['status'] }},{{ $evento['dataEvento'] }},{{ $evento['id'] }},{{$evento['mes_fim']}},{{$evento['dia_fim']}}">
                                                                {{ $evento['titulo'] }}-{{ $evento['dia'] }}/{{ $evento['mes'] }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-form-label col-md-2">Ordem</label>
                                                <div class="col-md-10">
                                                    <input id="ordem" name="ordem" value="{{ $slide->ordem }}" type="text" class="form-control">
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-form-label col-md-2">Titulo</label>
                                                <div class="col-md-10">
                                                    <input id="titulo" name="titulo" value="{{ $slide->titulo }}"
                                                        type="text" class="form-control">
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-form-label col-md-2">Descrição</label>
                                                <div class="col-md-10">
                                                    <input id="subtitulo" name="subtitulo"
                                                        value="{{ $slide->subtitulo }}"type="text" class="form-control">
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-form-label col-md-2">Botão</label>
                                                <div class="col-md-10">
                                                    <input id="botao" name="botao" value="{{ $slide->botao }}"
                                                        type="text" class="form-control" value="Comprar">
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-form-label col-md-2">Link</label>
                                                <div class="col-md-10">
                                                    <input id="link" name="link" value="{{ $slide->link }}"
                                                        type="text" class="form-control">
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-form-label col-md-2">Data Fim</label>
                                                <div class="col-md-10">
                                                    <input id="date" name="data_fim" value="{{ $slide->data_fim }}" type="date" class="form-control">
                                                </div>
                                            </div>
                                            <div class="input-group">
                                                <label class="col-form-label col-md-2">Imagem (Tamanho 800x400)</label>
                                                <div class="col-md-10">
                                                    <input type="file" name="image" class="form-control"
                                                        id="inputGroupFile04" aria-describedby="inputGroupFileAddon04"
                                                        aria-label="Upload">
                                                </div>
                                            </div>
                                            <div class="form-group pull-right mt-10">
                                                <button type="submit" class="btn btn-primary"> <i class="fa fa-check"></i>
                                                    Atualizar</button>
                                            </div>
                                        @else
                                        <div class="form-group row">
                                            <label class="col-form-label col-md-2">Ordem</label>
                                            <div class="col-md-10">
                                                <input id="ordem" name="ordem" value="{{ $slide->ordem }}" type="text" class="form-control">
                                            </div>
                                        </div>
                                            <div class="form-group row">
                                                <label class="col-form-label col-md-2">Titulo</label>
                                                <div class="col-md-10">
                                                    <input id="titulo" name="titulo" value="{{ $slide->titulo }}"
                                                        type="text" class="form-control">
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-form-label col-md-2">Descrição</label>
                                                <div class="col-md-10">
                                                    <input id="subtitulo" name="subtitulo"
                                                        value="{{ $slide->subtitulo }}"type="text" class="form-control">
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-form-label col-md-2">Botão</label>
                                                <div class="col-md-10">
                                                    <input id="botao" name="botao" value="{{ $slide->botao }}"
                                                        type="text" class="form-control" value="Comprar">
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-form-label col-md-2">Link</label>
                                                <div class="col-md-10">
                                                    <input id="link" name="link" value="{{ $slide->link }}"
                                                        type="text" class="form-control">
                                                </div>
                                            </div>
                                            <div class="input-group">
                                                <label class="col-form-label col-md-2">Imagem (Tamanho 800x400)</label>
                                                <div class="col-md-10">
                                                    <input type="file" name="image" class="form-control"
                                                        id="inputGroupFile04" aria-describedby="inputGroupFileAddon04"
                                                        aria-label="Upload">
                                                </div>
                                            </div>
                                            <div class="form-group pull-right mt-10">
                                                <button type="submit" class="btn btn-primary"> <i
                                                        class="fa fa-check"></i> Atualizar</button>
                                            </div>
                                        @endif
                                        <div class="input-group">
                                            <img src="{{ url("storage/{$slide->image}") }}">
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </section>
            <!-- /.content -->
        </div>
    </div>
    <!-- /.content-wrapper -->
@endsection
@section('css')
    <script src="{{ url('admin') }}/assets/plugins/global/plugins.bundle.js"></script>
@endsection
@section('js')
    <script src="{{ url('adm') }}/assets/vendor_components/sweetalert/sweetalert.min.js"></script>
    <script src="{{ url('adm') }}/assets/vendor_components/sweetalert/jquery.sweet-alert.custom.js"></script>


    <script src="{{ url('adm') }}/assets/vendor_components/bootstrap-select/dist/js/bootstrap-select.js"></script>
    <script src="{{ url('adm') }}/src/js/pages/advanced-form-element.js"></script>
    <script>
        @if (session('success'))
            swal(
                "Sucesso",
                "{{ session('success') }}",
                "success"
            );
        @endif

        $(document).ready(function() {
            $("#produto_id").change(function() {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });

                $.ajax({
                    url: "{{ route('get.produto.slide') }}",
                    method: 'POST',
                    data: {
                        produto_id: $("#produto_id").val()
                    },
                    success: function(result) {
                        $("#titulo").val(result.produto);
                        $("#link").val(result.link);
                    }
                });
            });
        });
    </script>
@endsection
