@extends('base.base')
@section('titulo', 'Slides')
@section('content')
    <div class="content-wrapper">
        <div class="container-full">
            <div class="content-header">
                <div class="d-flex align-items-center">
                    <div class="me-auto">
                        <h4 class="page-title">Slides</h4>
                    </div>
                    <div class="form-group">
                        <a href="{{ route('slide.create') }}" class="btn btn-danger btn-sm"> <span><i class="fa fa-cart-plus"></i>Adicionar Slide</span> </a>
                    </div>
                </div>
            </div>
            <section class="content">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="box">
                            <div class="box-body">
                                <div class="table-responsive">
                                    <table id="example" class="table table-center table-hover datatable">
                                        <thead class="thead-light">
                                            <tr>
                                                <th></th>
                                                <th>Slide</th>
                                                <th class="text-end"></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($slides as $slide)
                                            @if ($slide->evento_id > 0)
                                            <tr>
                                                <td><img src="{{ $slide->image }}" width="250"> </td>
                                                <td>{{ $slide->titulo }}</td>
                                                <td class="text-end">
                                                    <div class="btn-group mb-5">
                                                        <button type="button" class="waves-effect btn-success btn btn-sm dropdown-toggle" data-bs-toggle="dropdown">Gerenciar</button>
                                                        <div class="dropdown-menu">
                                                            <a class="dropdown-item" href="{{ route('slide.show', $slide->id) }}">Editar</a>
                                                            <div class="dropdown-divider"></div>
                                                            <a class="dropdown-item"  href="{{ route('slide.destroy', $slide->id) }}">Excluir</a>
                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>
                                            @else
                                            <tr>
                                                <td><img src="{{ url("storage/{$slide->image}") }}" width="250"> </td>
                                                <td>{{ $slide->titulo }}</td>
                                                 <td class="text-end">
                                                    <div class="btn-group mb-5">
                                                        <button type="button" class="waves-effect btn-success btn btn-sm dropdown-toggle" data-bs-toggle="dropdown">Gerenciar</button>
                                                        <div class="dropdown-menu">
                                                            <a class="dropdown-item" href="{{ route('slide.show', $slide->id) }}">Editar</a>
                                                            <div class="dropdown-divider"></div>
                                                            <a class="dropdown-item"  href="{{ route('slide.destroy', $slide->id) }}">Excluir</a>
                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>
                                            @endif
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!-- /.content -->
        </div>
    </div>
    <!-- /.content-wrapper -->
@endsection
@section('js')
    <!-- CRMi App -->
    <script src="{{ url('adm') }}/assets/vendor_components/datatable/datatables.min.js"></script>
    <script src="{{ url('adm') }}/src/js/pages/data-table.js"></script>
@endsection
