@extends('site.base')
@section('content')
    <div id="page-title" class="page-title pt-12 text-center">
        <div class="container">
            <div class="h-100 ">
                <h1 class="mb-0" data-animate="fadeInDown">
                    Termos de Uso e Política de Privacidade
                </h1>
                <ul class="breadcrumb justify-content-center" data-animate="fadeInUp">
                    <li class="breadcrumb-item"><a href="#">Home</a></li>
                    <li class="breadcrumb-item"><span>Termos e Política</span></li>
                </ul>
            </div>
        </div>
    </div>

    <div id="wrapper-content" class="wrapper-content pb-0 pt-11">
        <div class="container">
            <div id="term-condition" class="pb-9">

                <div class="mb-7">
                    <h5 class="mb-4">1. Introdução</h5>
                    <p>
                        O aplicativo <strong>Agenda Maçônica Brasil</strong> é um guia comercial voltado para
                        a divulgação de empresas e serviços de maçons. Qualquer usuário pode acessar e utilizar
                        o aplicativo, sendo os anunciantes necessariamente maçons.
                    </p>
                </div>

                <div class="mb-7">
                    <h5 class="mb-4">2. Termos de Uso</h5>
                    <ul class="mb-4 list-unstyled">
                        <li>- O uso do aplicativo é gratuito para usuários finais.</li>
                        <li>- Anunciantes devem comprovar vínculo maçônico para cadastro de anúncios.</li>
                        <li>- É vedado o uso do aplicativo para atividades ilegais, discriminatórias ou que
                            desrespeitem os princípios maçônicos.</li>
                        <li>- O usuário concorda em utilizar o aplicativo de forma ética e em conformidade
                            com a legislação vigente.</li>
                    </ul>
                </div>

                <div class="mb-7">
                    <h5 class="mb-4">3. Política de Privacidade</h5>
                    <p>
                        O <strong>Agenda Maçônica Brasil</strong> respeita sua privacidade e adota práticas de
                        proteção de dados em conformidade com a <strong>Lei Geral de Proteção de Dados (LGPD - Lei 13.709/2018)</strong>.
                    </p>
                    <ul class="mb-4 list-unstyled">
                        <li>- Dados coletados: nome, e-mail, telefone e informações de cadastro fornecidas voluntariamente pelo usuário.</li>
                        <li>- Finalidade: uso dos dados para funcionamento do aplicativo, exibição de anúncios e comunicação com o usuário.</li>
                        <li>- Compartilhamento: os dados não serão vendidos ou cedidos a terceiros, exceto quando exigido por lei.</li>
                        <li>- Segurança: medidas técnicas e organizacionais são adotadas para proteger as informações pessoais.</li>
                        <li>- Direitos do usuário: acessar, corrigir ou solicitar exclusão de seus dados pessoais a qualquer momento.</li>
                    </ul>
                </div>

                <div class="mb-7">
                    <h5 class="mb-4">4. Limitação de Responsabilidade</h5>
                    <p>
                        O <strong>Agenda Maçônica Brasil</strong> atua como plataforma de divulgação e não se responsabiliza
                        pela veracidade, qualidade ou entrega dos serviços anunciados. Toda negociação é de responsabilidade exclusiva
                        entre o anunciante e o usuário.
                    </p>
                </div>

                <div class="mb-7">
                    <h5 class="mb-4">5. Alterações</h5>
                    <p>
                        A presente Política de Privacidade e os Termos de Uso podem ser alterados a qualquer momento,
                        cabendo ao usuário consultar periodicamente esta página para se manter atualizado.
                    </p>
                </div>

                <div class="mb-7">
                    <h5 class="mb-4">6. Lei Aplicável</h5>
                    <p>
                        Este documento é regido pelas leis brasileiras. Em caso de conflitos, fica eleito o foro da comarca de Salvador - BA,
                        com renúncia de qualquer outro, por mais privilegiado que seja.
                    </p>
                </div>

                <div class="mb-7">
                    <h5 class="mb-4">7. Contato</h5>
                    <p>
                        Em caso de dúvidas ou solicitações relacionadas a esta Política de Privacidade ou aos Termos de Uso,
                        entre em contato conosco através do e-mail: <a href="mailto:contato@agendamaconica.com.br">contato@agendamaconica.com.br</a>.
                    </p>
                </div>

            </div>
        </div>
    </div>
@endsection
