@extends('site.base')
@section('content')
    <div class="content-wrap">
        <!-- #section 01 start -->
        <section id="section-01" class="home-main-intro">
            <div class="home-main-intro-container">
                <div class="container">
                    <div class="heading mb-9">
                        <h1 class="mb-7">
                            <span class="d-block" data-animate="slideInLeft">Encontre</span>
                            <span class="font-weight-light d-block" data-animate="fadeInRight">um Ir.·. em sua cidade</span>
                        </h1>
                        <p class="h5 font-weight-normal text-secondary mb-0" data-animate="fadeInDown">
                            Todos nossos anunciantes são nossos IIr.·.
                        </p>
                    </div>
                    <div class="form-search form-search-style-02 pb-9" data-animate="fadeInDown">
                        <form>
                            <div class="row align-items-end no-gutters">
                                <div
                                    class="col-xl-6 mb-4 mb-xl-0 py-3 px-4 bg-white border-right position-relative rounded-left form-search-item">
                                    <label for="key-word"
                                        class="font-size-md font-weight-semibold text-dark mb-0 lh-1">Estados</label>
                                    <div class="input-group dropdown show">
                                        <input type="text" autocomplete="off" id="key-word" name="key-word"
                                            class="form-control form-control-mini border-0 px-0 bg-transparent"
                                            placeholder="Selecione um Estado" data-toggle="dropdown" aria-haspopup="true">
                                        <a href="javascrip:void(0)" class="input-group-append text-decoration-none"
                                            data-toggle="dropdown">
                                            <i class="fal fa-chevron-down"></i>
                                        </a>
                                        <ul class="dropdown-menu form-search-ajax" aria-labelledby="key-word">
                                            @foreach ($Estados as $Estado)
                                                <li class="dropdown-item item">
                                                    <a onclick="javascript:SetEstado({{ $Estado->id }})"
                                                        href="javascript:void(0)" class="link-hover-dark-white">
                                                        <img src="{{ url("site/images/estados/{$Estado->url}.jpg") }}"
                                                            width="20" height="20">
                                                        <span class="font-size-md">{{ $Estado->nome }}</span>
                                                    </a>
                                                </li>
                                            @endforeach
                                        </ul>
                                    </div>
                                </div>
                                <div
                                    class="col-xl-4 mb-4 mb-xl-0 py-3 px-4 bg-white position-relative rounded-right form-search-item">
                                    <label for="key-word"
                                        class="font-size-md font-weight-semibold text-dark mb-0 lh-1">Cidades</label>
                                    <div class="input-group dropdown show">
                                        <input type="text" autocomplete="off" id="region" name="region"
                                            class="form-control form-control-mini border-0 px-0 bg-transparent"
                                            placeholder="Selecione uma cidade" data-toggle="dropdown" aria-haspopup="true">
                                        <a href="javascrip:void(0)" class="input-group-append text-decoration-none"
                                            data-toggle="dropdown">
                                            <i class="fal fa-chevron-down"></i>
                                        </a>
                                        <ul class="dropdown-menu form-search-ajax" aria-labelledby="region"
                                            id="result_cidades">

                                            <li class="dropdown-item item">
                                                <a href="javascrip:void(0)" class="link-hover-dark-white">
                                                    Selecione um estado
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="col-xl-2 button">
                                    <button type="submit" class="btn btn-primary btn-lg btn-icon-left btn-block"><i
                                            class="fal fa-search"></i>Search
                                    </button>
                                </div>
                            </div>

                        </form>
                    </div>
                    <div class="font-size-lg mb-4">
                        Or browse the highlights
                    </div>
                    <div class="list-inline pb-8 flex-wrap my-n2">
                        <div class="list-inline-item py-2">
                            <a href="{{ url('site') }}/explore-sidebar-grid.html"
                                class="card border-0 icon-box-style-01 link-hover-dark-white">
                                <div class="card-body p-0">
                                    <svg class="icon icon-pizza">
                                        <use xlink:href="{{ url('site') }}/#icon-pizza"></use>
                                    </svg>
                                    <span class="card-text font-size-md font-weight-semibold mt-2 d-block">
                                        Foods
                                    </span>
                                </div>
                            </a>
                        </div>
                        <div class="list-inline-item py-2">
                            <a href="{{ url('site') }}/explore-sidebar-grid.html"
                                class="card border-0 icon-box-style-01 link-hover-dark-white">
                                <div class="card-body p-0">
                                    <svg class="icon icon-bed">
                                        <use xlink:href="{{ url('site') }}/#icon-bed"></use>
                                    </svg>
                                    <span class="card-text font-size-md font-weight-semibold mt-2 d-block">
                                        Hotels
                                    </span>
                                </div>

                            </a>
                        </div>
                        <div class="list-inline-item py-2">
                            <a href="{{ url('site') }}/explore-sidebar-grid.html"
                                class="card border-0 icon-box-style-01 link-hover-dark-white">
                                <div class="card-body p-0">
                                    <svg class="icon icon-brush2">
                                        <use xlink:href="{{ url('site') }}/#icon-brush2"></use>
                                    </svg>
                                    <span class="card-text font-size-md font-weight-semibold mt-2 d-block">
                                        Jobs
                                    </span>
                                </div>
                            </a>
                        </div>
                        <div class="list-inline-item py-2">
                            <a href="{{ url('site') }}/explore-sidebar-grid.html"
                                class="card border-0 link-hover-dark-white icon-box-style-01">
                                <div class="card-body p-0">
                                    <svg class="icon icon-pharmaceutical">
                                        <use xlink:href="{{ url('site') }}/#icon-pharmaceutical"></use>
                                    </svg>
                                    <span class="card-text font-size-md font-weight-semibold mt-2 d-block">
                                        Medicals
                                    </span>
                                </div>
                            </a>
                        </div>
                        <div class="list-inline-item py-2">
                            <a href="{{ url('site') }}/explore-sidebar-grid.html"
                                class="card border-0 link-hover-dark-white icon-box-style-01">
                                <div class="card-body p-0">
                                    <svg class="icon icon-cog">
                                        <use xlink:href="{{ url('site') }}/#icon-cog"></use>
                                    </svg>
                                    <span class="card-text font-size-md font-weight-semibold mt-2 d-block">
                                        Services
                                    </span>
                                </div>

                            </a>
                        </div>
                        <div class="list-inline-item py-2">
                            <a href="{{ url('site') }}/explore-sidebar-grid.html"
                                class="card border-0 link-hover-dark-white icon-box-style-01">
                                <div class="card-body p-0">
                                    <svg class="icon icon-bag">
                                        <use xlink:href="{{ url('site') }}/#icon-bag"></use>
                                    </svg>
                                    <span class="card-text font-size-md font-weight-semibold mt-2 d-block">
                                        Shopping
                                    </span>
                                </div>

                            </a>
                        </div>
                        <div class="list-inline-item py-2">
                            <a href="{{ url('site') }}/explore-sidebar-grid.html"
                                class="card border-0 link-hover-dark-white icon-box-style-01">
                                <div class="card-body p-0">
                                    <svg class="icon icon-car">
                                        <use xlink:href="{{ url('site') }}/#icon-car"></use>
                                    </svg>
                                    <span class="card-text font-size-md font-weight-semibold mt-2 d-block">
                                        Automotive
                                    </span>
                                </div>
                            </a>
                        </div>
                    </div>
                </div>
                <div class="home-main-how-it-work bg-white pt-11">
                    <div class="container">
                        <h2 class="mb-8">
                            <span>See</span>
                            <span class="font-weight-light">How It Works</span>
                        </h2>
                        <div class="row no-gutters pb-11">
                            <div class="col-lg-4 mb-4 mb-lg-0 px-0 px-lg-4">
                                <div class="media icon-box-style-02" data-animate="fadeInDown">
                                    <div class="d-flex flex-column align-items-center mr-6">
                                        <svg class="icon icon-checkmark-circle">
                                            <use xlink:href="{{ url('site') }}/#icon-checkmark-circle"></use>
                                        </svg>
                                        <span class="number h1 font-weight-bold">1</span>
                                    </div>
                                    <div class="media-body lh-14">
                                        <h5 class="mb-3 lh-1">
                                            Choose What To Do
                                        </h5>
                                        <p class="font-size-md text-gray mb-0 text-muted">
                                            Looking for a cozy hotel to stay, a restaurant to eat, a museum to visit
                                            or a mall to do some shopping?
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-4 mb-4 mb-lg-0 px-0 px-lg-4">
                                <div class="media icon-box-style-02" data-animate="fadeInDown">
                                    <div class="d-flex flex-column align-items-center mr-6">
                                        <svg class="icon icon-checkmark-circle">
                                            <use xlink:href="{{ url('site') }}/#icon-checkmark-circle"></use>
                                        </svg>
                                        <span class="number h1 font-weight-bold">2</span>
                                    </div>
                                    <div class="media-body lh-14">
                                        <h5 class="mb-3 lh-1">
                                            Find What You Want
                                        </h5>
                                        <p class="font-size-md text-gray mb-0 text-muted">
                                            Search and filter hundreds of listings, read reviews, explore photos and
                                            find the perfect spot.
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-4 mb-4 mb-lg-0 px-0 px-lg-4">
                                <div class="media icon-box-style-02" data-animate="fadeInDown">
                                    <div class="d-flex flex-column align-items-center mr-6">
                                        <svg class="icon icon-checkmark-circle">
                                            <use xlink:href="{{ url('site') }}/#icon-checkmark-circle"></use>
                                        </svg>
                                        <span class="number h1 font-weight-bold">3</span>
                                    </div>
                                    <div class="media-body lh-14">
                                        <h5 class="mb-3 lh-1">
                                            Explore Amazing Places
                                        </h5>
                                        <p class="font-size-md text-gray mb-0 text-muted">
                                            Go and have a good time or even make a booking directly from the listing
                                            page. All of those, thanks to TheDir!
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="border-bottom"></div>
                    </div>
                </div>
            </div>
        </section>
        <!-- /#section-01 end -->
        <!-- #section 02start -->
        <section id="section-02" class="pb-8 feature-destination pt-85">
            <div class="container">
                <div class="mb-8">
                    <h2 class="mb-0">
                        <span>Featured </span>
                        <span class="font-weight-light">Destinations</span>
                    </h2>
                </div>
                <div class="slick-slider arrow-center"
                    data-slick-options='{"slidesToShow": 4, "autoplay":false,"dots":false,"responsive":[{"breakpoint": 992,"settings": {"slidesToShow": 3,"arrows":false,"dots":true,"autoplay":true}},{"breakpoint": 768,"settings": {"slidesToShow": 2,"arrows":false,"dots":true,"autoplay":true}},{"breakpoint": 400,"settings": {"slidesToShow": 1,"arrows":false,"dots":true,"autoplay":true}}]}'>
                    <div class="box" data-animate="zoomIn">
                        <div class="card border-0">
                            <a class="hover-scale" href="{{ url('site') }}/explore-sidebar-grid.html">
                                <img src="{{ url('site') }}/images/listing/feature-detination-1.jpg"
                                    alt="San Francisco" class="image">
                            </a>
                            <div class="card-body px-0 pt-4">
                                <h5 class="card-title mb-0">
                                    <a href="{{ url('site') }}/explore-sidebar-grid.html"
                                        class="font-size-h5 link-hover-dark-primary">
                                        San Francisco</a>
                                </h5>

                                <span class="card-text font-size-md">
                                    20 Listing
                                </span>
                            </div>

                        </div>
                    </div>
                    <div class="box" data-animate="zoomIn">
                        <div class="card border-0">
                            <a class="hover-scale" href="{{ url('site') }}/explore-sidebar-grid.html">
                                <img src="{{ url('site') }}/images/listing/feature-detination-2.jpg" alt="London"
                                    class="image">
                            </a>
                            <div class="card-body px-0 pt-4">
                                <h5 class="mb-0 card-title">
                                    <a href="{{ url('site') }}/explore-sidebar-grid.html"
                                        class="font-size-h5 link-hover-dark-primary">
                                        London
                                    </a>
                                </h5>

                                <span class="card-text font-size-md">
                                    6 Listing
                                </span>
                            </div>

                        </div>
                    </div>
                    <div class="box" data-animate="zoomIn">
                        <div class="card border-0">
                            <a class="hover-scale" href="{{ url('site') }}/explore-sidebar-grid.html">
                                <img src="{{ url('site') }}/images/listing/feature-detination-3.jpg" alt="Tokyo"
                                    class="image">
                            </a>
                            <div class="card-body px-0 pt-4">
                                <h5 class="mb-0 card-title">
                                    <a href="{{ url('site') }}/explore-sidebar-grid.html"
                                        class="font-size-h5 link-hover-dark-primary">
                                        Tokyo
                                    </a>
                                </h5>
                                <span class="card-text font-size-md">
                                    12 Listing
                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="box" data-animate="zoomIn">
                        <div class="card border-0">
                            <a class="hover-scale" href="{{ url('site') }}/explore-sidebar-grid.html">
                                <img src="{{ url('site') }}/images/listing/feature-detination-4.jpg" alt="Miami"
                                    class="image">
                            </a>
                            <div class="card-body px-0 pt-4">
                                <h5 class="mb-0 card-title">
                                    <a href="{{ url('site') }}/explore-sidebar-grid.html"
                                        class="font-size-h5 link-hover-dark-primary">
                                        Miami
                                    </a>
                                </h5>
                                <span class="card-text font-size-md">
                                    4 Listing
                                </span>
                            </div>

                        </div>
                    </div>
                    <div class="box" data-animate="zoomIn">
                        <div class="card border-0">
                            <a class="hover-scale" href="{{ url('site') }}/explore-sidebar-grid.html">
                                <img src="{{ url('site') }}/images/listing/feature-detination-1.jpg"
                                    alt="San Francisco" class="image">
                            </a>
                            <div class="card-body px-0 pt-4">
                                <h5 class="card-title mb-0">
                                    <a href="{{ url('site') }}/explore-sidebar-grid.html"
                                        class="font-size-h5 link-hover-dark-primary">
                                        San Francisco</a>
                                </h5>

                                <span class="card-text font-size-md">
                                    20 Listing
                                </span>
                            </div>

                        </div>
                    </div>
                    <div class="box" data-animate="zoomIn">
                        <div class="card border-0">
                            <a class="hover-scale" href="{{ url('site') }}/explore-sidebar-grid.html">
                                <img src="{{ url('site') }}/images/listing/feature-detination-2.jpg" alt="London"
                                    class="image">
                            </a>
                            <div class="card-body px-0 pt-4">
                                <h5 class="mb-0 card-title">
                                    <a href="{{ url('site') }}/explore-sidebar-grid.html"
                                        class="font-size-h5 link-hover-dark-primary">
                                        London
                                    </a>
                                </h5>

                                <span class="card-text font-size-md">
                                    6 Listing
                                </span>
                            </div>

                        </div>
                    </div>
                    <div class="box" data-animate="zoomIn">
                        <div class="card border-0">
                            <a class="hover-scale" href="{{ url('site') }}/explore-sidebar-grid.html">
                                <img src="{{ url('site') }}/images/listing/feature-detination-3.jpg" alt="Tokyo"
                                    class="image">
                            </a>
                            <div class="card-body px-0 pt-4">
                                <h5 class="mb-0 card-title">
                                    <a href="{{ url('site') }}/explore-sidebar-grid.html"
                                        class="font-size-h5 link-hover-dark-primary">
                                        Tokyo
                                    </a>
                                </h5>
                                <span class="card-text font-size-md">
                                    12 Listing
                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="box" data-animate="zoomIn">
                        <div class="card border-0">
                            <a class="hover-scale" href="{{ url('site') }}/explore-sidebar-grid.html">
                                <img src="{{ url('site') }}/images/listing/feature-detination-4.jpg" alt="Miami"
                                    class="image">
                            </a>
                            <div class="card-body px-0 pt-4">
                                <h5 class="mb-0 card-title">
                                    <a href="{{ url('site') }}/explore-sidebar-grid.html"
                                        class="font-size-h5 link-hover-dark-primary">
                                        Miami
                                    </a>
                                </h5>
                                <span class="card-text font-size-md">
                                    4 Listing
                                </span>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- /#section-02 end -->
        <!-- #section 03 start -->
        <section id="section-03" class="pb-8 our-directory">
            <div class="container">
                <div class="mb-7">
                    <h2 class="mb-0">
                        <span class="font-weight-semibold">Our </span>
                        <span class="font-weight-light">Directory</span>
                    </h2>
                </div>
                <div class="d-flex align-items-center pb-8">
                    <ul class="nav nav-pills tab-style-01" role="tablist">
                        <li class="nav-item">
                            <a class="nav-link active" id="all-tab" data-toggle="tab" href="{{ url('site') }}/#all"
                                role="tab" aria-controls="all" aria-selected="true">all</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" id="featured-tab" data-toggle="tab" href="{{ url('site') }}/#feature"
                                role="tab" aria-controls="feature" aria-selected="false">featured</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" id="best-rate-tab" data-toggle="tab"
                                href="{{ url('site') }}/#best-rate" role="tab" aria-controls="best-rate"
                                aria-selected="false">best rate</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" id="most-view-tab" data-toggle="tab"
                                href="{{ url('site') }}/#most-view" role="tab" aria-controls="most-view"
                                aria-selected="false">most view </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" id="popular-tab" data-toggle="tab" href="{{ url('site') }}/#popular"
                                role="tab" aria-controls="popular" aria-selected="false">popular</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" id="contact-tab" data-toggle="tab"
                                href="{{ url('site') }}/#ad-directory" role="tab" aria-controls="ad-directory"
                                aria-selected="false">ad directory</a>
                        </li>
                    </ul>
                    <div class="ml-auto d-flex slick-custom-nav pl-5">
                        <div class="arrow slick-prev disabled" id="previous"><i class="fas fa-chevron-left"></i></div>
                        <div class="arrow slick-next" id="next"><i class="fas fa-chevron-right"></i></div>
                    </div>
                </div>
            </div>
            <div class="container container-1720">
                <div class="tab-content">
                    <div class="tab-pane fade show active" id="all" role="tabpanel" aria-labelledby="all">
                        <div class="slick-slider arrow-top full-slide custom-nav equal-height"
                            data-slick-options='{"slidesToShow": 5,"autoplay":false,"dots":false,"arrows":false,"responsive":[{"breakpoint": 2000,"settings": {"slidesToShow": 4}},{"breakpoint": 1500,"settings": {"slidesToShow": 3}},{"breakpoint": 1000,"settings": {"slidesToShow": 2}},{"breakpoint": 770,"settings": {"slidesToShow": 1}}]}'>
                            <div class="box" data-animate="fadeInUp">
                                <div class="store card border-0 rounded-0">
                                    <div class="position-relative store-image">
                                        <a href="{{ url('site') }}/listing-details-full-gallery.html">
                                            <img src="{{ url('site') }}/images/shop/shop-1.jpg" alt="store 1"
                                                class="card-img-top rounded-0">
                                        </a>
                                        <div class="image-content position-absolute d-flex align-items-center">
                                            <div class="content-left">
                                                <div class="badge badge-primary">Featured</div>
                                            </div>
                                            <div class="content-right ml-auto d-flex w-lg show-link">
                                                <a href="{{ url('site') }}/images/shop/full-shop-1.jpg"
                                                    class="item viewing" data-toggle="tooltip" data-placement="top"
                                                    title="Quickview" data-gtf-mfp="true">
                                                    <svg class="icon icon-expand">
                                                        <use xlink:href="{{ url('site') }}/#icon-expand"></use>
                                                    </svg>
                                                </a>
                                                <a href="{{ url('site') }}/#" class="item marking"
                                                    data-toggle="tooltip" data-placement="top" title="Bookmark"><i
                                                        class="fal fa-bookmark"></i></a>
                                                <a href="{{ url('site') }}/#" class="item" data-toggle="tooltip"
                                                    data-placement="top" title="Compare">
                                                    <svg class="icon icon-chart-bars">
                                                        <use xlink:href="{{ url('site') }}/#icon-chart-bars"></use>
                                                    </svg>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-body px-0 pb-0 pt-3">
                                        <a href="{{ url('site') }}/listing-details-full-gallery.html"
                                            class="card-title h5 text-dark d-inline-block mb-2"><span
                                                class="letter-spacing-25">Roman
                                                Kraft Hotel</span></a>
                                        <ul
                                            class="list-inline store-meta mb-4 font-size-sm d-flex align-items-center flex-wrap">
                                            <li class="list-inline-item"><span
                                                    class="badge badge-success d-inline-block mr-1">5.0</span><span>4
                                                    rating</span>
                                            </li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><span class="mr-1">From</span><span
                                                    class="text-danger font-weight-semibold">$56.00</span></li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item">
                                                <a href="{{ url('site') }}/#" class="link-hover-secondary-primary">
                                                    <svg class="icon icon-bed">
                                                        <use xlink:href="{{ url('site') }}/#icon-bed"></use>
                                                    </svg>
                                                    <span>Hotel</span>
                                                </a>
                                            </li>
                                        </ul>
                                        <div class="media">
                                            <a href="{{ url('site') }}/#" class="d-inline-block mr-3"><img
                                                    src="{{ url('site') }}/images/listing/testimonial-1.png"
                                                    alt="testimonial" class="rounded-circle">
                                            </a>
                                            <div class="media-body lh-14 font-size-sm">Overlooking Bloomsbury's
                                                Russell Square
                                                and
                                                a 2 minutes' walk from the tube station of the same name...
                                            </div>
                                        </div>
                                    </div>
                                    <ul
                                        class="list-inline card-footer rounded-0 border-top pt-3 mt-5 bg-transparent px-0 store-meta d-flex align-items-center">
                                        <li class="list-inline-item">
                                            <span class="d-inline-block mr-1">
                                                <i class="fal fa-map-marker-alt">
                                                </i>
                                            </span>
                                            <a href="{{ url('site') }}/#"
                                                class="text-secondary text-decoration-none link-hover-secondary-blue">
                                                San Francisco, CA</a>
                                        </li>
                                        <li class="list-inline-item separate"></li>
                                        <li class="list-inline-item">
                                            <span class="text-green">Open now!</span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="box" data-animate="fadeInUp">
                                <div class="store card border-0 rounded-0">
                                    <div class="position-relative store-image">
                                        <a href="{{ url('site') }}/listing-details-full-gallery.html">
                                            <img src="{{ url('site') }}/images/shop/shop-2.jpg" alt="store 2"
                                                class="card-img-top rounded-0">
                                        </a>
                                        <div class="image-content position-absolute d-flex align-items-center">
                                            <div class="content-left">
                                                <div class="badge badge-primary">Best Rate</div>
                                            </div>
                                            <div class="content-right ml-auto d-flex show-link">
                                                <a href="{{ url('site') }}/images/shop/full-shop-2.jpg"
                                                    data-gtf-mfp="true" class="item viewing" data-toggle="tooltip"
                                                    data-placement="top" title="Quick view">
                                                    <svg class="icon icon-expand">
                                                        <use xlink:href="{{ url('site') }}/#icon-expand"></use>
                                                    </svg>
                                                </a>
                                                <a href="{{ url('site') }}/#" class="item marking"
                                                    data-toggle="tooltip" data-placement="top" title="Bookmark"><i
                                                        class="fal fa-bookmark"></i></a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-body px-0 pb-0 pt-3">
                                        <a href="{{ url('site') }}/listing-details-full-image.html"
                                            class="card-title h5 text-dark d-inline-block mb-2"><span
                                                class="letter-spacing-25">Karly Gomez Cake</span>
                                            <span class="check">
                                                <svg class="icon icon-check-circle">
                                                    <use xlink:href="{{ url('site') }}/#icon-check-circle"></use>
                                                </svg>
                                            </span>
                                        </a>
                                        <ul
                                            class="list-inline store-meta mb-4 font-size-sm d-flex align-items-center flex-wrap">
                                            <li class="list-inline-item"><span
                                                    class="badge badge-success d-inline-block mr-1">5.0</span><span>8
                                                    rating</span>
                                            </li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><span class="mr-1">From</span><span
                                                    class="text-danger font-weight-semibold">$12.00</span></li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><a href="{{ url('site') }}/#"
                                                    class="link-hover-secondary-primary">
                                                    <svg class="icon icon-pizza">
                                                        <use xlink:href="{{ url('site') }}/#icon-pizza"></use>
                                                    </svg>
                                                    <span>Food</span>
                                                </a></li>
                                        </ul>

                                        <div class="media">
                                            <a href="{{ url('site') }}/#" class="d-inline-block mr-3"><img
                                                    src="{{ url('site') }}/images/listing/testimonial-2.png"
                                                    alt="testimonial" class="rounded-circle">
                                            </a>
                                            <div class="media-body lh-14 font-size-sm">They specialize in makgeolli
                                                at this
                                                Korean-style pub in Seorae Village. And they use...
                                            </div>
                                        </div>
                                    </div>
                                    <ul
                                        class="list-inline card-footer rounded-0 border-top pt-3 mt-5 bg-transparent px-0 store-meta d-flex align-items-center">
                                        <li class="list-inline-item">
                                            <span class="d-inline-block mr-1">
                                                <i class="fal fa-map-marker-alt">
                                                </i>
                                            </span>
                                            <a href="{{ url('site') }}/#"
                                                class="text-secondary text-decoration-none address">Florencia,
                                                Italy</a>
                                        </li>
                                        <li class="list-inline-item separate"></li>
                                        <li class="list-inline-item">
                                            <span class="text-danger">Close now!</span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="box" data-animate="fadeInUp">
                                <div class="store card border-0 rounded-0">
                                    <div class="position-relative store-image">
                                        <a href="{{ url('site') }}/listing-details-full-gallery.html">
                                            <img src="{{ url('site') }}/images/shop/shop-3.jpg" alt="store 1"
                                                class="card-img-top rounded-0">
                                        </a>
                                        <div class="image-content position-absolute d-flex align-items-center">
                                            <div class="content-left">
                                                <div class="badge badge-primary">Most view</div>
                                            </div>
                                            <div class="content-right ml-auto d-flex show-link">
                                                <a href="{{ url('site') }}/images/shop/full-shop-3.jpg"
                                                    class="item viewing" data-toggle="tooltip" data-placement="top"
                                                    title="Quick view" data-gtf-mfp="true">
                                                    <svg class="icon icon-expand">
                                                        <use xlink:href="{{ url('site') }}/#icon-expand"></use>
                                                    </svg>
                                                </a>
                                                <a href="{{ url('site') }}/#" class="item marking"
                                                    data-toggle="tooltip" data-placement="top" title="Bookmark"><i
                                                        class="fal fa-bookmark"></i></a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-body px-0 pb-0 pt-3">
                                        <a href="{{ url('site') }}/listing-details-full-gallery.html"
                                            class="card-title h5 text-dark d-inline-block mb-2"><span
                                                class="letter-spacing-25">Roman
                                                Kraft Hotel</span></a>
                                        <ul
                                            class="list-inline store-meta mb-4 font-size-sm d-flex align-items-center flex-wrap">
                                            <li class="list-inline-item"><span
                                                    class="badge badge-warning d-inline-block mr-1">4.3</span><span>4
                                                    rating</span>
                                            </li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><span class="mr-1">From</span><span
                                                    class="text-danger font-weight-semibold">$10.00</span></li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><a href="{{ url('site') }}/#"
                                                    class="link-hover-secondary-primary">
                                                    <svg class="icon icon-pizza">
                                                        <use xlink:href="{{ url('site') }}/#icon-pizza"></use>
                                                    </svg>
                                                    <span>Food</span>
                                                </a></li>
                                        </ul>
                                        <div class="media">
                                            <a href="{{ url('site') }}/#" class="d-inline-block mr-3"><img
                                                    src="{{ url('site') }}/images/listing/testimonial-5.png"
                                                    alt="testimonial" class="rounded-circle">
                                            </a>
                                            <div class="media-body lh-14 font-size-sm">After a yoga class changed
                                                her life, Maz
                                                became
                                                vegan, launched...
                                            </div>
                                        </div>
                                    </div>
                                    <ul
                                        class="list-inline card-footer rounded-0 border-top pt-3 mt-5 bg-transparent px-0 store-meta d-flex align-items-center">
                                        <li class="list-inline-item">
                                            <span class="d-inline-block mr-1"><i class="fal fa-map-marker-alt">
                                                </i>
                                            </span>
                                            <a href="{{ url('site') }}/#"
                                                class="text-secondary text-decoration-none address">Miami,
                                                FL</a>
                                        </li>
                                        <li class="list-inline-item separate"></li>
                                        <li class="list-inline-item">
                                            <span class="text-danger">Close now!</span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="box" data-animate="fadeInUp">
                                <div class="store card border-0 rounded-0">
                                    <div class="position-relative store-image">
                                        <a href="{{ url('site') }}/listing-details-full-gallery.html">
                                            <img src="{{ url('site') }}/images/shop/shop-4.jpg" alt="store 1"
                                                class="card-img-top rounded-0">
                                        </a>
                                        <div class="image-content position-absolute d-flex align-items-center">
                                            <div class="content-left">
                                                <div class="badge badge-primary">Featured</div>
                                            </div>
                                            <div class="content-right ml-auto d-flex show-link">
                                                <a href="{{ url('site') }}/images/shop/full-shop-4.jpg"
                                                    class="item viewing" data-toggle="tooltip" data-gtf-mfp="true"
                                                    data-placement="top" title="Quick view">
                                                    <svg class="icon icon-expand">
                                                        <use xlink:href="{{ url('site') }}/#icon-expand"></use>
                                                    </svg>
                                                </a>
                                                <a href="{{ url('site') }}/#" class="item marking"
                                                    data-toggle="tooltip" data-placement="top" title="Bookmark"><i
                                                        class="fal fa-bookmark"></i></a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-body px-0 pb-0 pt-3">
                                        <a href="{{ url('site') }}/listing-details-full-image.html"
                                            class="card-title h5 text-dark d-inline-block mb-2"><span
                                                class="letter-spacing-25">Red Wings Shoes Store</span></a>
                                        <ul
                                            class="list-inline store-meta mb-4 font-size-sm d-flex align-items-center flex-wrap">
                                            <li class="list-inline-item"><span
                                                    class="badge badge-success d-inline-block mr-1">5.0</span><span>6
                                                    rating</span>
                                            </li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><span class="mr-1">From</span><span
                                                    class="text-danger font-weight-semibold">$75.00</span></li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><a href="{{ url('site') }}/#"
                                                    class="link-hover-secondary-primary">
                                                    <svg class="icon icon-bag">
                                                        <use xlink:href="{{ url('site') }}/#icon-bag"></use>
                                                    </svg>
                                                    <span>Shopping</span>
                                                </a></li>
                                        </ul>
                                        <div class="media">
                                            <a href="{{ url('site') }}/#" class="d-inline-block mr-3"><img
                                                    src="{{ url('site') }}/images/listing/testimonial-3.png"
                                                    alt="testimonial" class="rounded-circle">
                                            </a>
                                            <div class="media-body lh-14 font-size-sm">Established in 1895, these
                                                style
                                                merchants have
                                                set the standard in Sydney suiting for generations...
                                            </div>
                                        </div>
                                    </div>
                                    <ul
                                        class="list-inline card-footer rounded-0 border-top pt-3 mt-5 bg-transparent px-0 store-meta d-flex align-items-center">
                                        <li class="list-inline-item">
                                            <span class="d-inline-block mr-1"><i class="fal fa-map-marker-alt">
                                                </i>
                                            </span>
                                            <a href="{{ url('site') }}/#"
                                                class="text-secondary text-decoration-none address">
                                                Paris, France</a>
                                        </li>
                                        <li class="list-inline-item separate"></li>
                                        <li class="list-inline-item">
                                            <span class="text-danger">Close now!</span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="box" data-animate="fadeInUp">
                                <div class="store card border-0 rounded-0">
                                    <div class="position-relative store-image">
                                        <a href="{{ url('site') }}/listing-details-full-gallery.html">
                                            <img src="{{ url('site') }}/images/shop/shop-5.jpg" alt="store 1"
                                                class="card-img-top rounded-0">
                                        </a>
                                        <div class="image-content position-absolute d-flex align-items-center">
                                            <div class="content-left">
                                                <div class="badge badge-primary">AD</div>
                                            </div>
                                            <div class="content-right ml-auto d-flex show-link">
                                                <a href="{{ url('site') }}/images/shop/full-shop-5.jpg"
                                                    class="item viewing" data-toggle="tooltip" data-placement="top"
                                                    data-gtf-mfp="true" title="Quick view">
                                                    <svg class="icon icon-expand">
                                                        <use xlink:href="{{ url('site') }}/#icon-expand"></use>
                                                    </svg>
                                                </a>
                                                <a href="{{ url('site') }}/#" class="item marking"
                                                    data-toggle="tooltip" data-placement="top" title="Bookmark"><i
                                                        class="fal fa-bookmark"></i></a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-body px-0 pb-0 pt-3">
                                        <a href="{{ url('site') }}/listing-details-full-image.html"
                                            class="card-title h5 text-dark d-inline-block mb-2"><span
                                                class="letter-spacing-25">Packing & Delivery Service</span>
                                            <span class="check">
                                                <svg class="icon icon-check-circle">
                                                    <use xlink:href="{{ url('site') }}/#icon-check-circle"></use>
                                                </svg>
                                            </span>
                                        </a>
                                        <ul
                                            class="list-inline store-meta mb-4 font-size-sm d-flex align-items-center flex-wrap">
                                            <li class="list-inline-item"><span
                                                    class="badge badge-warning d-inline-block mr-1">4.5</span><span>2
                                                    rating</span>
                                            </li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><span
                                                    class="text-danger font-weight-semibold">Get a quote</span>
                                            </li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><a href="{{ url('site') }}/#"
                                                    class="link-hover-secondary-primary">
                                                    <svg class="icon icon-cog">
                                                        <use xlink:href="{{ url('site') }}/#icon-cog"></use>
                                                    </svg>
                                                    <span>Service</span>
                                                </a></li>
                                        </ul>
                                        <div class="media">
                                            <a href="{{ url('site') }}/#" class="d-inline-block mr-3"><img
                                                    src="{{ url('site') }}/images/listing/testimonial-2.png"
                                                    alt="testimonial" class="rounded-circle">
                                            </a>
                                            <div class="media-body lh-14 font-size-sm">Most items can be packed
                                                securely in
                                                these
                                                boxes, which are available in several sizes...
                                            </div>
                                        </div>
                                    </div>
                                    <ul
                                        class="list-inline card-footer rounded-0 border-top pt-3 mt-5 bg-transparent px-0 store-meta d-flex align-items-center">
                                        <li class="list-inline-item">
                                            <span class="d-inline-block mr-1"><i class="fal fa-map-marker-alt">
                                                </i>
                                            </span>
                                            <a href="{{ url('site') }}/#"
                                                class="text-secondary text-decoration-none address">New
                                                York, USA</a>
                                        </li>
                                        <li class="list-inline-item separate"></li>
                                        <li class="list-inline-item">
                                            <span class="text-green">Open now!</span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="box" data-animate="fadeInUp">
                                <div class="store card border-0 rounded-0">
                                    <div class="position-relative store-image">
                                        <a href="{{ url('site') }}/listing-details-full-gallery.html">
                                            <img src="{{ url('site') }}/images/shop/shop-1.jpg" alt="store 1"
                                                class="card-img-top rounded-0">
                                        </a>
                                        <div class="image-content position-absolute d-flex align-items-center">
                                            <div class="content-left">
                                                <div class="badge badge-primary">Featured</div>
                                            </div>
                                            <div class="content-right ml-auto d-flex show-link">
                                                <a href="{{ url('site') }}/images/shop/full-shop-1.jpg"
                                                    class="item viewing" data-toggle="tooltip" data-placement="top"
                                                    title="Quickview" data-gtf-mfp="true">
                                                    <svg class="icon icon-expand">
                                                        <use xlink:href="{{ url('site') }}/#icon-expand"></use>
                                                    </svg>
                                                </a>
                                                <a href="{{ url('site') }}/#" class="item marking"
                                                    data-toggle="tooltip" data-placement="top" title="Bookmark"><i
                                                        class="fal fa-bookmark"></i></a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-body px-0 pb-0 pt-3">
                                        <a href="{{ url('site') }}/listing-details-full-gallery.html"
                                            class="card-title h5 text-dark d-inline-block mb-2"><span
                                                class="letter-spacing-25">Roman
                                                Kraft Hotel</span></a>
                                        <ul
                                            class="list-inline store-meta mb-4 font-size-sm d-flex align-items-center flex-wrap">
                                            <li class="list-inline-item"><span
                                                    class="badge badge-success d-inline-block mr-1">5.0</span><span>4
                                                    rating</span>
                                            </li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><span class="mr-1">From</span><span
                                                    class="text-danger font-weight-semibold">$9.00</span></li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><a href="{{ url('site') }}/#"
                                                    class="link-hover-secondary-primary">
                                                    <svg class="icon icon-pizza">
                                                        <use xlink:href="{{ url('site') }}/#icon-pizza"></use>
                                                    </svg>
                                                    <span>Food</span>
                                                </a></li>
                                        </ul>

                                        <div class="media">
                                            <a href="{{ url('site') }}/#" class="d-inline-block mr-3"><img
                                                    src="{{ url('site') }}/images/listing/testimonial-1.png"
                                                    alt="testimonial" class="rounded-circle">
                                            </a>
                                            <div class="media-body lh-14 font-size-sm">They specialize in makgeolli
                                                at this
                                                Korean-style
                                                pub in Seorae Village. And they use...
                                            </div>
                                        </div>
                                    </div>
                                    <ul
                                        class="list-inline card-footer rounded-0 border-top pt-3 mt-5 bg-transparent px-0 store-meta d-flex align-items-center">
                                        <li class="list-inline-item">
                                            <span class="d-inline-block mr-1"><i class="fal fa-map-marker-alt">
                                                </i>
                                            </span>
                                            <a href="{{ url('site') }}/#"
                                                class="text-secondary text-decoration-none address py-1">Ubud,
                                                Indonesia</a>
                                        </li>
                                        <li class="list-inline-item separate"></li>
                                        <li class="list-inline-item">
                                            <span class="text-danger">Close now!</span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="feature" role="tabpanel" aria-labelledby="feature">
                        <div class="slick-slider arrow-top full-slide custom-nav equal-height"
                            data-slick-options='{"slidesToShow": 5,"autoplay":false,"dots":false,"arrows":false,"responsive":[{"breakpoint": 2000,"settings": {"slidesToShow": 4}},{"breakpoint": 1500,"settings": {"slidesToShow": 3}},{"breakpoint": 1000,"settings": {"slidesToShow": 2}},{"breakpoint": 770,"settings": {"slidesToShow": 1}}]}'>
                            <div class="box" data-animate="fadeInUp">
                                <div class="store card border-0 rounded-0">
                                    <div class="position-relative store-image">
                                        <a href="{{ url('site') }}/listing-details-full-gallery.html">
                                            <img src="{{ url('site') }}/images/shop/shop-1.jpg" alt="store 1"
                                                class="card-img-top rounded-0">
                                        </a>
                                        <div class="image-content position-absolute d-flex align-items-center">
                                            <div class="content-left">
                                                <div class="badge badge-primary">Featured</div>
                                            </div>
                                            <div class="content-right ml-auto d-flex w-lg show-link">
                                                <a href="{{ url('site') }}/images/shop/full-shop-1.jpg"
                                                    class="item viewing" data-toggle="tooltip" data-placement="top"
                                                    title="Quickview" data-gtf-mfp="true">
                                                    <svg class="icon icon-expand">
                                                        <use xlink:href="{{ url('site') }}/#icon-expand"></use>
                                                    </svg>
                                                </a>
                                                <a href="{{ url('site') }}/#" class="item marking"
                                                    data-toggle="tooltip" data-placement="top" title="Bookmark"><i
                                                        class="fal fa-bookmark"></i></a>
                                                <a href="{{ url('site') }}/#" class="item" data-toggle="tooltip"
                                                    data-placement="top" title="Compare">
                                                    <svg class="icon icon-chart-bars">
                                                        <use xlink:href="{{ url('site') }}/#icon-chart-bars"></use>
                                                    </svg>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-body px-0 pb-0 pt-3">
                                        <a href="{{ url('site') }}/listing-details-full-gallery.html"
                                            class="card-title h5 text-dark d-inline-block mb-2"><span
                                                class="letter-spacing-25">Roman
                                                Kraft Hotel</span></a>
                                        <ul
                                            class="list-inline store-meta mb-4 font-size-sm d-flex align-items-center flex-wrap">
                                            <li class="list-inline-item"><span
                                                    class="badge badge-success d-inline-block mr-1">5.0</span><span>4
                                                    rating</span>
                                            </li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><span class="mr-1">From</span><span
                                                    class="text-danger font-weight-semibold">$56.00</span></li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item">
                                                <a href="{{ url('site') }}/#" class="link-hover-secondary-primary">
                                                    <svg class="icon icon-bed">
                                                        <use xlink:href="{{ url('site') }}/#icon-bed"></use>
                                                    </svg>
                                                    <span>Hotel</span>
                                                </a>
                                            </li>
                                        </ul>
                                        <div class="media">
                                            <a href="{{ url('site') }}/#" class="d-inline-block mr-3"><img
                                                    src="{{ url('site') }}/images/listing/testimonial-1.png"
                                                    alt="testimonial" class="rounded-circle">
                                            </a>
                                            <div class="media-body lh-14 font-size-sm">Overlooking Bloomsbury's
                                                Russell Square
                                                and
                                                a 2 minutes' walk from the tube station of the same name...
                                            </div>
                                        </div>
                                    </div>
                                    <ul
                                        class="list-inline card-footer rounded-0 border-top pt-3 mt-5 bg-transparent px-0 store-meta d-flex align-items-center">
                                        <li class="list-inline-item">
                                            <span class="d-inline-block mr-1">
                                                <i class="fal fa-map-marker-alt">
                                                </i>
                                            </span>
                                            <a href="{{ url('site') }}/#"
                                                class="text-secondary text-decoration-none link-hover-secondary-blue">
                                                San Francisco, CA</a>
                                        </li>
                                        <li class="list-inline-item separate"></li>
                                        <li class="list-inline-item">
                                            <span class="text-green">Open now!</span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="box" data-animate="fadeInUp">
                                <div class="store card border-0 rounded-0">
                                    <div class="position-relative store-image">
                                        <a href="{{ url('site') }}/listing-details-full-gallery.html">
                                            <img src="{{ url('site') }}/images/shop/shop-2.jpg" alt="store 2"
                                                class="card-img-top rounded-0">
                                        </a>
                                        <div class="image-content position-absolute d-flex align-items-center">
                                            <div class="content-left">
                                                <div class="badge badge-primary">Best Rate</div>
                                            </div>
                                            <div class="content-right ml-auto d-flex show-link">
                                                <a href="{{ url('site') }}/images/shop/full-shop-2.jpg"
                                                    data-gtf-mfp="true" class="item viewing" data-toggle="tooltip"
                                                    data-placement="top" title="Quick view">
                                                    <svg class="icon icon-expand">
                                                        <use xlink:href="{{ url('site') }}/#icon-expand"></use>
                                                    </svg>
                                                </a>
                                                <a href="{{ url('site') }}/#" class="item marking"
                                                    data-toggle="tooltip" data-placement="top" title="Bookmark"><i
                                                        class="fal fa-bookmark"></i></a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-body px-0 pb-0 pt-3">
                                        <a href="{{ url('site') }}/listing-details-full-image.html"
                                            class="card-title h5 text-dark d-inline-block mb-2"><span
                                                class="letter-spacing-25">Karly Gomez Cake</span>
                                            <span class="check">
                                                <svg class="icon icon-check-circle">
                                                    <use xlink:href="{{ url('site') }}/#icon-check-circle"></use>
                                                </svg>
                                            </span>
                                        </a>
                                        <ul
                                            class="list-inline store-meta mb-4 font-size-sm d-flex align-items-center flex-wrap">
                                            <li class="list-inline-item"><span
                                                    class="badge badge-success d-inline-block mr-1">5.0</span><span>8
                                                    rating</span>
                                            </li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><span class="mr-1">From</span><span
                                                    class="text-danger font-weight-semibold">$12.00</span></li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><a href="{{ url('site') }}/#"
                                                    class="link-hover-secondary-primary">
                                                    <svg class="icon icon-pizza">
                                                        <use xlink:href="{{ url('site') }}/#icon-pizza"></use>
                                                    </svg>
                                                    <span>Food</span>
                                                </a></li>
                                        </ul>

                                        <div class="media">
                                            <a href="{{ url('site') }}/#" class="d-inline-block mr-3"><img
                                                    src="{{ url('site') }}/images/listing/testimonial-2.png"
                                                    alt="testimonial" class="rounded-circle">
                                            </a>
                                            <div class="media-body lh-14 font-size-sm">They specialize in makgeolli
                                                at this
                                                Korean-style pub in Seorae Village. And they use...
                                            </div>
                                        </div>
                                    </div>
                                    <ul
                                        class="list-inline card-footer rounded-0 border-top pt-3 mt-5 bg-transparent px-0 store-meta d-flex align-items-center">
                                        <li class="list-inline-item">
                                            <span class="d-inline-block mr-1">
                                                <i class="fal fa-map-marker-alt">
                                                </i>
                                            </span>
                                            <a href="{{ url('site') }}/#"
                                                class="text-secondary text-decoration-none address">Florencia,
                                                Italy</a>
                                        </li>
                                        <li class="list-inline-item separate"></li>
                                        <li class="list-inline-item">
                                            <span class="text-danger">Close now!</span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="box" data-animate="fadeInUp">
                                <div class="store card border-0 rounded-0">
                                    <div class="position-relative store-image">
                                        <a href="{{ url('site') }}/listing-details-full-gallery.html">
                                            <img src="{{ url('site') }}/images/shop/shop-3.jpg" alt="store 1"
                                                class="card-img-top rounded-0">
                                        </a>
                                        <div class="image-content position-absolute d-flex align-items-center">
                                            <div class="content-left">
                                                <div class="badge badge-primary">Most view</div>
                                            </div>
                                            <div class="content-right ml-auto d-flex show-link">
                                                <a href="{{ url('site') }}/images/shop/full-shop-3.jpg"
                                                    class="item viewing" data-toggle="tooltip" data-placement="top"
                                                    title="Quick view" data-gtf-mfp="true">
                                                    <svg class="icon icon-expand">
                                                        <use xlink:href="{{ url('site') }}/#icon-expand"></use>
                                                    </svg>
                                                </a>
                                                <a href="{{ url('site') }}/#" class="item marking"
                                                    data-toggle="tooltip" data-placement="top" title="Bookmark"><i
                                                        class="fal fa-bookmark"></i></a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-body px-0 pb-0 pt-3">
                                        <a href="{{ url('site') }}/listing-details-full-gallery.html"
                                            class="card-title h5 text-dark d-inline-block mb-2"><span
                                                class="letter-spacing-25">Roman
                                                Kraft Hotel</span></a>
                                        <ul
                                            class="list-inline store-meta mb-4 font-size-sm d-flex align-items-center flex-wrap">
                                            <li class="list-inline-item"><span
                                                    class="badge badge-warning d-inline-block mr-1">4.3</span><span>4
                                                    rating</span>
                                            </li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><span class="mr-1">From</span><span
                                                    class="text-danger font-weight-semibold">$10.00</span></li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><a href="{{ url('site') }}/#"
                                                    class="link-hover-secondary-primary">
                                                    <svg class="icon icon-pizza">
                                                        <use xlink:href="{{ url('site') }}/#icon-pizza"></use>
                                                    </svg>
                                                    <span>Food</span>
                                                </a></li>
                                        </ul>
                                        <div class="media">
                                            <a href="{{ url('site') }}/#" class="d-inline-block mr-3"><img
                                                    src="{{ url('site') }}/images/listing/testimonial-5.png"
                                                    alt="testimonial" class="rounded-circle">
                                            </a>
                                            <div class="media-body lh-14 font-size-sm">After a yoga class changed
                                                her life, Maz
                                                became
                                                vegan, launched...
                                            </div>
                                        </div>
                                    </div>
                                    <ul
                                        class="list-inline card-footer rounded-0 border-top pt-3 mt-5 bg-transparent px-0 store-meta d-flex align-items-center">
                                        <li class="list-inline-item">
                                            <span class="d-inline-block mr-1"><i class="fal fa-map-marker-alt">
                                                </i>
                                            </span>
                                            <a href="{{ url('site') }}/#"
                                                class="text-secondary text-decoration-none address">Miami,
                                                FL</a>
                                        </li>
                                        <li class="list-inline-item separate"></li>
                                        <li class="list-inline-item">
                                            <span class="text-danger">Close now!</span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="box" data-animate="fadeInUp">
                                <div class="store card border-0 rounded-0">
                                    <div class="position-relative store-image">
                                        <a href="{{ url('site') }}/listing-details-full-gallery.html">
                                            <img src="{{ url('site') }}/images/shop/shop-4.jpg" alt="store 1"
                                                class="card-img-top rounded-0">
                                        </a>
                                        <div class="image-content position-absolute d-flex align-items-center">
                                            <div class="content-left">
                                                <div class="badge badge-primary">Featured</div>
                                            </div>
                                            <div class="content-right ml-auto d-flex show-link">
                                                <a href="{{ url('site') }}/images/shop/full-shop-4.jpg"
                                                    class="item viewing" data-toggle="tooltip" data-gtf-mfp="true"
                                                    data-placement="top" title="Quick view">
                                                    <svg class="icon icon-expand">
                                                        <use xlink:href="{{ url('site') }}/#icon-expand"></use>
                                                    </svg>
                                                </a>
                                                <a href="{{ url('site') }}/#" class="item marking"
                                                    data-toggle="tooltip" data-placement="top" title="Bookmark"><i
                                                        class="fal fa-bookmark"></i></a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-body px-0 pb-0 pt-3">
                                        <a href="{{ url('site') }}/listing-details-full-image.html"
                                            class="card-title h5 text-dark d-inline-block mb-2"><span
                                                class="letter-spacing-25">Red Wings Shoes Store</span></a>
                                        <ul
                                            class="list-inline store-meta mb-4 font-size-sm d-flex align-items-center flex-wrap">
                                            <li class="list-inline-item"><span
                                                    class="badge badge-success d-inline-block mr-1">5.0</span><span>6
                                                    rating</span>
                                            </li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><span class="mr-1">From</span><span
                                                    class="text-danger font-weight-semibold">$75.00</span></li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><a href="{{ url('site') }}/#"
                                                    class="link-hover-secondary-primary">
                                                    <svg class="icon icon-bag">
                                                        <use xlink:href="{{ url('site') }}/#icon-bag"></use>
                                                    </svg>
                                                    <span>Shopping</span>
                                                </a></li>
                                        </ul>
                                        <div class="media">
                                            <a href="{{ url('site') }}/#" class="d-inline-block mr-3"><img
                                                    src="{{ url('site') }}/images/listing/testimonial-3.png"
                                                    alt="testimonial" class="rounded-circle">
                                            </a>
                                            <div class="media-body lh-14 font-size-sm">Established in 1895, these
                                                style
                                                merchants have
                                                set the standard in Sydney suiting for generations...
                                            </div>
                                        </div>
                                    </div>
                                    <ul
                                        class="list-inline card-footer rounded-0 border-top pt-3 mt-5 bg-transparent px-0 store-meta d-flex align-items-center">
                                        <li class="list-inline-item">
                                            <span class="d-inline-block mr-1"><i class="fal fa-map-marker-alt">
                                                </i>
                                            </span>
                                            <a href="{{ url('site') }}/#"
                                                class="text-secondary text-decoration-none address">
                                                Paris, France</a>
                                        </li>
                                        <li class="list-inline-item separate"></li>
                                        <li class="list-inline-item">
                                            <span class="text-danger">Close now!</span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="box" data-animate="fadeInUp">
                                <div class="store card border-0 rounded-0">
                                    <div class="position-relative store-image">
                                        <a href="{{ url('site') }}/listing-details-full-gallery.html">
                                            <img src="{{ url('site') }}/images/shop/shop-5.jpg" alt="store 1"
                                                class="card-img-top rounded-0">
                                        </a>
                                        <div class="image-content position-absolute d-flex align-items-center">
                                            <div class="content-left">
                                                <div class="badge badge-primary">AD</div>
                                            </div>
                                            <div class="content-right ml-auto d-flex show-link">
                                                <a href="{{ url('site') }}/images/shop/full-shop-5.jpg"
                                                    class="item viewing" data-toggle="tooltip" data-placement="top"
                                                    data-gtf-mfp="true" title="Quick view">
                                                    <svg class="icon icon-expand">
                                                        <use xlink:href="{{ url('site') }}/#icon-expand"></use>
                                                    </svg>
                                                </a>
                                                <a href="{{ url('site') }}/#" class="item marking"
                                                    data-toggle="tooltip" data-placement="top" title="Bookmark"><i
                                                        class="fal fa-bookmark"></i></a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-body px-0 pb-0 pt-3">
                                        <a href="{{ url('site') }}/listing-details-full-image.html"
                                            class="card-title h5 text-dark d-inline-block mb-2"><span
                                                class="letter-spacing-25">Packing & Delivery Service</span>
                                            <span class="check">
                                                <svg class="icon icon-check-circle">
                                                    <use xlink:href="{{ url('site') }}/#icon-check-circle"></use>
                                                </svg>
                                            </span>
                                        </a>
                                        <ul
                                            class="list-inline store-meta mb-4 font-size-sm d-flex align-items-center flex-wrap">
                                            <li class="list-inline-item"><span
                                                    class="badge badge-warning d-inline-block mr-1">4.5</span><span>2
                                                    rating</span>
                                            </li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><span
                                                    class="text-danger font-weight-semibold">Get a quote</span>
                                            </li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><a href="{{ url('site') }}/#"
                                                    class="link-hover-secondary-primary">
                                                    <svg class="icon icon-cog">
                                                        <use xlink:href="{{ url('site') }}/#icon-cog"></use>
                                                    </svg>
                                                    <span>Service</span>
                                                </a></li>
                                        </ul>
                                        <div class="media">
                                            <a href="{{ url('site') }}/#" class="d-inline-block mr-3"><img
                                                    src="{{ url('site') }}/images/listing/testimonial-2.png"
                                                    alt="testimonial" class="rounded-circle">
                                            </a>
                                            <div class="media-body lh-14 font-size-sm">Most items can be packed
                                                securely in
                                                these
                                                boxes, which are available in several sizes...
                                            </div>
                                        </div>
                                    </div>
                                    <ul
                                        class="list-inline card-footer rounded-0 border-top pt-3 mt-5 bg-transparent px-0 store-meta d-flex align-items-center">
                                        <li class="list-inline-item">
                                            <span class="d-inline-block mr-1"><i class="fal fa-map-marker-alt">
                                                </i>
                                            </span>
                                            <a href="{{ url('site') }}/#"
                                                class="text-secondary text-decoration-none address">New
                                                York, USA</a>
                                        </li>
                                        <li class="list-inline-item separate"></li>
                                        <li class="list-inline-item">
                                            <span class="text-green">Open now!</span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="box" data-animate="fadeInUp">
                                <div class="store card border-0 rounded-0">
                                    <div class="position-relative store-image">
                                        <a href="{{ url('site') }}/listing-details-full-gallery.html">
                                            <img src="{{ url('site') }}/images/shop/shop-1.jpg" alt="store 1"
                                                class="card-img-top rounded-0">
                                        </a>
                                        <div class="image-content position-absolute d-flex align-items-center">
                                            <div class="content-left">
                                                <div class="badge badge-primary">Featured</div>
                                            </div>
                                            <div class="content-right ml-auto d-flex show-link">
                                                <a href="{{ url('site') }}/images/shop/full-shop-1.jpg"
                                                    class="item viewing" data-toggle="tooltip" data-placement="top"
                                                    title="Quickview" data-gtf-mfp="true">
                                                    <svg class="icon icon-expand">
                                                        <use xlink:href="{{ url('site') }}/#icon-expand"></use>
                                                    </svg>
                                                </a>
                                                <a href="{{ url('site') }}/#" class="item marking"
                                                    data-toggle="tooltip" data-placement="top" title="Bookmark"><i
                                                        class="fal fa-bookmark"></i></a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-body px-0 pb-0 pt-3">
                                        <a href="{{ url('site') }}/listing-details-full-gallery.html"
                                            class="card-title h5 text-dark d-inline-block mb-2"><span
                                                class="letter-spacing-25">Roman
                                                Kraft Hotel</span></a>
                                        <ul
                                            class="list-inline store-meta mb-4 font-size-sm d-flex align-items-center flex-wrap">
                                            <li class="list-inline-item"><span
                                                    class="badge badge-success d-inline-block mr-1">5.0</span><span>4
                                                    rating</span>
                                            </li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><span class="mr-1">From</span><span
                                                    class="text-danger font-weight-semibold">$9.00</span></li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><a href="{{ url('site') }}/#"
                                                    class="link-hover-secondary-primary">
                                                    <svg class="icon icon-pizza">
                                                        <use xlink:href="{{ url('site') }}/#icon-pizza"></use>
                                                    </svg>
                                                    <span>Food</span>
                                                </a></li>
                                        </ul>

                                        <div class="media">
                                            <a href="{{ url('site') }}/#" class="d-inline-block mr-3"><img
                                                    src="{{ url('site') }}/images/listing/testimonial-1.png"
                                                    alt="testimonial" class="rounded-circle">
                                            </a>
                                            <div class="media-body lh-14 font-size-sm">They specialize in makgeolli
                                                at this
                                                Korean-style
                                                pub in Seorae Village. And they use...
                                            </div>
                                        </div>
                                    </div>
                                    <ul
                                        class="list-inline card-footer rounded-0 border-top pt-3 mt-5 bg-transparent px-0 store-meta d-flex align-items-center">
                                        <li class="list-inline-item">
                                            <span class="d-inline-block mr-1"><i class="fal fa-map-marker-alt">
                                                </i>
                                            </span>
                                            <a href="{{ url('site') }}/#"
                                                class="text-secondary text-decoration-none address py-1">Ubud,
                                                Indonesia</a>
                                        </li>
                                        <li class="list-inline-item separate"></li>
                                        <li class="list-inline-item">
                                            <span class="text-danger">Close now!</span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="best-rate" role="tabpanel" aria-labelledby="best-rate">
                        <div class="slick-slider arrow-top full-slide custom-nav"
                            data-slick-options='{"slidesToShow": 5,"autoplay":false,"dots":false,"arrows":false,"responsive":[{"breakpoint": 2000,"settings": {"slidesToShow": 4}},{"breakpoint": 1500,"settings": {"slidesToShow": 3}},{"breakpoint": 1000,"settings": {"slidesToShow": 2}},{"breakpoint": 770,"settings": {"slidesToShow": 1}}]}'>
                            <div class="box" data-animate="fadeInUp">
                                <div class="store card border-0 rounded-0">
                                    <div class="position-relative store-image">
                                        <a href="{{ url('site') }}/listing-details-full-gallery.html">
                                            <img src="{{ url('site') }}/images/shop/shop-1.jpg" alt="store 1"
                                                class="card-img-top rounded-0">
                                        </a>
                                        <div class="image-content position-absolute d-flex align-items-center">
                                            <div class="content-left">
                                                <div class="badge badge-primary">Featured</div>
                                            </div>
                                            <div class="content-right ml-auto d-flex w-lg show-link">
                                                <a href="{{ url('site') }}/images/shop/full-shop-1.jpg"
                                                    class="item viewing" data-toggle="tooltip" data-placement="top"
                                                    title="Quickview" data-gtf-mfp="true">
                                                    <svg class="icon icon-expand">
                                                        <use xlink:href="{{ url('site') }}/#icon-expand"></use>
                                                    </svg>
                                                </a>
                                                <a href="{{ url('site') }}/#" class="item marking"
                                                    data-toggle="tooltip" data-placement="top" title="Bookmark"><i
                                                        class="fal fa-bookmark"></i></a>
                                                <a href="{{ url('site') }}/#" class="item" data-toggle="tooltip"
                                                    data-placement="top" title="Compare">
                                                    <svg class="icon icon-chart-bars">
                                                        <use xlink:href="{{ url('site') }}/#icon-chart-bars"></use>
                                                    </svg>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-body px-0 pb-0 pt-3">
                                        <a href="{{ url('site') }}/listing-details-full-gallery.html"
                                            class="card-title h5 text-dark d-inline-block mb-2"><span
                                                class="letter-spacing-25">Roman
                                                Kraft Hotel</span></a>
                                        <ul
                                            class="list-inline store-meta mb-4 font-size-sm d-flex align-items-center flex-wrap">
                                            <li class="list-inline-item"><span
                                                    class="badge badge-success d-inline-block mr-1">5.0</span><span>4
                                                    rating</span>
                                            </li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><span class="mr-1">From</span><span
                                                    class="text-danger font-weight-semibold">$56.00</span></li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item">
                                                <a href="{{ url('site') }}/#" class="link-hover-secondary-primary">
                                                    <svg class="icon icon-bed">
                                                        <use xlink:href="{{ url('site') }}/#icon-bed"></use>
                                                    </svg>
                                                    <span>Hotel</span>
                                                </a>
                                            </li>
                                        </ul>
                                        <div class="media">
                                            <a href="{{ url('site') }}/#" class="d-inline-block mr-3"><img
                                                    src="{{ url('site') }}/images/listing/testimonial-1.png"
                                                    alt="testimonial" class="rounded-circle">
                                            </a>
                                            <div class="media-body lh-14 font-size-sm">Overlooking Bloomsbury's
                                                Russell Square
                                                and
                                                a 2 minutes' walk from the tube station of the same name...
                                            </div>
                                        </div>
                                    </div>
                                    <ul
                                        class="list-inline card-footer rounded-0 border-top pt-3 mt-5 bg-transparent px-0 store-meta d-flex align-items-center">
                                        <li class="list-inline-item">
                                            <span class="d-inline-block mr-1">
                                                <i class="fal fa-map-marker-alt">
                                                </i>
                                            </span>
                                            <a href="{{ url('site') }}/#"
                                                class="text-secondary text-decoration-none link-hover-secondary-blue">
                                                San Francisco, CA</a>
                                        </li>
                                        <li class="list-inline-item separate"></li>
                                        <li class="list-inline-item">
                                            <span class="text-green">Open now!</span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="box" data-animate="fadeInUp">
                                <div class="store card border-0 rounded-0">
                                    <div class="position-relative store-image">
                                        <a href="{{ url('site') }}/listing-details-full-gallery.html">
                                            <img src="{{ url('site') }}/images/shop/shop-2.jpg" alt="store 2"
                                                class="card-img-top rounded-0">
                                        </a>
                                        <div class="image-content position-absolute d-flex align-items-center">
                                            <div class="content-left">
                                                <div class="badge badge-primary">Best Rate</div>
                                            </div>
                                            <div class="content-right ml-auto d-flex show-link">
                                                <a href="{{ url('site') }}/images/shop/full-shop-2.jpg"
                                                    data-gtf-mfp="true" class="item viewing" data-toggle="tooltip"
                                                    data-placement="top" title="Quick view">
                                                    <svg class="icon icon-expand">
                                                        <use xlink:href="{{ url('site') }}/#icon-expand"></use>
                                                    </svg>
                                                </a>
                                                <a href="{{ url('site') }}/#" class="item marking"
                                                    data-toggle="tooltip" data-placement="top" title="Bookmark"><i
                                                        class="fal fa-bookmark"></i></a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-body px-0 pb-0 pt-3">
                                        <a href="{{ url('site') }}/listing-details-full-image.html"
                                            class="card-title h5 text-dark d-inline-block mb-2"><span
                                                class="letter-spacing-25">Karly Gomez Cake</span>
                                            <span class="check">
                                                <svg class="icon icon-check-circle">
                                                    <use xlink:href="{{ url('site') }}/#icon-check-circle"></use>
                                                </svg>
                                            </span>
                                        </a>
                                        <ul
                                            class="list-inline store-meta mb-4 font-size-sm d-flex align-items-center flex-wrap">
                                            <li class="list-inline-item"><span
                                                    class="badge badge-success d-inline-block mr-1">5.0</span><span>8
                                                    rating</span>
                                            </li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><span class="mr-1">From</span><span
                                                    class="text-danger font-weight-semibold">$12.00</span></li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><a href="{{ url('site') }}/#"
                                                    class="link-hover-secondary-primary">
                                                    <svg class="icon icon-pizza">
                                                        <use xlink:href="{{ url('site') }}/#icon-pizza"></use>
                                                    </svg>
                                                    <span>Food</span>
                                                </a></li>
                                        </ul>

                                        <div class="media">
                                            <a href="{{ url('site') }}/#" class="d-inline-block mr-3"><img
                                                    src="{{ url('site') }}/images/listing/testimonial-2.png"
                                                    alt="testimonial" class="rounded-circle">
                                            </a>
                                            <div class="media-body lh-14 font-size-sm">They specialize in makgeolli
                                                at this
                                                Korean-style pub in Seorae Village. And they use...
                                            </div>
                                        </div>
                                    </div>
                                    <ul
                                        class="list-inline card-footer rounded-0 border-top pt-3 mt-5 bg-transparent px-0 store-meta d-flex align-items-center">
                                        <li class="list-inline-item">
                                            <span class="d-inline-block mr-1">
                                                <i class="fal fa-map-marker-alt">
                                                </i>
                                            </span>
                                            <a href="{{ url('site') }}/#"
                                                class="text-secondary text-decoration-none address">Florencia,
                                                Italy</a>
                                        </li>
                                        <li class="list-inline-item separate"></li>
                                        <li class="list-inline-item">
                                            <span class="text-danger">Close now!</span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="box" data-animate="fadeInUp">
                                <div class="store card border-0 rounded-0">
                                    <div class="position-relative store-image">
                                        <a href="{{ url('site') }}/listing-details-full-gallery.html">
                                            <img src="{{ url('site') }}/images/shop/shop-3.jpg" alt="store 1"
                                                class="card-img-top rounded-0">
                                        </a>
                                        <div class="image-content position-absolute d-flex align-items-center">
                                            <div class="content-left">
                                                <div class="badge badge-primary">Most view</div>
                                            </div>
                                            <div class="content-right ml-auto d-flex show-link">
                                                <a href="{{ url('site') }}/images/shop/full-shop-3.jpg"
                                                    class="item viewing" data-toggle="tooltip" data-placement="top"
                                                    title="Quick view" data-gtf-mfp="true">
                                                    <svg class="icon icon-expand">
                                                        <use xlink:href="{{ url('site') }}/#icon-expand"></use>
                                                    </svg>
                                                </a>
                                                <a href="{{ url('site') }}/#" class="item marking"
                                                    data-toggle="tooltip" data-placement="top" title="Bookmark"><i
                                                        class="fal fa-bookmark"></i></a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-body px-0 pb-0 pt-3">
                                        <a href="{{ url('site') }}/listing-details-full-gallery.html"
                                            class="card-title h5 text-dark d-inline-block mb-2"><span
                                                class="letter-spacing-25">Roman
                                                Kraft Hotel</span></a>
                                        <ul
                                            class="list-inline store-meta mb-4 font-size-sm d-flex align-items-center flex-wrap">
                                            <li class="list-inline-item"><span
                                                    class="badge badge-warning d-inline-block mr-1">4.3</span><span>4
                                                    rating</span>
                                            </li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><span class="mr-1">From</span><span
                                                    class="text-danger font-weight-semibold">$10.00</span></li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><a href="{{ url('site') }}/#"
                                                    class="link-hover-secondary-primary">
                                                    <svg class="icon icon-pizza">
                                                        <use xlink:href="{{ url('site') }}/#icon-pizza"></use>
                                                    </svg>
                                                    <span>Food</span>
                                                </a></li>
                                        </ul>
                                        <div class="media">
                                            <a href="{{ url('site') }}/#" class="d-inline-block mr-3"><img
                                                    src="{{ url('site') }}/images/listing/testimonial-5.png"
                                                    alt="testimonial" class="rounded-circle">
                                            </a>
                                            <div class="media-body lh-14 font-size-sm">After a yoga class changed
                                                her life, Maz
                                                became
                                                vegan, launched...
                                            </div>
                                        </div>
                                    </div>
                                    <ul
                                        class="list-inline card-footer rounded-0 border-top pt-3 mt-5 bg-transparent px-0 store-meta d-flex align-items-center">
                                        <li class="list-inline-item">
                                            <span class="d-inline-block mr-1"><i class="fal fa-map-marker-alt">
                                                </i>
                                            </span>
                                            <a href="{{ url('site') }}/#"
                                                class="text-secondary text-decoration-none address">Miami,
                                                FL</a>
                                        </li>
                                        <li class="list-inline-item separate"></li>
                                        <li class="list-inline-item">
                                            <span class="text-danger">Close now!</span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="box" data-animate="fadeInUp">
                                <div class="store card border-0 rounded-0">
                                    <div class="position-relative store-image">
                                        <a href="{{ url('site') }}/listing-details-full-gallery.html">
                                            <img src="{{ url('site') }}/images/shop/shop-4.jpg" alt="store 1"
                                                class="card-img-top rounded-0">
                                        </a>
                                        <div class="image-content position-absolute d-flex align-items-center">
                                            <div class="content-left">
                                                <div class="badge badge-primary">Featured</div>
                                            </div>
                                            <div class="content-right ml-auto d-flex show-link">
                                                <a href="{{ url('site') }}/images/shop/full-shop-4.jpg"
                                                    class="item viewing" data-toggle="tooltip" data-gtf-mfp="true"
                                                    data-placement="top" title="Quick view">
                                                    <svg class="icon icon-expand">
                                                        <use xlink:href="{{ url('site') }}/#icon-expand"></use>
                                                    </svg>
                                                </a>
                                                <a href="{{ url('site') }}/#" class="item marking"
                                                    data-toggle="tooltip" data-placement="top" title="Bookmark"><i
                                                        class="fal fa-bookmark"></i></a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-body px-0 pb-0 pt-3">
                                        <a href="{{ url('site') }}/listing-details-full-image.html"
                                            class="card-title h5 text-dark d-inline-block mb-2"><span
                                                class="letter-spacing-25">Red Wings Shoes Store</span></a>
                                        <ul
                                            class="list-inline store-meta mb-4 font-size-sm d-flex align-items-center flex-wrap">
                                            <li class="list-inline-item"><span
                                                    class="badge badge-success d-inline-block mr-1">5.0</span><span>6
                                                    rating</span>
                                            </li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><span class="mr-1">From</span><span
                                                    class="text-danger font-weight-semibold">$75.00</span></li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><a href="{{ url('site') }}/#"
                                                    class="link-hover-secondary-primary">
                                                    <svg class="icon icon-bag">
                                                        <use xlink:href="{{ url('site') }}/#icon-bag"></use>
                                                    </svg>
                                                    <span>Shopping</span>
                                                </a></li>
                                        </ul>
                                        <div class="media">
                                            <a href="{{ url('site') }}/#" class="d-inline-block mr-3"><img
                                                    src="{{ url('site') }}/images/listing/testimonial-3.png"
                                                    alt="testimonial" class="rounded-circle">
                                            </a>
                                            <div class="media-body lh-14 font-size-sm">Established in 1895, these
                                                style
                                                merchants have
                                                set the standard in Sydney suiting for generations...
                                            </div>
                                        </div>
                                    </div>
                                    <ul
                                        class="list-inline card-footer rounded-0 border-top pt-3 mt-5 bg-transparent px-0 store-meta d-flex align-items-center">
                                        <li class="list-inline-item">
                                            <span class="d-inline-block mr-1"><i class="fal fa-map-marker-alt">
                                                </i>
                                            </span>
                                            <a href="{{ url('site') }}/#"
                                                class="text-secondary text-decoration-none address">
                                                Paris, France</a>
                                        </li>
                                        <li class="list-inline-item separate"></li>
                                        <li class="list-inline-item">
                                            <span class="text-danger">Close now!</span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="box" data-animate="fadeInUp">
                                <div class="store card border-0 rounded-0">
                                    <div class="position-relative store-image">
                                        <a href="{{ url('site') }}/listing-details-full-gallery.html">
                                            <img src="{{ url('site') }}/images/shop/shop-5.jpg" alt="store 1"
                                                class="card-img-top rounded-0">
                                        </a>
                                        <div class="image-content position-absolute d-flex align-items-center">
                                            <div class="content-left">
                                                <div class="badge badge-primary">AD</div>
                                            </div>
                                            <div class="content-right ml-auto d-flex show-link">
                                                <a href="{{ url('site') }}/images/shop/full-shop-5.jpg"
                                                    class="item viewing" data-toggle="tooltip" data-placement="top"
                                                    data-gtf-mfp="true" title="Quick view">
                                                    <svg class="icon icon-expand">
                                                        <use xlink:href="{{ url('site') }}/#icon-expand"></use>
                                                    </svg>
                                                </a>
                                                <a href="{{ url('site') }}/#" class="item marking"
                                                    data-toggle="tooltip" data-placement="top" title="Bookmark"><i
                                                        class="fal fa-bookmark"></i></a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-body px-0 pb-0 pt-3">
                                        <a href="{{ url('site') }}/listing-details-full-image.html"
                                            class="card-title h5 text-dark d-inline-block mb-2"><span
                                                class="letter-spacing-25">Packing & Delivery Service</span>
                                            <span class="check">
                                                <svg class="icon icon-check-circle">
                                                    <use xlink:href="{{ url('site') }}/#icon-check-circle"></use>
                                                </svg>
                                            </span>
                                        </a>
                                        <ul
                                            class="list-inline store-meta mb-4 font-size-sm d-flex align-items-center flex-wrap">
                                            <li class="list-inline-item"><span
                                                    class="badge badge-warning d-inline-block mr-1">4.5</span><span>2
                                                    rating</span>
                                            </li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><span
                                                    class="text-danger font-weight-semibold">Get a quote</span>
                                            </li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><a href="{{ url('site') }}/#"
                                                    class="link-hover-secondary-primary">
                                                    <svg class="icon icon-cog">
                                                        <use xlink:href="{{ url('site') }}/#icon-cog"></use>
                                                    </svg>
                                                    <span>Service</span>
                                                </a></li>
                                        </ul>
                                        <div class="media">
                                            <a href="{{ url('site') }}/#" class="d-inline-block mr-3"><img
                                                    src="{{ url('site') }}/images/listing/testimonial-2.png"
                                                    alt="testimonial" class="rounded-circle">
                                            </a>
                                            <div class="media-body lh-14 font-size-sm">Most items can be packed
                                                securely in
                                                these
                                                boxes, which are available in several sizes...
                                            </div>
                                        </div>
                                    </div>
                                    <ul
                                        class="list-inline card-footer rounded-0 border-top pt-3 mt-5 bg-transparent px-0 store-meta d-flex align-items-center">
                                        <li class="list-inline-item">
                                            <span class="d-inline-block mr-1"><i class="fal fa-map-marker-alt">
                                                </i>
                                            </span>
                                            <a href="{{ url('site') }}/#"
                                                class="text-secondary text-decoration-none address">New
                                                York, USA</a>
                                        </li>
                                        <li class="list-inline-item separate"></li>
                                        <li class="list-inline-item">
                                            <span class="text-green">Open now!</span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="box" data-animate="fadeInUp">
                                <div class="store card border-0 rounded-0">
                                    <div class="position-relative store-image">
                                        <a href="{{ url('site') }}/listing-details-full-gallery.html">
                                            <img src="{{ url('site') }}/images/shop/shop-1.jpg" alt="store 1"
                                                class="card-img-top rounded-0">
                                        </a>
                                        <div class="image-content position-absolute d-flex align-items-center">
                                            <div class="content-left">
                                                <div class="badge badge-primary">Featured</div>
                                            </div>
                                            <div class="content-right ml-auto d-flex show-link">
                                                <a href="{{ url('site') }}/images/shop/full-shop-1.jpg"
                                                    class="item viewing" data-toggle="tooltip" data-placement="top"
                                                    title="Quickview" data-gtf-mfp="true">
                                                    <svg class="icon icon-expand">
                                                        <use xlink:href="{{ url('site') }}/#icon-expand"></use>
                                                    </svg>
                                                </a>
                                                <a href="{{ url('site') }}/#" class="item marking"
                                                    data-toggle="tooltip" data-placement="top" title="Bookmark"><i
                                                        class="fal fa-bookmark"></i></a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-body px-0 pb-0 pt-3">
                                        <a href="{{ url('site') }}/listing-details-full-gallery.html"
                                            class="card-title h5 text-dark d-inline-block mb-2"><span
                                                class="letter-spacing-25">Roman
                                                Kraft Hotel</span></a>
                                        <ul
                                            class="list-inline store-meta mb-4 font-size-sm d-flex align-items-center flex-wrap">
                                            <li class="list-inline-item"><span
                                                    class="badge badge-success d-inline-block mr-1">5.0</span><span>4
                                                    rating</span>
                                            </li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><span class="mr-1">From</span><span
                                                    class="text-danger font-weight-semibold">$9.00</span></li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><a href="{{ url('site') }}/#"
                                                    class="link-hover-secondary-primary">
                                                    <svg class="icon icon-pizza">
                                                        <use xlink:href="{{ url('site') }}/#icon-pizza"></use>
                                                    </svg>
                                                    <span>Food</span>
                                                </a></li>
                                        </ul>

                                        <div class="media">
                                            <a href="{{ url('site') }}/#" class="d-inline-block mr-3"><img
                                                    src="{{ url('site') }}/images/listing/testimonial-1.png"
                                                    alt="testimonial" class="rounded-circle">
                                            </a>
                                            <div class="media-body lh-14 font-size-sm">They specialize in makgeolli
                                                at this
                                                Korean-style
                                                pub in Seorae Village. And they use...
                                            </div>
                                        </div>
                                    </div>
                                    <ul
                                        class="list-inline card-footer rounded-0 border-top pt-3 mt-5 bg-transparent px-0 store-meta d-flex align-items-center">
                                        <li class="list-inline-item">
                                            <span class="d-inline-block mr-1"><i class="fal fa-map-marker-alt">
                                                </i>
                                            </span>
                                            <a href="{{ url('site') }}/#"
                                                class="text-secondary text-decoration-none address py-1">Ubud,
                                                Indonesia</a>
                                        </li>
                                        <li class="list-inline-item separate"></li>
                                        <li class="list-inline-item">
                                            <span class="text-danger">Close now!</span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="most-view" role="tabpanel" aria-labelledby="most-view">
                        <div class="slick-slider arrow-top full-slide custom-nav"
                            data-slick-options='{"slidesToShow": 5,"autoplay":false,"dots":false,"arrows":false,"responsive":[{"breakpoint": 2000,"settings": {"slidesToShow": 4}},{"breakpoint": 1500,"settings": {"slidesToShow": 3}},{"breakpoint": 1000,"settings": {"slidesToShow": 2}},{"breakpoint": 770,"settings": {"slidesToShow": 1}}]}'>
                            <div class="box" data-animate="fadeInUp">
                                <div class="store card border-0 rounded-0">
                                    <div class="position-relative store-image">
                                        <a href="{{ url('site') }}/listing-details-full-gallery.html">
                                            <img src="{{ url('site') }}/images/shop/shop-1.jpg" alt="store 1"
                                                class="card-img-top rounded-0">
                                        </a>
                                        <div class="image-content position-absolute d-flex align-items-center">
                                            <div class="content-left">
                                                <div class="badge badge-primary">Featured</div>
                                            </div>
                                            <div class="content-right ml-auto d-flex w-lg show-link">
                                                <a href="{{ url('site') }}/images/shop/full-shop-1.jpg"
                                                    class="item viewing" data-toggle="tooltip" data-placement="top"
                                                    title="Quickview" data-gtf-mfp="true">
                                                    <svg class="icon icon-expand">
                                                        <use xlink:href="{{ url('site') }}/#icon-expand"></use>
                                                    </svg>
                                                </a>
                                                <a href="{{ url('site') }}/#" class="item marking"
                                                    data-toggle="tooltip" data-placement="top" title="Bookmark"><i
                                                        class="fal fa-bookmark"></i></a>
                                                <a href="{{ url('site') }}/#" class="item" data-toggle="tooltip"
                                                    data-placement="top" title="Compare">
                                                    <svg class="icon icon-chart-bars">
                                                        <use xlink:href="{{ url('site') }}/#icon-chart-bars"></use>
                                                    </svg>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-body px-0 pb-0 pt-3">
                                        <a href="{{ url('site') }}/listing-details-full-gallery.html"
                                            class="card-title h5 text-dark d-inline-block mb-2"><span
                                                class="letter-spacing-25">Roman
                                                Kraft Hotel</span></a>
                                        <ul
                                            class="list-inline store-meta mb-4 font-size-sm d-flex align-items-center flex-wrap">
                                            <li class="list-inline-item"><span
                                                    class="badge badge-success d-inline-block mr-1">5.0</span><span>4
                                                    rating</span>
                                            </li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><span class="mr-1">From</span><span
                                                    class="text-danger font-weight-semibold">$56.00</span></li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item">
                                                <a href="{{ url('site') }}/#" class="link-hover-secondary-primary">
                                                    <svg class="icon icon-bed">
                                                        <use xlink:href="{{ url('site') }}/#icon-bed"></use>
                                                    </svg>
                                                    <span>Hotel</span>
                                                </a>
                                            </li>
                                        </ul>
                                        <div class="media">
                                            <a href="{{ url('site') }}/#" class="d-inline-block mr-3"><img
                                                    src="{{ url('site') }}/images/listing/testimonial-1.png"
                                                    alt="testimonial" class="rounded-circle">
                                            </a>
                                            <div class="media-body lh-14 font-size-sm">Overlooking Bloomsbury's
                                                Russell Square
                                                and
                                                a 2 minutes' walk from the tube station of the same name...
                                            </div>
                                        </div>
                                    </div>
                                    <ul
                                        class="list-inline card-footer rounded-0 border-top pt-3 mt-5 bg-transparent px-0 store-meta d-flex align-items-center">
                                        <li class="list-inline-item">
                                            <span class="d-inline-block mr-1">
                                                <i class="fal fa-map-marker-alt">
                                                </i>
                                            </span>
                                            <a href="{{ url('site') }}/#"
                                                class="text-secondary text-decoration-none link-hover-secondary-blue">
                                                San Francisco, CA</a>
                                        </li>
                                        <li class="list-inline-item separate"></li>
                                        <li class="list-inline-item">
                                            <span class="text-green">Open now!</span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="box" data-animate="fadeInUp">
                                <div class="store card border-0 rounded-0">
                                    <div class="position-relative store-image">
                                        <a href="{{ url('site') }}/listing-details-full-gallery.html">
                                            <img src="{{ url('site') }}/images/shop/shop-2.jpg" alt="store 2"
                                                class="card-img-top rounded-0">
                                        </a>
                                        <div class="image-content position-absolute d-flex align-items-center">
                                            <div class="content-left">
                                                <div class="badge badge-primary">Best Rate</div>
                                            </div>
                                            <div class="content-right ml-auto d-flex show-link">
                                                <a href="{{ url('site') }}/images/shop/full-shop-2.jpg"
                                                    data-gtf-mfp="true" class="item viewing" data-toggle="tooltip"
                                                    data-placement="top" title="Quick view">
                                                    <svg class="icon icon-expand">
                                                        <use xlink:href="{{ url('site') }}/#icon-expand"></use>
                                                    </svg>
                                                </a>
                                                <a href="{{ url('site') }}/#" class="item marking"
                                                    data-toggle="tooltip" data-placement="top" title="Bookmark"><i
                                                        class="fal fa-bookmark"></i></a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-body px-0 pb-0 pt-3">
                                        <a href="{{ url('site') }}/listing-details-full-image.html"
                                            class="card-title h5 text-dark d-inline-block mb-2"><span
                                                class="letter-spacing-25">Karly Gomez Cake</span>
                                            <span class="check">
                                                <svg class="icon icon-check-circle">
                                                    <use xlink:href="{{ url('site') }}/#icon-check-circle"></use>
                                                </svg>
                                            </span>
                                        </a>
                                        <ul
                                            class="list-inline store-meta mb-4 font-size-sm d-flex align-items-center flex-wrap">
                                            <li class="list-inline-item"><span
                                                    class="badge badge-success d-inline-block mr-1">5.0</span><span>8
                                                    rating</span>
                                            </li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><span class="mr-1">From</span><span
                                                    class="text-danger font-weight-semibold">$12.00</span></li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><a href="{{ url('site') }}/#"
                                                    class="link-hover-secondary-primary">
                                                    <svg class="icon icon-pizza">
                                                        <use xlink:href="{{ url('site') }}/#icon-pizza"></use>
                                                    </svg>
                                                    <span>Food</span>
                                                </a></li>
                                        </ul>

                                        <div class="media">
                                            <a href="{{ url('site') }}/#" class="d-inline-block mr-3"><img
                                                    src="{{ url('site') }}/images/listing/testimonial-2.png"
                                                    alt="testimonial" class="rounded-circle">
                                            </a>
                                            <div class="media-body lh-14 font-size-sm">They specialize in makgeolli
                                                at this
                                                Korean-style pub in Seorae Village. And they use...
                                            </div>
                                        </div>
                                    </div>
                                    <ul
                                        class="list-inline card-footer rounded-0 border-top pt-3 mt-5 bg-transparent px-0 store-meta d-flex align-items-center">
                                        <li class="list-inline-item">
                                            <span class="d-inline-block mr-1">
                                                <i class="fal fa-map-marker-alt">
                                                </i>
                                            </span>
                                            <a href="{{ url('site') }}/#"
                                                class="text-secondary text-decoration-none address">Florencia,
                                                Italy</a>
                                        </li>
                                        <li class="list-inline-item separate"></li>
                                        <li class="list-inline-item">
                                            <span class="text-danger">Close now!</span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="box" data-animate="fadeInUp">
                                <div class="store card border-0 rounded-0">
                                    <div class="position-relative store-image">
                                        <a href="{{ url('site') }}/listing-details-full-gallery.html">
                                            <img src="{{ url('site') }}/images/shop/shop-3.jpg" alt="store 1"
                                                class="card-img-top rounded-0">
                                        </a>
                                        <div class="image-content position-absolute d-flex align-items-center">
                                            <div class="content-left">
                                                <div class="badge badge-primary">Most view</div>
                                            </div>
                                            <div class="content-right ml-auto d-flex show-link">
                                                <a href="{{ url('site') }}/images/shop/full-shop-3.jpg"
                                                    class="item viewing" data-toggle="tooltip" data-placement="top"
                                                    title="Quick view" data-gtf-mfp="true">
                                                    <svg class="icon icon-expand">
                                                        <use xlink:href="{{ url('site') }}/#icon-expand"></use>
                                                    </svg>
                                                </a>
                                                <a href="{{ url('site') }}/#" class="item marking"
                                                    data-toggle="tooltip" data-placement="top" title="Bookmark"><i
                                                        class="fal fa-bookmark"></i></a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-body px-0 pb-0 pt-3">
                                        <a href="{{ url('site') }}/listing-details-full-gallery.html"
                                            class="card-title h5 text-dark d-inline-block mb-2"><span
                                                class="letter-spacing-25">Roman
                                                Kraft Hotel</span></a>
                                        <ul
                                            class="list-inline store-meta mb-4 font-size-sm d-flex align-items-center flex-wrap">
                                            <li class="list-inline-item"><span
                                                    class="badge badge-warning d-inline-block mr-1">4.3</span><span>4
                                                    rating</span>
                                            </li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><span class="mr-1">From</span><span
                                                    class="text-danger font-weight-semibold">$10.00</span></li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><a href="{{ url('site') }}/#"
                                                    class="link-hover-secondary-primary">
                                                    <svg class="icon icon-pizza">
                                                        <use xlink:href="{{ url('site') }}/#icon-pizza"></use>
                                                    </svg>
                                                    <span>Food</span>
                                                </a></li>
                                        </ul>
                                        <div class="media">
                                            <a href="{{ url('site') }}/#" class="d-inline-block mr-3"><img
                                                    src="{{ url('site') }}/images/listing/testimonial-5.png"
                                                    alt="testimonial" class="rounded-circle">
                                            </a>
                                            <div class="media-body lh-14 font-size-sm">After a yoga class changed
                                                her life, Maz
                                                became
                                                vegan, launched...
                                            </div>
                                        </div>
                                    </div>
                                    <ul
                                        class="list-inline card-footer rounded-0 border-top pt-3 mt-5 bg-transparent px-0 store-meta d-flex align-items-center">
                                        <li class="list-inline-item">
                                            <span class="d-inline-block mr-1"><i class="fal fa-map-marker-alt">
                                                </i>
                                            </span>
                                            <a href="{{ url('site') }}/#"
                                                class="text-secondary text-decoration-none address">Miami,
                                                FL</a>
                                        </li>
                                        <li class="list-inline-item separate"></li>
                                        <li class="list-inline-item">
                                            <span class="text-danger">Close now!</span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="box" data-animate="fadeInUp">
                                <div class="store card border-0 rounded-0">
                                    <div class="position-relative store-image">
                                        <a href="{{ url('site') }}/listing-details-full-gallery.html">
                                            <img src="{{ url('site') }}/images/shop/shop-4.jpg" alt="store 1"
                                                class="card-img-top rounded-0">
                                        </a>
                                        <div class="image-content position-absolute d-flex align-items-center">
                                            <div class="content-left">
                                                <div class="badge badge-primary">Featured</div>
                                            </div>
                                            <div class="content-right ml-auto d-flex show-link">
                                                <a href="{{ url('site') }}/images/shop/full-shop-4.jpg"
                                                    class="item viewing" data-toggle="tooltip" data-gtf-mfp="true"
                                                    data-placement="top" title="Quick view">
                                                    <svg class="icon icon-expand">
                                                        <use xlink:href="{{ url('site') }}/#icon-expand"></use>
                                                    </svg>
                                                </a>
                                                <a href="{{ url('site') }}/#" class="item marking"
                                                    data-toggle="tooltip" data-placement="top" title="Bookmark"><i
                                                        class="fal fa-bookmark"></i></a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-body px-0 pb-0 pt-3">
                                        <a href="{{ url('site') }}/listing-details-full-image.html"
                                            class="card-title h5 text-dark d-inline-block mb-2"><span
                                                class="letter-spacing-25">Red Wings Shoes Store</span></a>
                                        <ul
                                            class="list-inline store-meta mb-4 font-size-sm d-flex align-items-center flex-wrap">
                                            <li class="list-inline-item"><span
                                                    class="badge badge-success d-inline-block mr-1">5.0</span><span>6
                                                    rating</span>
                                            </li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><span class="mr-1">From</span><span
                                                    class="text-danger font-weight-semibold">$75.00</span></li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><a href="{{ url('site') }}/#"
                                                    class="link-hover-secondary-primary">
                                                    <svg class="icon icon-bag">
                                                        <use xlink:href="{{ url('site') }}/#icon-bag"></use>
                                                    </svg>
                                                    <span>Shopping</span>
                                                </a></li>
                                        </ul>
                                        <div class="media">
                                            <a href="{{ url('site') }}/#" class="d-inline-block mr-3"><img
                                                    src="{{ url('site') }}/images/listing/testimonial-3.png"
                                                    alt="testimonial" class="rounded-circle">
                                            </a>
                                            <div class="media-body lh-14 font-size-sm">Established in 1895, these
                                                style
                                                merchants have
                                                set the standard in Sydney suiting for generations...
                                            </div>
                                        </div>
                                    </div>
                                    <ul
                                        class="list-inline card-footer rounded-0 border-top pt-3 mt-5 bg-transparent px-0 store-meta d-flex align-items-center">
                                        <li class="list-inline-item">
                                            <span class="d-inline-block mr-1"><i class="fal fa-map-marker-alt">
                                                </i>
                                            </span>
                                            <a href="{{ url('site') }}/#"
                                                class="text-secondary text-decoration-none address">
                                                Paris, France</a>
                                        </li>
                                        <li class="list-inline-item separate"></li>
                                        <li class="list-inline-item">
                                            <span class="text-danger">Close now!</span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="box" data-animate="fadeInUp">
                                <div class="store card border-0 rounded-0">
                                    <div class="position-relative store-image">
                                        <a href="{{ url('site') }}/listing-details-full-gallery.html">
                                            <img src="{{ url('site') }}/images/shop/shop-5.jpg" alt="store 1"
                                                class="card-img-top rounded-0">
                                        </a>
                                        <div class="image-content position-absolute d-flex align-items-center">
                                            <div class="content-left">
                                                <div class="badge badge-primary">AD</div>
                                            </div>
                                            <div class="content-right ml-auto d-flex show-link">
                                                <a href="{{ url('site') }}/images/shop/full-shop-5.jpg"
                                                    class="item viewing" data-toggle="tooltip" data-placement="top"
                                                    data-gtf-mfp="true" title="Quick view">
                                                    <svg class="icon icon-expand">
                                                        <use xlink:href="{{ url('site') }}/#icon-expand"></use>
                                                    </svg>
                                                </a>
                                                <a href="{{ url('site') }}/#" class="item marking"
                                                    data-toggle="tooltip" data-placement="top" title="Bookmark"><i
                                                        class="fal fa-bookmark"></i></a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-body px-0 pb-0 pt-3">
                                        <a href="{{ url('site') }}/listing-details-full-image.html"
                                            class="card-title h5 text-dark d-inline-block mb-2"><span
                                                class="letter-spacing-25">Packing & Delivery Service</span>
                                            <span class="check">
                                                <svg class="icon icon-check-circle">
                                                    <use xlink:href="{{ url('site') }}/#icon-check-circle"></use>
                                                </svg>
                                            </span>
                                        </a>
                                        <ul
                                            class="list-inline store-meta mb-4 font-size-sm d-flex align-items-center flex-wrap">
                                            <li class="list-inline-item"><span
                                                    class="badge badge-warning d-inline-block mr-1">4.5</span><span>2
                                                    rating</span>
                                            </li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><span
                                                    class="text-danger font-weight-semibold">Get a quote</span>
                                            </li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><a href="{{ url('site') }}/#"
                                                    class="link-hover-secondary-primary">
                                                    <svg class="icon icon-cog">
                                                        <use xlink:href="{{ url('site') }}/#icon-cog"></use>
                                                    </svg>
                                                    <span>Service</span>
                                                </a></li>
                                        </ul>
                                        <div class="media">
                                            <a href="{{ url('site') }}/#" class="d-inline-block mr-3"><img
                                                    src="{{ url('site') }}/images/listing/testimonial-2.png"
                                                    alt="testimonial" class="rounded-circle">
                                            </a>
                                            <div class="media-body lh-14 font-size-sm">Most items can be packed
                                                securely in
                                                these
                                                boxes, which are available in several sizes...
                                            </div>
                                        </div>
                                    </div>
                                    <ul
                                        class="list-inline card-footer rounded-0 border-top pt-3 mt-5 bg-transparent px-0 store-meta d-flex align-items-center">
                                        <li class="list-inline-item">
                                            <span class="d-inline-block mr-1"><i class="fal fa-map-marker-alt">
                                                </i>
                                            </span>
                                            <a href="{{ url('site') }}/#"
                                                class="text-secondary text-decoration-none address">New
                                                York, USA</a>
                                        </li>
                                        <li class="list-inline-item separate"></li>
                                        <li class="list-inline-item">
                                            <span class="text-green">Open now!</span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="box" data-animate="fadeInUp">
                                <div class="store card border-0 rounded-0">
                                    <div class="position-relative store-image">
                                        <a href="{{ url('site') }}/listing-details-full-gallery.html">
                                            <img src="{{ url('site') }}/images/shop/shop-1.jpg" alt="store 1"
                                                class="card-img-top rounded-0">
                                        </a>
                                        <div class="image-content position-absolute d-flex align-items-center">
                                            <div class="content-left">
                                                <div class="badge badge-primary">Featured</div>
                                            </div>
                                            <div class="content-right ml-auto d-flex show-link">
                                                <a href="{{ url('site') }}/images/shop/full-shop-1.jpg"
                                                    class="item viewing" data-toggle="tooltip" data-placement="top"
                                                    title="Quickview" data-gtf-mfp="true">
                                                    <svg class="icon icon-expand">
                                                        <use xlink:href="{{ url('site') }}/#icon-expand"></use>
                                                    </svg>
                                                </a>
                                                <a href="{{ url('site') }}/#" class="item marking"
                                                    data-toggle="tooltip" data-placement="top" title="Bookmark"><i
                                                        class="fal fa-bookmark"></i></a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-body px-0 pb-0 pt-3">
                                        <a href="{{ url('site') }}/listing-details-full-gallery.html"
                                            class="card-title h5 text-dark d-inline-block mb-2"><span
                                                class="letter-spacing-25">Roman
                                                Kraft Hotel</span></a>
                                        <ul
                                            class="list-inline store-meta mb-4 font-size-sm d-flex align-items-center flex-wrap">
                                            <li class="list-inline-item"><span
                                                    class="badge badge-success d-inline-block mr-1">5.0</span><span>4
                                                    rating</span>
                                            </li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><span class="mr-1">From</span><span
                                                    class="text-danger font-weight-semibold">$9.00</span></li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><a href="{{ url('site') }}/#"
                                                    class="link-hover-secondary-primary">
                                                    <svg class="icon icon-pizza">
                                                        <use xlink:href="{{ url('site') }}/#icon-pizza"></use>
                                                    </svg>
                                                    <span>Food</span>
                                                </a></li>
                                        </ul>

                                        <div class="media">
                                            <a href="{{ url('site') }}/#" class="d-inline-block mr-3"><img
                                                    src="{{ url('site') }}/images/listing/testimonial-1.png"
                                                    alt="testimonial" class="rounded-circle">
                                            </a>
                                            <div class="media-body lh-14 font-size-sm">They specialize in makgeolli
                                                at this
                                                Korean-style
                                                pub in Seorae Village. And they use...
                                            </div>
                                        </div>
                                    </div>
                                    <ul
                                        class="list-inline card-footer rounded-0 border-top pt-3 mt-5 bg-transparent px-0 store-meta d-flex align-items-center">
                                        <li class="list-inline-item">
                                            <span class="d-inline-block mr-1"><i class="fal fa-map-marker-alt">
                                                </i>
                                            </span>
                                            <a href="{{ url('site') }}/#"
                                                class="text-secondary text-decoration-none address py-1">Ubud,
                                                Indonesia</a>
                                        </li>
                                        <li class="list-inline-item separate"></li>
                                        <li class="list-inline-item">
                                            <span class="text-danger">Close now!</span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="popular" role="tabpanel" aria-labelledby="popular">
                        <div class="slick-slider arrow-top full-slide custom-nav"
                            data-slick-options='{"slidesToShow": 5,"autoplay":false,"dots":false,"arrows":false,"responsive":[{"breakpoint": 2000,"settings": {"slidesToShow": 4}},{"breakpoint": 1500,"settings": {"slidesToShow": 3}},{"breakpoint": 1000,"settings": {"slidesToShow": 2}},{"breakpoint": 770,"settings": {"slidesToShow": 1}}]}'>
                            <div class="box" data-animate="fadeInUp">
                                <div class="store card border-0 rounded-0">
                                    <div class="position-relative store-image">
                                        <a href="{{ url('site') }}/listing-details-full-gallery.html">
                                            <img src="{{ url('site') }}/images/shop/shop-1.jpg" alt="store 1"
                                                class="card-img-top rounded-0">
                                        </a>
                                        <div class="image-content position-absolute d-flex align-items-center">
                                            <div class="content-left">
                                                <div class="badge badge-primary">Featured</div>
                                            </div>
                                            <div class="content-right ml-auto d-flex w-lg show-link">
                                                <a href="{{ url('site') }}/images/shop/full-shop-1.jpg"
                                                    class="item viewing" data-toggle="tooltip" data-placement="top"
                                                    title="Quickview" data-gtf-mfp="true">
                                                    <svg class="icon icon-expand">
                                                        <use xlink:href="{{ url('site') }}/#icon-expand"></use>
                                                    </svg>
                                                </a>
                                                <a href="{{ url('site') }}/#" class="item marking"
                                                    data-toggle="tooltip" data-placement="top" title="Bookmark"><i
                                                        class="fal fa-bookmark"></i></a>
                                                <a href="{{ url('site') }}/#" class="item" data-toggle="tooltip"
                                                    data-placement="top" title="Compare">
                                                    <svg class="icon icon-chart-bars">
                                                        <use xlink:href="{{ url('site') }}/#icon-chart-bars"></use>
                                                    </svg>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-body px-0 pb-0 pt-3">
                                        <a href="{{ url('site') }}/listing-details-full-gallery.html"
                                            class="card-title h5 text-dark d-inline-block mb-2"><span
                                                class="letter-spacing-25">Roman
                                                Kraft Hotel</span></a>
                                        <ul
                                            class="list-inline store-meta mb-4 font-size-sm d-flex align-items-center flex-wrap">
                                            <li class="list-inline-item"><span
                                                    class="badge badge-success d-inline-block mr-1">5.0</span><span>4
                                                    rating</span>
                                            </li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><span class="mr-1">From</span><span
                                                    class="text-danger font-weight-semibold">$56.00</span></li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item">
                                                <a href="{{ url('site') }}/#" class="link-hover-secondary-primary">
                                                    <svg class="icon icon-bed">
                                                        <use xlink:href="{{ url('site') }}/#icon-bed"></use>
                                                    </svg>
                                                    <span>Hotel</span>
                                                </a>
                                            </li>
                                        </ul>
                                        <div class="media">
                                            <a href="{{ url('site') }}/#" class="d-inline-block mr-3"><img
                                                    src="{{ url('site') }}/images/listing/testimonial-1.png"
                                                    alt="testimonial" class="rounded-circle">
                                            </a>
                                            <div class="media-body lh-14 font-size-sm">Overlooking Bloomsbury's
                                                Russell Square
                                                and
                                                a 2 minutes' walk from the tube station of the same name...
                                            </div>
                                        </div>
                                    </div>
                                    <ul
                                        class="list-inline card-footer rounded-0 border-top pt-3 mt-5 bg-transparent px-0 store-meta d-flex align-items-center">
                                        <li class="list-inline-item">
                                            <span class="d-inline-block mr-1">
                                                <i class="fal fa-map-marker-alt">
                                                </i>
                                            </span>
                                            <a href="{{ url('site') }}/#"
                                                class="text-secondary text-decoration-none link-hover-secondary-blue">
                                                San Francisco, CA</a>
                                        </li>
                                        <li class="list-inline-item separate"></li>
                                        <li class="list-inline-item">
                                            <span class="text-green">Open now!</span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="box" data-animate="fadeInUp">
                                <div class="store card border-0 rounded-0">
                                    <div class="position-relative store-image">
                                        <a href="{{ url('site') }}/listing-details-full-gallery.html">
                                            <img src="{{ url('site') }}/images/shop/shop-2.jpg" alt="store 2"
                                                class="card-img-top rounded-0">
                                        </a>
                                        <div class="image-content position-absolute d-flex align-items-center">
                                            <div class="content-left">
                                                <div class="badge badge-primary">Best Rate</div>
                                            </div>
                                            <div class="content-right ml-auto d-flex show-link">
                                                <a href="{{ url('site') }}/images/shop/full-shop-2.jpg"
                                                    data-gtf-mfp="true" class="item viewing" data-toggle="tooltip"
                                                    data-placement="top" title="Quick view">
                                                    <svg class="icon icon-expand">
                                                        <use xlink:href="{{ url('site') }}/#icon-expand"></use>
                                                    </svg>
                                                </a>
                                                <a href="{{ url('site') }}/#" class="item marking"
                                                    data-toggle="tooltip" data-placement="top" title="Bookmark"><i
                                                        class="fal fa-bookmark"></i></a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-body px-0 pb-0 pt-3">
                                        <a href="{{ url('site') }}/listing-details-full-image.html"
                                            class="card-title h5 text-dark d-inline-block mb-2"><span
                                                class="letter-spacing-25">Karly Gomez Cake</span>
                                            <span class="check">
                                                <svg class="icon icon-check-circle">
                                                    <use xlink:href="{{ url('site') }}/#icon-check-circle"></use>
                                                </svg>
                                            </span>
                                        </a>
                                        <ul
                                            class="list-inline store-meta mb-4 font-size-sm d-flex align-items-center flex-wrap">
                                            <li class="list-inline-item"><span
                                                    class="badge badge-success d-inline-block mr-1">5.0</span><span>8
                                                    rating</span>
                                            </li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><span class="mr-1">From</span><span
                                                    class="text-danger font-weight-semibold">$12.00</span></li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><a href="{{ url('site') }}/#"
                                                    class="link-hover-secondary-primary">
                                                    <svg class="icon icon-pizza">
                                                        <use xlink:href="{{ url('site') }}/#icon-pizza"></use>
                                                    </svg>
                                                    <span>Food</span>
                                                </a></li>
                                        </ul>

                                        <div class="media">
                                            <a href="{{ url('site') }}/#" class="d-inline-block mr-3"><img
                                                    src="{{ url('site') }}/images/listing/testimonial-2.png"
                                                    alt="testimonial" class="rounded-circle">
                                            </a>
                                            <div class="media-body lh-14 font-size-sm">They specialize in makgeolli
                                                at this
                                                Korean-style pub in Seorae Village. And they use...
                                            </div>
                                        </div>
                                    </div>
                                    <ul
                                        class="list-inline card-footer rounded-0 border-top pt-3 mt-5 bg-transparent px-0 store-meta d-flex align-items-center">
                                        <li class="list-inline-item">
                                            <span class="d-inline-block mr-1">
                                                <i class="fal fa-map-marker-alt">
                                                </i>
                                            </span>
                                            <a href="{{ url('site') }}/#"
                                                class="text-secondary text-decoration-none address">Florencia,
                                                Italy</a>
                                        </li>
                                        <li class="list-inline-item separate"></li>
                                        <li class="list-inline-item">
                                            <span class="text-danger">Close now!</span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="box" data-animate="fadeInUp">
                                <div class="store card border-0 rounded-0">
                                    <div class="position-relative store-image">
                                        <a href="{{ url('site') }}/listing-details-full-gallery.html">
                                            <img src="{{ url('site') }}/images/shop/shop-3.jpg" alt="store 1"
                                                class="card-img-top rounded-0">
                                        </a>
                                        <div class="image-content position-absolute d-flex align-items-center">
                                            <div class="content-left">
                                                <div class="badge badge-primary">Most view</div>
                                            </div>
                                            <div class="content-right ml-auto d-flex show-link">
                                                <a href="{{ url('site') }}/images/shop/full-shop-3.jpg"
                                                    class="item viewing" data-toggle="tooltip" data-placement="top"
                                                    title="Quick view" data-gtf-mfp="true">
                                                    <svg class="icon icon-expand">
                                                        <use xlink:href="{{ url('site') }}/#icon-expand"></use>
                                                    </svg>
                                                </a>
                                                <a href="{{ url('site') }}/#" class="item marking"
                                                    data-toggle="tooltip" data-placement="top" title="Bookmark"><i
                                                        class="fal fa-bookmark"></i></a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-body px-0 pb-0 pt-3">
                                        <a href="{{ url('site') }}/listing-details-full-gallery.html"
                                            class="card-title h5 text-dark d-inline-block mb-2"><span
                                                class="letter-spacing-25">Roman
                                                Kraft Hotel</span></a>
                                        <ul
                                            class="list-inline store-meta mb-4 font-size-sm d-flex align-items-center flex-wrap">
                                            <li class="list-inline-item"><span
                                                    class="badge badge-warning d-inline-block mr-1">4.3</span><span>4
                                                    rating</span>
                                            </li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><span class="mr-1">From</span><span
                                                    class="text-danger font-weight-semibold">$10.00</span></li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><a href="{{ url('site') }}/#"
                                                    class="link-hover-secondary-primary">
                                                    <svg class="icon icon-pizza">
                                                        <use xlink:href="{{ url('site') }}/#icon-pizza"></use>
                                                    </svg>
                                                    <span>Food</span>
                                                </a></li>
                                        </ul>
                                        <div class="media">
                                            <a href="{{ url('site') }}/#" class="d-inline-block mr-3"><img
                                                    src="{{ url('site') }}/images/listing/testimonial-5.png"
                                                    alt="testimonial" class="rounded-circle">
                                            </a>
                                            <div class="media-body lh-14 font-size-sm">After a yoga class changed
                                                her life, Maz
                                                became
                                                vegan, launched...
                                            </div>
                                        </div>
                                    </div>
                                    <ul
                                        class="list-inline card-footer rounded-0 border-top pt-3 mt-5 bg-transparent px-0 store-meta d-flex align-items-center">
                                        <li class="list-inline-item">
                                            <span class="d-inline-block mr-1"><i class="fal fa-map-marker-alt">
                                                </i>
                                            </span>
                                            <a href="{{ url('site') }}/#"
                                                class="text-secondary text-decoration-none address">Miami,
                                                FL</a>
                                        </li>
                                        <li class="list-inline-item separate"></li>
                                        <li class="list-inline-item">
                                            <span class="text-danger">Close now!</span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="box" data-animate="fadeInUp">
                                <div class="store card border-0 rounded-0">
                                    <div class="position-relative store-image">
                                        <a href="{{ url('site') }}/listing-details-full-gallery.html">
                                            <img src="{{ url('site') }}/images/shop/shop-4.jpg" alt="store 1"
                                                class="card-img-top rounded-0">
                                        </a>
                                        <div class="image-content position-absolute d-flex align-items-center">
                                            <div class="content-left">
                                                <div class="badge badge-primary">Featured</div>
                                            </div>
                                            <div class="content-right ml-auto d-flex show-link">
                                                <a href="{{ url('site') }}/images/shop/full-shop-4.jpg"
                                                    class="item viewing" data-toggle="tooltip" data-gtf-mfp="true"
                                                    data-placement="top" title="Quick view">
                                                    <svg class="icon icon-expand">
                                                        <use xlink:href="{{ url('site') }}/#icon-expand"></use>
                                                    </svg>
                                                </a>
                                                <a href="{{ url('site') }}/#" class="item marking"
                                                    data-toggle="tooltip" data-placement="top" title="Bookmark"><i
                                                        class="fal fa-bookmark"></i></a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-body px-0 pb-0 pt-3">
                                        <a href="{{ url('site') }}/listing-details-full-image.html"
                                            class="card-title h5 text-dark d-inline-block mb-2"><span
                                                class="letter-spacing-25">Red Wings Shoes Store</span></a>
                                        <ul
                                            class="list-inline store-meta mb-4 font-size-sm d-flex align-items-center flex-wrap">
                                            <li class="list-inline-item"><span
                                                    class="badge badge-success d-inline-block mr-1">5.0</span><span>6
                                                    rating</span>
                                            </li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><span class="mr-1">From</span><span
                                                    class="text-danger font-weight-semibold">$75.00</span></li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><a href="{{ url('site') }}/#"
                                                    class="link-hover-secondary-primary">
                                                    <svg class="icon icon-bag">
                                                        <use xlink:href="{{ url('site') }}/#icon-bag"></use>
                                                    </svg>
                                                    <span>Shopping</span>
                                                </a></li>
                                        </ul>
                                        <div class="media">
                                            <a href="{{ url('site') }}/#" class="d-inline-block mr-3"><img
                                                    src="{{ url('site') }}/images/listing/testimonial-3.png"
                                                    alt="testimonial" class="rounded-circle">
                                            </a>
                                            <div class="media-body lh-14 font-size-sm">Established in 1895, these
                                                style
                                                merchants have
                                                set the standard in Sydney suiting for generations...
                                            </div>
                                        </div>
                                    </div>
                                    <ul
                                        class="list-inline card-footer rounded-0 border-top pt-3 mt-5 bg-transparent px-0 store-meta d-flex align-items-center">
                                        <li class="list-inline-item">
                                            <span class="d-inline-block mr-1"><i class="fal fa-map-marker-alt">
                                                </i>
                                            </span>
                                            <a href="{{ url('site') }}/#"
                                                class="text-secondary text-decoration-none address">
                                                Paris, France</a>
                                        </li>
                                        <li class="list-inline-item separate"></li>
                                        <li class="list-inline-item">
                                            <span class="text-danger">Close now!</span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="box" data-animate="fadeInUp">
                                <div class="store card border-0 rounded-0">
                                    <div class="position-relative store-image">
                                        <a href="{{ url('site') }}/listing-details-full-gallery.html">
                                            <img src="{{ url('site') }}/images/shop/shop-5.jpg" alt="store 1"
                                                class="card-img-top rounded-0">
                                        </a>
                                        <div class="image-content position-absolute d-flex align-items-center">
                                            <div class="content-left">
                                                <div class="badge badge-primary">AD</div>
                                            </div>
                                            <div class="content-right ml-auto d-flex show-link">
                                                <a href="{{ url('site') }}/images/shop/full-shop-5.jpg"
                                                    class="item viewing" data-toggle="tooltip" data-placement="top"
                                                    data-gtf-mfp="true" title="Quick view">
                                                    <svg class="icon icon-expand">
                                                        <use xlink:href="{{ url('site') }}/#icon-expand"></use>
                                                    </svg>
                                                </a>
                                                <a href="{{ url('site') }}/#" class="item marking"
                                                    data-toggle="tooltip" data-placement="top" title="Bookmark"><i
                                                        class="fal fa-bookmark"></i></a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-body px-0 pb-0 pt-3">
                                        <a href="{{ url('site') }}/listing-details-full-image.html"
                                            class="card-title h5 text-dark d-inline-block mb-2"><span
                                                class="letter-spacing-25">Packing & Delivery Service</span>
                                            <span class="check">
                                                <svg class="icon icon-check-circle">
                                                    <use xlink:href="{{ url('site') }}/#icon-check-circle"></use>
                                                </svg>
                                            </span>
                                        </a>
                                        <ul
                                            class="list-inline store-meta mb-4 font-size-sm d-flex align-items-center flex-wrap">
                                            <li class="list-inline-item"><span
                                                    class="badge badge-warning d-inline-block mr-1">4.5</span><span>2
                                                    rating</span>
                                            </li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><span
                                                    class="text-danger font-weight-semibold">Get a quote</span>
                                            </li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><a href="{{ url('site') }}/#"
                                                    class="link-hover-secondary-primary">
                                                    <svg class="icon icon-cog">
                                                        <use xlink:href="{{ url('site') }}/#icon-cog"></use>
                                                    </svg>
                                                    <span>Service</span>
                                                </a></li>
                                        </ul>
                                        <div class="media">
                                            <a href="{{ url('site') }}/#" class="d-inline-block mr-3"><img
                                                    src="{{ url('site') }}/images/listing/testimonial-2.png"
                                                    alt="testimonial" class="rounded-circle">
                                            </a>
                                            <div class="media-body lh-14 font-size-sm">Most items can be packed
                                                securely in
                                                these
                                                boxes, which are available in several sizes...
                                            </div>
                                        </div>
                                    </div>
                                    <ul
                                        class="list-inline card-footer rounded-0 border-top pt-3 mt-5 bg-transparent px-0 store-meta d-flex align-items-center">
                                        <li class="list-inline-item">
                                            <span class="d-inline-block mr-1"><i class="fal fa-map-marker-alt">
                                                </i>
                                            </span>
                                            <a href="{{ url('site') }}/#"
                                                class="text-secondary text-decoration-none address">New
                                                York, USA</a>
                                        </li>
                                        <li class="list-inline-item separate"></li>
                                        <li class="list-inline-item">
                                            <span class="text-green">Open now!</span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="box" data-animate="fadeInUp">
                                <div class="store card border-0 rounded-0">
                                    <div class="position-relative store-image">
                                        <a href="{{ url('site') }}/listing-details-full-gallery.html">
                                            <img src="{{ url('site') }}/images/shop/shop-1.jpg" alt="store 1"
                                                class="card-img-top rounded-0">
                                        </a>
                                        <div class="image-content position-absolute d-flex align-items-center">
                                            <div class="content-left">
                                                <div class="badge badge-primary">Featured</div>
                                            </div>
                                            <div class="content-right ml-auto d-flex show-link">
                                                <a href="{{ url('site') }}/images/shop/full-shop-1.jpg"
                                                    class="item viewing" data-toggle="tooltip" data-placement="top"
                                                    title="Quickview" data-gtf-mfp="true">
                                                    <svg class="icon icon-expand">
                                                        <use xlink:href="{{ url('site') }}/#icon-expand"></use>
                                                    </svg>
                                                </a>
                                                <a href="{{ url('site') }}/#" class="item marking"
                                                    data-toggle="tooltip" data-placement="top" title="Bookmark"><i
                                                        class="fal fa-bookmark"></i></a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-body px-0 pb-0 pt-3">
                                        <a href="{{ url('site') }}/listing-details-full-gallery.html"
                                            class="card-title h5 text-dark d-inline-block mb-2"><span
                                                class="letter-spacing-25">Roman
                                                Kraft Hotel</span></a>
                                        <ul
                                            class="list-inline store-meta mb-4 font-size-sm d-flex align-items-center flex-wrap">
                                            <li class="list-inline-item"><span
                                                    class="badge badge-success d-inline-block mr-1">5.0</span><span>4
                                                    rating</span>
                                            </li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><span class="mr-1">From</span><span
                                                    class="text-danger font-weight-semibold">$9.00</span></li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><a href="{{ url('site') }}/#"
                                                    class="link-hover-secondary-primary">
                                                    <svg class="icon icon-pizza">
                                                        <use xlink:href="{{ url('site') }}/#icon-pizza"></use>
                                                    </svg>
                                                    <span>Food</span>
                                                </a></li>
                                        </ul>

                                        <div class="media">
                                            <a href="{{ url('site') }}/#" class="d-inline-block mr-3"><img
                                                    src="{{ url('site') }}/images/listing/testimonial-1.png"
                                                    alt="testimonial" class="rounded-circle">
                                            </a>
                                            <div class="media-body lh-14 font-size-sm">They specialize in makgeolli
                                                at this
                                                Korean-style
                                                pub in Seorae Village. And they use...
                                            </div>
                                        </div>
                                    </div>
                                    <ul
                                        class="list-inline card-footer rounded-0 border-top pt-3 mt-5 bg-transparent px-0 store-meta d-flex align-items-center">
                                        <li class="list-inline-item">
                                            <span class="d-inline-block mr-1"><i class="fal fa-map-marker-alt">
                                                </i>
                                            </span>
                                            <a href="{{ url('site') }}/#"
                                                class="text-secondary text-decoration-none address py-1">Ubud,
                                                Indonesia</a>
                                        </li>
                                        <li class="list-inline-item separate"></li>
                                        <li class="list-inline-item">
                                            <span class="text-danger">Close now!</span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="ad-directory" role="tabpanel" aria-labelledby="ad-directory">
                        <div class="slick-slider arrow-top full-slide custom-nav"
                            data-slick-options='{"slidesToShow": 5,"autoplay":false,"dots":false,"arrows":false,"responsive":[{"breakpoint": 2000,"settings": {"slidesToShow": 4}},{"breakpoint": 1500,"settings": {"slidesToShow": 3}},{"breakpoint": 1000,"settings": {"slidesToShow": 2}},{"breakpoint": 770,"settings": {"slidesToShow": 1}}]}'>
                            <div class="box" data-animate="fadeInUp">
                                <div class="store card border-0 rounded-0">
                                    <div class="position-relative store-image">
                                        <a href="{{ url('site') }}/listing-details-full-gallery.html">
                                            <img src="{{ url('site') }}/images/shop/shop-1.jpg" alt="store 1"
                                                class="card-img-top rounded-0">
                                        </a>
                                        <div class="image-content position-absolute d-flex align-items-center">
                                            <div class="content-left">
                                                <div class="badge badge-primary">Featured</div>
                                            </div>
                                            <div class="content-right ml-auto d-flex w-lg show-link">
                                                <a href="{{ url('site') }}/images/shop/full-shop-1.jpg"
                                                    class="item viewing" data-toggle="tooltip" data-placement="top"
                                                    title="Quickview" data-gtf-mfp="true">
                                                    <svg class="icon icon-expand">
                                                        <use xlink:href="{{ url('site') }}/#icon-expand"></use>
                                                    </svg>
                                                </a>
                                                <a href="{{ url('site') }}/#" class="item marking"
                                                    data-toggle="tooltip" data-placement="top" title="Bookmark"><i
                                                        class="fal fa-bookmark"></i></a>
                                                <a href="{{ url('site') }}/#" class="item" data-toggle="tooltip"
                                                    data-placement="top" title="Compare">
                                                    <svg class="icon icon-chart-bars">
                                                        <use xlink:href="{{ url('site') }}/#icon-chart-bars"></use>
                                                    </svg>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-body px-0 pb-0 pt-3">
                                        <a href="{{ url('site') }}/listing-details-full-gallery.html"
                                            class="card-title h5 text-dark d-inline-block mb-2"><span
                                                class="letter-spacing-25">Roman
                                                Kraft Hotel</span></a>
                                        <ul
                                            class="list-inline store-meta mb-4 font-size-sm d-flex align-items-center flex-wrap">
                                            <li class="list-inline-item"><span
                                                    class="badge badge-success d-inline-block mr-1">5.0</span><span>4
                                                    rating</span>
                                            </li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><span class="mr-1">From</span><span
                                                    class="text-danger font-weight-semibold">$56.00</span></li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item">
                                                <a href="{{ url('site') }}/#" class="link-hover-secondary-primary">
                                                    <svg class="icon icon-bed">
                                                        <use xlink:href="{{ url('site') }}/#icon-bed"></use>
                                                    </svg>
                                                    <span>Hotel</span>
                                                </a>
                                            </li>
                                        </ul>
                                        <div class="media">
                                            <a href="{{ url('site') }}/#" class="d-inline-block mr-3"><img
                                                    src="{{ url('site') }}/images/listing/testimonial-1.png"
                                                    alt="testimonial" class="rounded-circle">
                                            </a>
                                            <div class="media-body lh-14 font-size-sm">Overlooking Bloomsbury's
                                                Russell Square
                                                and
                                                a 2 minutes' walk from the tube station of the same name...
                                            </div>
                                        </div>
                                    </div>
                                    <ul
                                        class="list-inline card-footer rounded-0 border-top pt-3 mt-5 bg-transparent px-0 store-meta d-flex align-items-center">
                                        <li class="list-inline-item">
                                            <span class="d-inline-block mr-1">
                                                <i class="fal fa-map-marker-alt">
                                                </i>
                                            </span>
                                            <a href="{{ url('site') }}/#"
                                                class="text-secondary text-decoration-none link-hover-secondary-blue">
                                                San Francisco, CA</a>
                                        </li>
                                        <li class="list-inline-item separate"></li>
                                        <li class="list-inline-item">
                                            <span class="text-green">Open now!</span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="box" data-animate="fadeInUp">
                                <div class="store card border-0 rounded-0">
                                    <div class="position-relative store-image">
                                        <a href="{{ url('site') }}/listing-details-full-gallery.html">
                                            <img src="{{ url('site') }}/images/shop/shop-2.jpg" alt="store 2"
                                                class="card-img-top rounded-0">
                                        </a>
                                        <div class="image-content position-absolute d-flex align-items-center">
                                            <div class="content-left">
                                                <div class="badge badge-primary">Best Rate</div>
                                            </div>
                                            <div class="content-right ml-auto d-flex show-link">
                                                <a href="{{ url('site') }}/images/shop/full-shop-2.jpg"
                                                    data-gtf-mfp="true" class="item viewing" data-toggle="tooltip"
                                                    data-placement="top" title="Quick view">
                                                    <svg class="icon icon-expand">
                                                        <use xlink:href="{{ url('site') }}/#icon-expand"></use>
                                                    </svg>
                                                </a>
                                                <a href="{{ url('site') }}/#" class="item marking"
                                                    data-toggle="tooltip" data-placement="top" title="Bookmark"><i
                                                        class="fal fa-bookmark"></i></a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-body px-0 pb-0 pt-3">
                                        <a href="{{ url('site') }}/listing-details-full-image.html"
                                            class="card-title h5 text-dark d-inline-block mb-2"><span
                                                class="letter-spacing-25">Karly Gomez Cake</span>
                                            <span class="check">
                                                <svg class="icon icon-check-circle">
                                                    <use xlink:href="{{ url('site') }}/#icon-check-circle"></use>
                                                </svg>
                                            </span>
                                        </a>
                                        <ul
                                            class="list-inline store-meta mb-4 font-size-sm d-flex align-items-center flex-wrap">
                                            <li class="list-inline-item"><span
                                                    class="badge badge-success d-inline-block mr-1">5.0</span><span>8
                                                    rating</span>
                                            </li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><span class="mr-1">From</span><span
                                                    class="text-danger font-weight-semibold">$12.00</span></li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><a href="{{ url('site') }}/#"
                                                    class="link-hover-secondary-primary">
                                                    <svg class="icon icon-pizza">
                                                        <use xlink:href="{{ url('site') }}/#icon-pizza"></use>
                                                    </svg>
                                                    <span>Food</span>
                                                </a></li>
                                        </ul>

                                        <div class="media">
                                            <a href="{{ url('site') }}/#" class="d-inline-block mr-3"><img
                                                    src="{{ url('site') }}/images/listing/testimonial-2.png"
                                                    alt="testimonial" class="rounded-circle">
                                            </a>
                                            <div class="media-body lh-14 font-size-sm">They specialize in makgeolli
                                                at this
                                                Korean-style pub in Seorae Village. And they use...
                                            </div>
                                        </div>
                                    </div>
                                    <ul
                                        class="list-inline card-footer rounded-0 border-top pt-3 mt-5 bg-transparent px-0 store-meta d-flex align-items-center">
                                        <li class="list-inline-item">
                                            <span class="d-inline-block mr-1">
                                                <i class="fal fa-map-marker-alt">
                                                </i>
                                            </span>
                                            <a href="{{ url('site') }}/#"
                                                class="text-secondary text-decoration-none address">Florencia,
                                                Italy</a>
                                        </li>
                                        <li class="list-inline-item separate"></li>
                                        <li class="list-inline-item">
                                            <span class="text-danger">Close now!</span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="box" data-animate="fadeInUp">
                                <div class="store card border-0 rounded-0">
                                    <div class="position-relative store-image">
                                        <a href="{{ url('site') }}/listing-details-full-gallery.html">
                                            <img src="{{ url('site') }}/images/shop/shop-3.jpg" alt="store 1"
                                                class="card-img-top rounded-0">
                                        </a>
                                        <div class="image-content position-absolute d-flex align-items-center">
                                            <div class="content-left">
                                                <div class="badge badge-primary">Most view</div>
                                            </div>
                                            <div class="content-right ml-auto d-flex show-link">
                                                <a href="{{ url('site') }}/images/shop/full-shop-3.jpg"
                                                    class="item viewing" data-toggle="tooltip" data-placement="top"
                                                    title="Quick view" data-gtf-mfp="true">
                                                    <svg class="icon icon-expand">
                                                        <use xlink:href="{{ url('site') }}/#icon-expand"></use>
                                                    </svg>
                                                </a>
                                                <a href="{{ url('site') }}/#" class="item marking"
                                                    data-toggle="tooltip" data-placement="top" title="Bookmark"><i
                                                        class="fal fa-bookmark"></i></a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-body px-0 pb-0 pt-3">
                                        <a href="{{ url('site') }}/listing-details-full-gallery.html"
                                            class="card-title h5 text-dark d-inline-block mb-2"><span
                                                class="letter-spacing-25">Roman
                                                Kraft Hotel</span></a>
                                        <ul
                                            class="list-inline store-meta mb-4 font-size-sm d-flex align-items-center flex-wrap">
                                            <li class="list-inline-item"><span
                                                    class="badge badge-warning d-inline-block mr-1">4.3</span><span>4
                                                    rating</span>
                                            </li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><span class="mr-1">From</span><span
                                                    class="text-danger font-weight-semibold">$10.00</span></li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><a href="{{ url('site') }}/#"
                                                    class="link-hover-secondary-primary">
                                                    <svg class="icon icon-pizza">
                                                        <use xlink:href="{{ url('site') }}/#icon-pizza"></use>
                                                    </svg>
                                                    <span>Food</span>
                                                </a></li>
                                        </ul>
                                        <div class="media">
                                            <a href="{{ url('site') }}/#" class="d-inline-block mr-3"><img
                                                    src="{{ url('site') }}/images/listing/testimonial-5.png"
                                                    alt="testimonial" class="rounded-circle">
                                            </a>
                                            <div class="media-body lh-14 font-size-sm">After a yoga class changed
                                                her life, Maz
                                                became
                                                vegan, launched...
                                            </div>
                                        </div>
                                    </div>
                                    <ul
                                        class="list-inline card-footer rounded-0 border-top pt-3 mt-5 bg-transparent px-0 store-meta d-flex align-items-center">
                                        <li class="list-inline-item">
                                            <span class="d-inline-block mr-1"><i class="fal fa-map-marker-alt">
                                                </i>
                                            </span>
                                            <a href="{{ url('site') }}/#"
                                                class="text-secondary text-decoration-none address">Miami,
                                                FL</a>
                                        </li>
                                        <li class="list-inline-item separate"></li>
                                        <li class="list-inline-item">
                                            <span class="text-danger">Close now!</span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="box" data-animate="fadeInUp">
                                <div class="store card border-0 rounded-0">
                                    <div class="position-relative store-image">
                                        <a href="{{ url('site') }}/listing-details-full-gallery.html">
                                            <img src="{{ url('site') }}/images/shop/shop-4.jpg" alt="store 1"
                                                class="card-img-top rounded-0">
                                        </a>
                                        <div class="image-content position-absolute d-flex align-items-center">
                                            <div class="content-left">
                                                <div class="badge badge-primary">Featured</div>
                                            </div>
                                            <div class="content-right ml-auto d-flex show-link">
                                                <a href="{{ url('site') }}/images/shop/full-shop-4.jpg"
                                                    class="item viewing" data-toggle="tooltip" data-gtf-mfp="true"
                                                    data-placement="top" title="Quick view">
                                                    <svg class="icon icon-expand">
                                                        <use xlink:href="{{ url('site') }}/#icon-expand"></use>
                                                    </svg>
                                                </a>
                                                <a href="{{ url('site') }}/#" class="item marking"
                                                    data-toggle="tooltip" data-placement="top" title="Bookmark"><i
                                                        class="fal fa-bookmark"></i></a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-body px-0 pb-0 pt-3">
                                        <a href="{{ url('site') }}/listing-details-full-image.html"
                                            class="card-title h5 text-dark d-inline-block mb-2"><span
                                                class="letter-spacing-25">Red Wings Shoes Store</span></a>
                                        <ul
                                            class="list-inline store-meta mb-4 font-size-sm d-flex align-items-center flex-wrap">
                                            <li class="list-inline-item"><span
                                                    class="badge badge-success d-inline-block mr-1">5.0</span><span>6
                                                    rating</span>
                                            </li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><span class="mr-1">From</span><span
                                                    class="text-danger font-weight-semibold">$75.00</span></li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><a href="{{ url('site') }}/#"
                                                    class="link-hover-secondary-primary">
                                                    <svg class="icon icon-bag">
                                                        <use xlink:href="{{ url('site') }}/#icon-bag"></use>
                                                    </svg>
                                                    <span>Shopping</span>
                                                </a></li>
                                        </ul>
                                        <div class="media">
                                            <a href="{{ url('site') }}/#" class="d-inline-block mr-3"><img
                                                    src="{{ url('site') }}/images/listing/testimonial-3.png"
                                                    alt="testimonial" class="rounded-circle">
                                            </a>
                                            <div class="media-body lh-14 font-size-sm">Established in 1895, these
                                                style
                                                merchants have
                                                set the standard in Sydney suiting for generations...
                                            </div>
                                        </div>
                                    </div>
                                    <ul
                                        class="list-inline card-footer rounded-0 border-top pt-3 mt-5 bg-transparent px-0 store-meta d-flex align-items-center">
                                        <li class="list-inline-item">
                                            <span class="d-inline-block mr-1"><i class="fal fa-map-marker-alt">
                                                </i>
                                            </span>
                                            <a href="{{ url('site') }}/#"
                                                class="text-secondary text-decoration-none address">
                                                Paris, France</a>
                                        </li>
                                        <li class="list-inline-item separate"></li>
                                        <li class="list-inline-item">
                                            <span class="text-danger">Close now!</span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="box" data-animate="fadeInUp">
                                <div class="store card border-0 rounded-0">
                                    <div class="position-relative store-image">
                                        <a href="{{ url('site') }}/listing-details-full-gallery.html">
                                            <img src="{{ url('site') }}/images/shop/shop-5.jpg" alt="store 1"
                                                class="card-img-top rounded-0">
                                        </a>
                                        <div class="image-content position-absolute d-flex align-items-center">
                                            <div class="content-left">
                                                <div class="badge badge-primary">AD</div>
                                            </div>
                                            <div class="content-right ml-auto d-flex show-link">
                                                <a href="{{ url('site') }}/images/shop/full-shop-5.jpg"
                                                    class="item viewing" data-toggle="tooltip" data-placement="top"
                                                    data-gtf-mfp="true" title="Quick view">
                                                    <svg class="icon icon-expand">
                                                        <use xlink:href="{{ url('site') }}/#icon-expand"></use>
                                                    </svg>
                                                </a>
                                                <a href="{{ url('site') }}/#" class="item marking"
                                                    data-toggle="tooltip" data-placement="top" title="Bookmark"><i
                                                        class="fal fa-bookmark"></i></a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-body px-0 pb-0 pt-3">
                                        <a href="{{ url('site') }}/listing-details-full-image.html"
                                            class="card-title h5 text-dark d-inline-block mb-2"><span
                                                class="letter-spacing-25">Packing & Delivery Service</span>
                                            <span class="check">
                                                <svg class="icon icon-check-circle">
                                                    <use xlink:href="{{ url('site') }}/#icon-check-circle"></use>
                                                </svg>
                                            </span>
                                        </a>
                                        <ul
                                            class="list-inline store-meta mb-4 font-size-sm d-flex align-items-center flex-wrap">
                                            <li class="list-inline-item"><span
                                                    class="badge badge-warning d-inline-block mr-1">4.5</span><span>2
                                                    rating</span>
                                            </li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><span
                                                    class="text-danger font-weight-semibold">Get a quote</span>
                                            </li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><a href="{{ url('site') }}/#"
                                                    class="link-hover-secondary-primary">
                                                    <svg class="icon icon-cog">
                                                        <use xlink:href="{{ url('site') }}/#icon-cog"></use>
                                                    </svg>
                                                    <span>Service</span>
                                                </a></li>
                                        </ul>
                                        <div class="media">
                                            <a href="{{ url('site') }}/#" class="d-inline-block mr-3"><img
                                                    src="{{ url('site') }}/images/listing/testimonial-2.png"
                                                    alt="testimonial" class="rounded-circle">
                                            </a>
                                            <div class="media-body lh-14 font-size-sm">Most items can be packed
                                                securely in
                                                these
                                                boxes, which are available in several sizes...
                                            </div>
                                        </div>
                                    </div>
                                    <ul
                                        class="list-inline card-footer rounded-0 border-top pt-3 mt-5 bg-transparent px-0 store-meta d-flex align-items-center">
                                        <li class="list-inline-item">
                                            <span class="d-inline-block mr-1"><i class="fal fa-map-marker-alt">
                                                </i>
                                            </span>
                                            <a href="{{ url('site') }}/#"
                                                class="text-secondary text-decoration-none address">New
                                                York, USA</a>
                                        </li>
                                        <li class="list-inline-item separate"></li>
                                        <li class="list-inline-item">
                                            <span class="text-green">Open now!</span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="box" data-animate="fadeInUp">
                                <div class="store card border-0 rounded-0">
                                    <div class="position-relative store-image">
                                        <a href="{{ url('site') }}/listing-details-full-gallery.html">
                                            <img src="{{ url('site') }}/images/shop/shop-1.jpg" alt="store 1"
                                                class="card-img-top rounded-0">
                                        </a>
                                        <div class="image-content position-absolute d-flex align-items-center">
                                            <div class="content-left">
                                                <div class="badge badge-primary">Featured</div>
                                            </div>
                                            <div class="content-right ml-auto d-flex show-link">
                                                <a href="{{ url('site') }}/images/shop/full-shop-1.jpg"
                                                    class="item viewing" data-toggle="tooltip" data-placement="top"
                                                    title="Quickview" data-gtf-mfp="true">
                                                    <svg class="icon icon-expand">
                                                        <use xlink:href="{{ url('site') }}/#icon-expand"></use>
                                                    </svg>
                                                </a>
                                                <a href="{{ url('site') }}/#" class="item marking"
                                                    data-toggle="tooltip" data-placement="top" title="Bookmark"><i
                                                        class="fal fa-bookmark"></i></a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-body px-0 pb-0 pt-3">
                                        <a href="{{ url('site') }}/listing-details-full-gallery.html"
                                            class="card-title h5 text-dark d-inline-block mb-2"><span
                                                class="letter-spacing-25">Roman
                                                Kraft Hotel</span></a>
                                        <ul
                                            class="list-inline store-meta mb-4 font-size-sm d-flex align-items-center flex-wrap">
                                            <li class="list-inline-item"><span
                                                    class="badge badge-success d-inline-block mr-1">5.0</span><span>4
                                                    rating</span>
                                            </li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><span class="mr-1">From</span><span
                                                    class="text-danger font-weight-semibold">$9.00</span></li>
                                            <li class="list-inline-item separate"></li>
                                            <li class="list-inline-item"><a href="{{ url('site') }}/#"
                                                    class="link-hover-secondary-primary">
                                                    <svg class="icon icon-pizza">
                                                        <use xlink:href="{{ url('site') }}/#icon-pizza"></use>
                                                    </svg>
                                                    <span>Food</span>
                                                </a></li>
                                        </ul>

                                        <div class="media">
                                            <a href="{{ url('site') }}/#" class="d-inline-block mr-3"><img
                                                    src="{{ url('site') }}/images/listing/testimonial-1.png"
                                                    alt="testimonial" class="rounded-circle">
                                            </a>
                                            <div class="media-body lh-14 font-size-sm">They specialize in makgeolli
                                                at this
                                                Korean-style
                                                pub in Seorae Village. And they use...
                                            </div>
                                        </div>
                                    </div>
                                    <ul
                                        class="list-inline card-footer rounded-0 border-top pt-3 mt-5 bg-transparent px-0 store-meta d-flex align-items-center">
                                        <li class="list-inline-item">
                                            <span class="d-inline-block mr-1"><i class="fal fa-map-marker-alt">
                                                </i>
                                            </span>
                                            <a href="{{ url('site') }}/#"
                                                class="text-secondary text-decoration-none address py-1">Ubud,
                                                Indonesia</a>
                                        </li>
                                        <li class="list-inline-item separate"></li>
                                        <li class="list-inline-item">
                                            <span class="text-danger">Close now!</span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- /#section-03 end -->
        <!-- #section 04 start -->
        <section class="home-main-testimonial pt-12 pb-13" id="section-04">
            <div class="container">
                <h2 class="mb-8">
                    <span class="font-weight-semibold">Clients </span>
                    <span class="font-weight-light">Review</span>
                </h2>
                <div class="container">
                    <div class="row">
                        <div class="col col-md-12">
                            <div class="slick-slider testimonials-slider arrow-top"
                                data-slick-options='{"slidesToShow": 2,"autoplay":false,"dots":false,"responsive":[{"breakpoint": 992,"settings": {"slidesToShow": 1,"arrows":false}}]}'>
                                <div class="box">
                                    <div class="card testimonial h-100 border-0 bg-transparent">
                                        <a href="{{ url('site') }}/#" class="author-image">
                                            <img src="{{ url('site') }}/images/listing/client-1.png"
                                                alt="Testimonial" class="rounded-circle">
                                        </a>
                                        <div class="card-body bg-white">
                                            <div class="testimonial-icon text-right">
                                                <svg class="icon icon-quote">
                                                    <use xlink:href="{{ url('site') }}/#icon-quote"></use>
                                                </svg>
                                            </div>
                                            <ul class="list-inline mb-4 d-flex align-items-end flex-wrap">
                                                <li class="list-inline-item">
                                                    <a href="{{ url('site') }}/#"
                                                        class="font-size-lg text-dark font-weight-semibold d-inline-block">Kanye
                                                        West
                                                    </a>
                                                </li>
                                                <li class="list-inline-item">
                                                    <span
                                                        class="h5 font-weight-light mb-0 d-inline-block ml-1 text-gray">/</span>
                                                </li>
                                                <li>
                                                    <span class="text-gray">
                                                        CEO at Google INC
                                                    </span>
                                                </li>
                                            </ul>
                                            <div class="card-text text-gray pr-4">Sed elit quam, iaculis
                                                sed
                                                semper sit amet
                                                udin
                                                vitae nibh.<br> at magna akal semperFusce commodo molestie
                                                luctus.Lorem ipsum Dolor tusima olatiup.
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="box">
                                    <div class="card testimonial h-100 border-0 bg-transparent">
                                        <a href="{{ url('site') }}/#" class="author-image">
                                            <img src="{{ url('site') }}/images/listing/client-2.png"
                                                alt="Testimonial" class="rounded-circle">
                                        </a>
                                        <div class="card-body bg-white">
                                            <div class="testimonial-icon text-right">
                                                <svg class="icon icon-quote">
                                                    <use xlink:href="{{ url('site') }}/#icon-quote"></use>
                                                </svg>
                                            </div>
                                            <ul class="list-inline mb-4 d-flex align-items-end flex-wrap">
                                                <li class="list-inline-item">
                                                    <a href="{{ url('site') }}/#"
                                                        class="font-size-lg text-dark font-weight-semibold d-inline-block">Anabella
                                                        Kleva
                                                    </a>
                                                </li>
                                                <li class="list-inline-item">
                                                    <span
                                                        class="h5 font-weight-light mb-0 d-inline-block ml-1 text-gray">/</span>
                                                </li>
                                                <li class="list-inline-item">
                                                    <span class="text-gray">
                                                        Managerment at Envato
                                                    </span>
                                                </li>

                                            </ul>
                                            <div class="card-text text-gray pr-4">Sed elit quam, iaculis
                                                sed
                                                semper sit amet
                                                udin
                                                vitae nibh.<br> at magna akal semperFusce commodo molestie
                                                luctus.Lorem ipsum Dolor tusima olatiup.
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="box">
                                    <div class="card testimonial h-100 border-0 bg-transparent">
                                        <a href="{{ url('site') }}/#" class="author-image">
                                            <img src="{{ url('site') }}/images/listing/client-1.png"
                                                alt="Testimonial" class="rounded-circle">
                                        </a>
                                        <div class="card-body bg-white">
                                            <div class="testimonial-icon text-right">
                                                <svg class="icon icon-quote">
                                                    <use xlink:href="{{ url('site') }}/#icon-quote"></use>
                                                </svg>
                                            </div>
                                            <ul class="list-inline mb-4 d-flex align-items-end flex-wrap">
                                                <li class="list-inline-item">
                                                    <a href="{{ url('site') }}/#"
                                                        class="font-size-lg text-dark font-weight-semibold d-inline-block">Kanye
                                                        West
                                                    </a>
                                                </li>
                                                <li class="list-inline-item">
                                                    <span
                                                        class="h5 font-weight-light mb-0 d-inline-block ml-1 text-gray">/</span>
                                                </li>
                                                <li>
                                                    <span class="text-gray">
                                                        CEO at Google INC
                                                    </span>
                                                </li>
                                            </ul>
                                            <div class="card-text text-gray pr-4">Sed elit quam, iaculis
                                                sed
                                                semper sit amet
                                                udin
                                                vitae nibh.<br> at magna akal semperFusce commodo molestie
                                                luctus.Lorem ipsum Dolor tusima olatiup.
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="box">
                                    <div class="card testimonial h-100 border-0 bg-transparent">
                                        <a href="{{ url('site') }}/#" class="author-image">
                                            <img src="{{ url('site') }}/images/listing/client-2.png"
                                                alt="Testimonial" class="rounded-circle">
                                        </a>
                                        <div class="card-body bg-white">
                                            <div class="testimonial-icon text-right">
                                                <svg class="icon icon-quote">
                                                    <use xlink:href="{{ url('site') }}/#icon-quote"></use>
                                                </svg>
                                            </div>
                                            <ul class="list-inline mb-4 d-flex align-items-end flex-wrap">
                                                <li class="list-inline-item">
                                                    <a href="{{ url('site') }}/#"
                                                        class="font-size-lg text-dark font-weight-semibold d-inline-block">Anabella
                                                        Kleva
                                                    </a>
                                                </li>
                                                <li class="list-inline-item">
                                                    <span
                                                        class="h5 font-weight-light mb-0 d-inline-block ml-1 text-gray">/</span>
                                                </li>
                                                <li class="list-inline-item">
                                                    <span class="text-gray">
                                                        Managerment at Envato
                                                    </span>
                                                </li>

                                            </ul>
                                            <div class="card-text text-gray pr-4">Sed elit quam, iaculis
                                                sed
                                                semper sit amet
                                                udin
                                                vitae nibh.<br> at magna akal semperFusce commodo molestie
                                                luctus.Lorem ipsum Dolor tusima olatiup.
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- /#section-04 end -->
        <!-- #section 05 start -->
        <section id="section-05" class="pt-11 pb-11">
            <div class="container">
                <div class="d-flex align-items-center mb-7 flex-wrap flex-sm-nowrap">
                    <h2 class="mb-3 mb-sm-0">
                        <span class="font-weight-semibold">Some</span>
                        <span class="font-weight-light">Tips & Articles</span>
                    </h2>
                    <a href="{{ url('site') }}/blog-listing-grid.html"
                        class="link-hover-dark-primary ml-0 ml-sm-auto w-100 w-sm-auto">
                        <span class="font-size-md d-inline-block mr-1">All articles</span>
                        <i class="fal fa-chevron-right"></i>
                    </a>
                </div>
                <div class="row">
                    <div class="col-md-4 mb-4" data-animate="zoomIn">
                        <div class="card border-0">
                            <a href="{{ url('site') }}/blog-single-gallery.html" class="hover-scale">
                                <img src="{{ url('site') }}/images/blog/main-blog-2.jpg" alt="product 1"
                                    class="card-img-top image">
                            </a>
                            <div class="card-body px-0">
                                <div class="mb-2"><a href="{{ url('site') }}/#"
                                        class="link-hover-dark-primary">Tips</a>, <a href="{{ url('site') }}/#"
                                        class="link-hover-dark-primary">Travel</a></div>
                                <h5 class="card-title lh-13 letter-spacing-25">
                                    <a href="{{ url('site') }}/blog-single-image.html"
                                        class="link-hover-dark-primary text-capitalize">
                                        10 best homestay in florencia that you don't miss
                                        out</a>
                                </h5>
                                <ul class="list-inline">
                                    <li class="list-inline-item mr-0">
                                        <span class="text-gray">Aug 28th, 2017 by</span>
                                    </li>
                                    <li class="list-inline-item">
                                        <a href="{{ url('site') }}/#" class="link-hover-dark-primary">Admin</a>
                                    </li>

                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4 mb-4" data-animate="zoomIn">
                        <div class="card border-0">
                            <a href="{{ url('site') }}/blog-single-gallery.html" class="hover-scale">
                                <img src="{{ url('site') }}/images/blog/main-blog-3.jpg" alt="product 1"
                                    class="card-img-top image">
                            </a>
                            <div class="card-body px-0">
                                <div class="mb-2"><a href="{{ url('site') }}/#"
                                        class="link-hover-dark-primary">Culture</a></div>
                                <h5 class="card-title lh-13 letter-spacing-25"><a
                                        href="{{ url('site') }}/blog-single-gallery.html"
                                        class="link-hover-dark-primary text-capitalize">Coffee
                                        On Street & Look Super Car</a>
                                </h5>
                                <ul class="list-inline">
                                    <li class="list-inline-item mr-0">
                                        <span class="text-gray">Aug 25th, 2017 by</span>
                                    </li>
                                    <li class="list-inline-item">
                                        <a href="{{ url('site') }}/#" class="link-hover-dark-primary">David</a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4 mb-4" data-animate="zoomIn">
                        <div class="card border-0">
                            <a href="{{ url('site') }}/blog-single-gallery.html" class="hover-scale">
                                <img src="{{ url('site') }}/images/blog/main-blog-1.jpg" alt="product 1"
                                    class="card-img-top image">
                            </a>
                            <div class="card-body px-0">
                                <div class="mb-2"><a href="{{ url('site') }}/#"
                                        class="link-hover-dark-primary">Location</a></div>
                                <h5 class="card-title lh-13 letter-spacing-25"><a
                                        href="{{ url('site') }}/blog-single-gallery.html"
                                        class="link-hover-dark-primary">MadCap
                                        Coffee At
                                        Brooklyn Town For Who Love Black
                                        Coffee</a>
                                </h5>
                                <ul class="list-inline">
                                    <li class="list-inline-item mr-0">
                                        <span class="text-gray">Aug 19th, 2017 by</span>
                                    </li>
                                    <li class="list-inline-item">
                                        <a href="{{ url('site') }}/#" class="link-hover-dark-primary">LoganCee</a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- /#section-05 end -->
    </div>
@endsection
