@extends('base.base')
@section('titulo','Clientes')
@section('content')
  <div class="content-wrapper">
    <div class="container-full">
      <div class="content-header">
          <div class="d-flex align-items-center">
              <div class="me-auto">
                  <h4 class="page-title">Clientes</h4>
              </div>
              <div class="form-group">
                <a href="{{ route('cliente.create') }}" class="btn btn-primary btn-sm"> <span><i class="fa fa-user-plus"></i> Novo Cliente</span> </a>
            </div>
          </div>
      </div>
      <section class="content">
          <div class="row">
              <div class="col-sm-12">
                  <div class="box">
                      <div class="box-body">
                          <div class="table-responsive">
                              <table id="example" class="table table-center table-hover datatable">
                                  <thead class="thead-light">
                                      <tr>
                                          <th>Cód.</th>
                                          <th>Empresa/Nome</th>
                                          <th>CNPJ/CPF</th>
                                          <th>Celular</th>
                                          <th>Telefone</th>
                                          <th>E-mail</th>
                                          <th>Status</th>
                                          <th class="text-end"></th>
                                      </tr>
                                  </thead>
                                  <tbody>
                                    @foreach ($clientes as $cliente)
                                        <tr>
                                            <td>
                                                {{ $cliente->id }}</td>
                                            <td>
                                                {!! $cliente->tipo == 'PF' ? $cliente->nome : $cliente->fantasia.'<br>'.$cliente->nome !!}
                                            </td>
                                            <td>
                                                {!! $cliente->tipo == 'PF' ? $cliente->cpf : $cliente->cnpj.'<br>'.$cliente->cpf !!}
                                            </td>
                                            <td>{{ $cliente->telefone }}</td>
                                            <td>{{ $cliente->celular }}</td>
                                            <td>{{ $cliente->email }}</td>
                                            <td><span class="badge badge-pill bg-{{ $cliente->status == 'Ativo' ? 'success' : 'danger' }}-light">{{ $cliente->status }}</span></td>
                                            <td class="text-end">
                                                <a href="{{ route('cliente.show',$cliente->id) }}" class="btn btn-sm btn-white text-success me-5"><i class="fa fa-user me-5"></i> Abrir</a>
                                            </td>
                                        </tr>
                                    @endforeach
                                  </tbody>
                              </table>
                          </div>
                      </div>
                  </div>
              </div>
          </div>
      </section>
      <!-- /.content -->
    </div>
</div>
<!-- /.content-wrapper -->
@endsection
@section('js')
    	<!-- CRMi App -->
    <script src="{{url('adm')}}/assets/vendor_components/datatable/datatables.min.js"></script>
	<script src="{{url('adm')}}/src/js/pages/data-table.js"></script>
@endsection
