<!DOCTYPE html>
<html lang="zxx">
<head>
    <title>{{env('APP_NAME')}} TERMO DE RESPONSABILIDADE PARA VACINAÇÃO - {{$animal->nome}}, {{$animal->raca_nome}} emitica por {{$user->sexo}} {{$user->name}} CRMV {{$user->crmv}}</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta charset="UTF-8">

    <!-- External CSS libraries -->
    <link type="text/css" rel="stylesheet" href="{{ url('prints') }}/assets/css/bootstrap.min.css">
    <link type="text/css" rel="stylesheet" href="{{ url('prints') }}/assets/fonts/font-awesome/css/font-awesome.min.css">

    <!-- Favicon icon -->
    <link rel="shortcut icon" href="{{ url('prints') }}/assets/img/favicon.ico" type="image/x-icon" >

    <!-- Google fonts -->
    <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@100;200;300;400;500;600;700;800;900&amp;display=swap" rel="stylesheet">

    <!-- Custom Stylesheet -->
    <link type="text/css" rel="stylesheet" href="{{ url('prints') }}/assets/css/style.css">
</head>
<body>
    <?php
    $date1 = date('Y-m-d', strtotime($animal->nascimento));

    $date2 = date('Y-m-d');
    $diff = abs(strtotime($date2) - strtotime($date1));

    $years = floor($diff / (365 * 60 * 60 * 24));
    $months = floor(($diff - $years * 365 * 60 * 60 * 24) / (30 * 60 * 60 * 24));
    $days = floor(($diff - $years * 365 * 60 * 60 * 24 - $months * 30 * 60 * 60 * 24) / (60 * 60 * 24));
    ?>
<!-- Invoice 6 start -->
<div class="invoice-6 invoice-content">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="invoice-inner-6" id="invoice_wrapper">
                    <div class="invoice-top">
                        <div class="row">
                            <div class="col-sm-4">
                                <div>
                                    <img width="70" src="{{ url('adm') }}/assets/media/logos/logo.png" alt="logo">
                                </div>
                            </div>
                            <div class="col-sm-8">
                                <div class="invoice text-right">
                                    <h5>TERMO DE RESPONSABILIDADE PARA VACINAÇÃO</h5>
                                    <h4>{{$clinica->fantasia}}</h4>
                                    <h5>CNPJ: {{ formatCnpjCpf($clinica->cnpj) }}</h5>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="invoice-titel">
                        <div class="row">
                            <div class="invoice2 col-sm-6">
                                <h3>{{$animal->nome}} - {{utf8_decode($animal->raca_nome)}}</h3>
                            </div>
                            <div class="date col-sm-6 text-end">
                                <h3>Data da emissão <span>{{date('d/m/Y',strtotime($termo->created_at))}}</span></h3>
                            </div>
                        </div>
                    </div>
                    <div class="order-summary">
                        <p class="text-4 text-justify">
                            Eu, {{$cliente->name}}, portador do RG: {{$cliente->rg}}, CPF: {{$cliente->cpf}} sito à, {{$cliente->endereco}}, {{$cliente->numero}} {{$cliente->complemento}}, {{$cliente->bairro}}, {{$cliente->cidade}}-{{$cliente->estado}} CEP: {{$cliente->cep}}, responsável pelo animal {{$animal->nome}}, {{utf8_decode($animal->especie_nome)}}, raça {{utf8_decode($animal->raca_nome)}}, do sexo {{$animal->sexo}}, <?php printf("%d ano(s), %d mese(s), %d dia(s)\n", $years, $months, $days); ?>.
                            <br>
                            Informo através deste termo previamente estabelecido que o (s) referido (s) animal (s) encontra-se em bom estado de saúde e não apresenta nenhuma alteração física ou comportamental digna de nota. Estou ciente das condições físicas do (s) meu (s) animal (s) no momento da aplicação da (s) vacina (s), sendo de minha inteira responsabilidade as informações fornecidas ou omitidas que sejam de relevância para o procedimento, assim como a realização ou não de exames previamente solicitados pelo(a) médico(a) veterinário(a) para garantir a integridade do animal no momento da vacinação. Declaro que estou ciente de que as reações vacinais são inerentes ao organismo do animal, não sendo responsabilidade do médico veterinário ou do consultório arcar com os custos e responsabilidades decorrentes de reações vacinais de qualquer natureza.
                        </p>
                        <p class="text-1 text-center">
                            {{$clinica->cidade}},{{$clinica->estado}}  {{date('d/m/Y')}}
                        </p>

                        <p class="text-1 text-center">
                            _______________________________________<br>
                            Cliente: {{$cliente->name}}<br>
                            CPF: {{$cliente->cpf}}
                        </p>
                    </div>
                    <div class="invoice-informeshon">
                        <div class="row mt-4">
                            <div class="col-sm-12">
                                <p class="text-1 text-center">
                                    <img width="200px" src="{{$user->assinatura}}">
                                    <br>
                                    {{$user->sexo}} {{$user->name}}<br>
                                    CRMV: {{$user->crmv}}
                                </p>
                                <p class="text-1 text-center">
                                    <img src="{{url('adm')}}/assets/images/email.png" width="15"> {{ $clinica->email}} <img src="{{url('adm')}}/assets/images/zap-azul.png" width="15"> {{ $clinica->celular}} <img src="{{url('adm')}}/assets/images/instagram.png" width="15"> {{ $clinica->instagram}}
                                </p>
                                @if ($clinica->rodape == 1)
                                    <p class="text-1 text-center">
                                        {{$clinica->endereco}}, {{$clinica->numero}} {{$clinica->complemento}}, {{$clinica->bairro}}, {{$clinica->cidade}}-{{$clinica->estado}} CEP: {{$clinica->cep}}
                                    </p>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
                <div class="invoice-btn-section clearfix d-print-none">
                    <a href="javascript:window.print()" class="btn btn-lg btn-print">
                        <i class="fa fa-print"></i> Imprimir
                    </a>
                    <a id="invoice_download_btn" class="btn btn-lg btn-download">
                        <i class="fa fa-download"></i> Baixar
                    </a>
                    <a target="_blank" href="https://api.whatsapp.com/send?text=Olá segue o *{{$termo->titulo}}* Acesse a termo pelo link: {{env('APP_URL')}}/print/{{setUri($termo->titulo)}}/{{$termo->id}}, emitida por *{{$user->sexo}} {{$user->name}} CRMV {{$user->crmv}}*" class="btn btn-lg btn-success">
                        <img src="{{url('adm')}}/assets/images/whatsapp-logo-branca.png" width="15"> Compartilhar
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Invoice 6 end -->

<script src="{{ url('prints') }}/assets/js/jquery.min.js"></script>
<script src="{{ url('prints') }}/assets/js/jspdf.min.js"></script>
<script src="{{ url('prints') }}/assets/js/html2canvas.js"></script>
<script src="{{ url('prints') }}/assets/js/app.js"></script>
</body>
</html>
