@extends('layouts.base')
@section('titulo', 'Perfil do Cliente')
@section('content')
    <div class="content d-flex flex-column flex-column-fluid" id="kt_content">
        <div class="toolbar" id="kt_toolbar">
            <div id="kt_toolbar_container" class="container-fluid d-flex flex-stack">
                <div data-kt-swapper="true" data-kt-swapper-mode="prepend"
                    data-kt-swapper-parent="{default: '#kt_content_container', 'lg': '#kt_toolbar_container'}"
                    class="page-title d-flex align-items-center flex-wrap me-3 mb-5 mb-lg-0">
                    <h1 class="d-flex align-items-center text-dark fw-bolder fs-3 my-1">Meus dados</h1>
                    <span class="h-20px border-gray-200 border-start mx-4"></span>
                    <ul class="breadcrumb breadcrumb-separatorless fw-bold fs-7 my-1">
                        <li class="breadcrumb-item text-muted">
                            <a href="{{ route('home') }}" class="text-muted text-hover-primary">Home</a>
                        </li>
                        <li class="breadcrumb-item"><span class="bullet bg-gray-200 w-5px h-2px"></span></li>
                        <li class="breadcrumb-item text-dark">{{ Auth::user()->name }}</li>
                    </ul>
                </div>
            </div>
        </div>
        <div class="post d-flex flex-column-fluid" id="kt_post">
            <div id="kt_content_container" class="container-xxl">
                @if (session('message'))
                    <div class="alert alert-danger d-flex align-items-center p-5 mb-10">
                        <span class="svg-icon svg-icon-2hx svg-icon-danger me-4">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                                <path opacity="0.3"
                                    d="M20.5543 4.37824L12.1798 2.02473C12.0626 1.99176 11.9376 1.99176 11.8203 2.02473L3.44572 4.37824C3.18118 4.45258 3 4.6807 3 4.93945V13.569C3 14.6914 3.48509 15.8404 4.4417 16.984C5.17231 17.8575 6.18314 18.7345 7.446 19.5909C9.56752 21.0295 11.6566 21.912 11.7445 21.9488C11.8258 21.9829 11.9129 22 12.0001 22C12.0872 22 12.1744 21.983 12.2557 21.9488C12.3435 21.912 14.4326 21.0295 16.5541 19.5909C17.8169 18.7345 18.8277 17.8575 19.5584 16.984C20.515 15.8404 21 14.6914 21 13.569V4.93945C21 4.6807 20.8189 4.45258 20.5543 4.37824Z"
                                    fill="black"></path>
                                <path
                                    d="M10.5606 11.3042L9.57283 10.3018C9.28174 10.0065 8.80522 10.0065 8.51412 10.3018C8.22897 10.5912 8.22897 11.0559 8.51412 11.3452L10.4182 13.2773C10.8099 13.6747 11.451 13.6747 11.8427 13.2773L15.4859 9.58051C15.771 9.29117 15.771 8.82648 15.4859 8.53714C15.1948 8.24176 14.7183 8.24176 14.4272 8.53714L11.7002 11.3042C11.3869 11.6221 10.874 11.6221 10.5606 11.3042Z"
                                    fill="black"></path>
                            </svg>
                        </span>
                        <div class="d-flex flex-column">
                            <h4 class="mb-1 text-danger">{{ session('message') }}</h4>
                        </div>
                    </div>
                @endif
                @if (session('success'))
                    <div class="alert alert-success d-flex align-items-center p-5 mb-10">
                        <span class="svg-icon svg-icon-2hx svg-icon-success me-4">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                                <path opacity="0.3"
                                    d="M20.5543 4.37824L12.1798 2.02473C12.0626 1.99176 11.9376 1.99176 11.8203 2.02473L3.44572 4.37824C3.18118 4.45258 3 4.6807 3 4.93945V13.569C3 14.6914 3.48509 15.8404 4.4417 16.984C5.17231 17.8575 6.18314 18.7345 7.446 19.5909C9.56752 21.0295 11.6566 21.912 11.7445 21.9488C11.8258 21.9829 11.9129 22 12.0001 22C12.0872 22 12.1744 21.983 12.2557 21.9488C12.3435 21.912 14.4326 21.0295 16.5541 19.5909C17.8169 18.7345 18.8277 17.8575 19.5584 16.984C20.515 15.8404 21 14.6914 21 13.569V4.93945C21 4.6807 20.8189 4.45258 20.5543 4.37824Z"
                                    fill="black"></path>
                                <path
                                    d="M10.5606 11.3042L9.57283 10.3018C9.28174 10.0065 8.80522 10.0065 8.51412 10.3018C8.22897 10.5912 8.22897 11.0559 8.51412 11.3452L10.4182 13.2773C10.8099 13.6747 11.451 13.6747 11.8427 13.2773L15.4859 9.58051C15.771 9.29117 15.771 8.82648 15.4859 8.53714C15.1948 8.24176 14.7183 8.24176 14.4272 8.53714L11.7002 11.3042C11.3869 11.6221 10.874 11.6221 10.5606 11.3042Z"
                                    fill="black"></path>
                            </svg>
                        </span>
                        <div class="d-flex flex-column">
                            <h4 class="mb-1 text-success">{{ session('success') }}</h4>
                        </div>
                    </div>
                @endif

                @include('admin.perfil.base')

                <!--begin::CONTEÚDO DINÂMICO-->
                <div class="card mb-5 mb-xl-10">
                    <div class="card-body">
                        <div class="notice d-flex bg-light-success rounded border-success border border-dashed mb-12 p-6">
                            <span class="svg-icon svg-icon-2tx svg-icon-success me-4">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"> @fontawesome
                                    <path
                                        d="M173.898 439.404l-166.4-166.4c-9.997-9.997-9.997-26.206 0-36.204l36.203-36.204c9.997-9.998 26.207-9.998 36.204 0L192 312.69 432.095 72.596c9.997-9.997 26.207-9.997 36.204 0l36.203 36.204c9.997 9.997 9.997 26.206 0 36.204l-294.4 294.401c-9.998 9.997-26.207 9.997-36.204-.001z" />
                                </svg>
                            </span>
                            <div class="d-flex flex-stack flex-grow-1">
                                <div class="fw-bold">
                                    @if ($fatura)
                                        <h4 class="text-gray-900 fw-bolder">Seus pagamentos então em dias</h4>
                                        <div class="fs-6 text-gray-700">Último pagamento em
                                            {{ date('d/m/Y', strtotime($fatura['data_pago'])) }}</div>
                                    @else
                                        <h4 class="text-gray-900 fw-bolder">Nenhuma fatura ainda foi gerada</h4>
                                        <div class="fs-6 text-gray-700">Você ainda não realizou nenhum pagamento</div>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-7">
                                <h3 class="mb-2">Sua licença esta válida até
                                    {{ date('d/m/Y', strtotime(Auth::user()->vencimento)) }}</h3>
                                <p class="fs-6 text-gray-600 fw-bold mb-6 mb-lg-15">Enviaremos uma notificação 5 dias antes
                                    da expiração da sua assinatura</p>
                                <div class="fs-5 mb-2">
                                    <span class="text-gray-800 fw-bolder me-1">R$
                                        {{ moeda(Auth::user()->mensalidade) }}</span>
                                    <span class="text-gray-600 fw-bold">/Mês</span>
                                </div>
                                <div class="fs-6 text-gray-600 fw-bold">{{ $plano->nome }}</div>
                            </div>
                            <div class="col-lg-5">
                                <div class="d-flex text-muted fw-bolder fs-5 mb-3">
                                    <span class="flex-grow-1 text-gray-800">Usuários </span>
                                    <span class="text-gray-800">{{ count($users) }} de {{ Auth::user()->licencas }}
                                        utilizadas</span>
                                </div>
                                <div class="progress h-8px bg-light-primary mb-2">
                                    <div class="progress-bar bg-primary" role="progressbar"
                                        style="width: {{ 100 - DiferencaPorcentagem(3, 1) }}%"
                                        aria-valuenow="{{ 100 - DiferencaPorcentagem(3, 1) }}" aria-valuemin="0"
                                        aria-valuemax="100"></div>
                                </div>
                                <div class="fs-6 text-gray-600 fw-bold mb-10">
                                    {{ Auth::user()->licencas - count($users) }}
                                    Usuários restantes até que seu plano exija atualização</div>
                                <div class="d-flex justify-content-end pb-0 px-0">
                                    <a href="#" class="btn btn-danger btn-active-light-primary me-2">Cancelar assinatura</a>
                                    <button class="btn btn-primary" data-bs-toggle="modal"
                                        data-bs-target="#kt_modal_upgrade_plan">Mudar de Plano</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!--begin::CONTEÚDO DINÂMICO-->
            </div>
        </div>
    </div>

    <!--begin::Modal - Upgrade plan-->
    <div class="modal fade" id="kt_modal_upgrade_plan" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-xl">
            <div class="modal-content rounded">
                <div class="modal-header justify-content-end border-0 pb-0">
                    <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                        <span class="svg-icon svg-icon-1">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                                <rect opacity="0.5" x="6" y="17.3137" width="16" height="2" rx="1"
                                    transform="rotate(-45 6 17.3137)" fill="black" />
                                <rect x="7.41422" y="6" width="16" height="2" rx="1" transform="rotate(45 7.41422 6)"
                                    fill="black" />
                            </svg>
                        </span>>
                    </div>
                </div>
                <form action="{{ route('update.plano') }}" method="post" id="UpdatePlano">
                    @csrf

                    <input type="hidden" value="1" name="periodo" id="valorperido">

                    <div class="modal-body pt-0 pb-15 px-5 px-xl-20">
                        <div class="mb-13 text-center">
                            <h1 class="mb-3">Atualização de Plano</h1>
                        </div>

                        <div class="d-flex flex-column">
                            <div class="nav-group nav-group-outline mx-auto" data-kt-buttons="true">
                                <a href="#"
                                    class="btn btn-color-gray-400 btn-active btn-active-secondary px-6 py-3 me-2 active"
                                    onclick="javascript:Periodo(1)" data-id='1' data-kt-plan="month">Mensal</a>
                                <a href="#" class="btn btn-color-gray-400 btn-active btn-active-secondary px-6 py-3"
                                    onclick="javascript:Periodo(12)" data-kt-plan="annual">Anual</a>
                            </div>
                            <div class="row mt-10">
                                <div class="col-lg-6 mb-10 mb-lg-0">
                                    <div class="nav flex-column">
                                        @foreach ($planos as $plan)
                                            <div class="{{ $plan->id == Auth::user()->plano_id ? 'active' : '' }} nav-link btn btn-outline btn-outline-dashed btn-color-dark btn-active btn-active-primary d-flex flex-stack text-start p-6 mb-6"
                                                data-bs-toggle="tab" data-bs-target="#kt_upgrade_plan_{{ $plan->id }}">
                                                <div class="d-flex align-items-center me-2">
                                                    <div
                                                        class="form-check form-check-custom form-check-solid form-check-success me-6">
                                                        <input {{ $plan->id == Auth::user()->plano_id ? 'checked' : '' }}
                                                            value="{{ $plan->id }}" class="plano form-check-input"
                                                            type="radio" name="plano" />
                                                    </div>
                                                    <div class="flex-grow-1">
                                                        <h2 class="d-flex align-items-center fs-2 fw-bolder flex-wrap">
                                                            {{ $plan->nome }}</h2>
                                                    </div>
                                                </div>
                                                <div class="ms-5">
                                                    <span class="mb-2">R$</span>
                                                    <span class="fs-3x fw-bolder"
                                                        data-kt-plan-price-month="{{ moeda($plan->preco) }}"
                                                        data-kt-plan-price-annual="{{ moeda($plan->promo) }}">{{ moeda($plan->preco) }}</span>
                                                    <span class="fs-7 opacity-50">/<span
                                                            data-kt-element="period">Mês</span></span>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="tab-content rounded h-100 bg-light p-10">
                                        @foreach ($planos as $plan)
                                            <div class="tab-pane fade show" id="kt_upgrade_plan_{{ $plan->id }}">
                                                <div class="pb-5">
                                                    <h2 class="fw-bolder text-dark">O que está no plano de
                                                        {{ $plan->nome }}?</h2>
                                                    <div class="text-muted fw-bold">Escolha o ideal para atendimento</div>
                                                </div>
                                                <div class="pt-1">
                                                    <div class="d-flex align-items-center mb-7">
                                                        <span class="fw-bold fs-5 text-gray-700 flex-grow-1">Clientes
                                                            Ilimitados</span>
                                                        <span class="svg-icon svg-icon-1 svg-icon-success">
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                                viewBox="0 0 24 24" fill="none">
                                                                <rect opacity="0.3" x="2" y="2" width="20" height="20"
                                                                    rx="10" fill="black" />
                                                                <path
                                                                    d="M10.4343 12.4343L8.75 10.75C8.33579 10.3358 7.66421 10.3358 7.25 10.75C6.83579 11.1642 6.83579 11.8358 7.25 12.25L10.2929 15.2929C10.6834 15.6834 11.3166 15.6834 11.7071 15.2929L17.25 9.75C17.6642 9.33579 17.6642 8.66421 17.25 8.25C16.8358 7.83579 16.1642 7.83579 15.75 8.25L11.5657 12.4343C11.2533 12.7467 10.7467 12.7467 10.4343 12.4343Z"
                                                                    fill="black" />
                                                            </svg>
                                                        </span>
                                                    </div>
                                                    <div class="d-flex align-items-center mb-7">
                                                        <span class="fw-bold fs-5 text-gray-700 flex-grow-1">Animais
                                                            Ilimitados</span>
                                                        <span class="svg-icon svg-icon-1 svg-icon-success">
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                                viewBox="0 0 24 24" fill="none">
                                                                <rect opacity="0.3" x="2" y="2" width="20" height="20"
                                                                    rx="10" fill="black" />
                                                                <path
                                                                    d="M10.4343 12.4343L8.75 10.75C8.33579 10.3358 7.66421 10.3358 7.25 10.75C6.83579 11.1642 6.83579 11.8358 7.25 12.25L10.2929 15.2929C10.6834 15.6834 11.3166 15.6834 11.7071 15.2929L17.25 9.75C17.6642 9.33579 17.6642 8.66421 17.25 8.25C16.8358 7.83579 16.1642 7.83579 15.75 8.25L11.5657 12.4343C11.2533 12.7467 10.7467 12.7467 10.4343 12.4343Z"
                                                                    fill="black" />
                                                            </svg>
                                                        </span>
                                                    </div>
                                                    <div class="d-flex align-items-center mb-7">
                                                        <span class="fw-bold fs-5 text-gray-700 flex-grow-1">Atendimentos
                                                            Ilimitados</span>
                                                        <span class="svg-icon svg-icon-1 svg-icon-success">
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                                viewBox="0 0 24 24" fill="none">
                                                                <rect opacity="0.3" x="2" y="2" width="20" height="20"
                                                                    rx="10" fill="black" />
                                                                <path
                                                                    d="M10.4343 12.4343L8.75 10.75C8.33579 10.3358 7.66421 10.3358 7.25 10.75C6.83579 11.1642 6.83579 11.8358 7.25 12.25L10.2929 15.2929C10.6834 15.6834 11.3166 15.6834 11.7071 15.2929L17.25 9.75C17.6642 9.33579 17.6642 8.66421 17.25 8.25C16.8358 7.83579 16.1642 7.83579 15.75 8.25L11.5657 12.4343C11.2533 12.7467 10.7467 12.7467 10.4343 12.4343Z"
                                                                    fill="black" />
                                                            </svg>
                                                        </span>
                                                    </div>
                                                    <div class="d-flex align-items-center mb-7">
                                                        <span class="fw-bold fs-5 text-gray-700 flex-grow-1">Consulta com
                                                            ficha de Anamnese</span>
                                                        <span class="svg-icon svg-icon-1 svg-icon-success">
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                                viewBox="0 0 24 24" fill="none">
                                                                <rect opacity="0.3" x="2" y="2" width="20" height="20"
                                                                    rx="10" fill="black" />
                                                                <path
                                                                    d="M10.4343 12.4343L8.75 10.75C8.33579 10.3358 7.66421 10.3358 7.25 10.75C6.83579 11.1642 6.83579 11.8358 7.25 12.25L10.2929 15.2929C10.6834 15.6834 11.3166 15.6834 11.7071 15.2929L17.25 9.75C17.6642 9.33579 17.6642 8.66421 17.25 8.25C16.8358 7.83579 16.1642 7.83579 15.75 8.25L11.5657 12.4343C11.2533 12.7467 10.7467 12.7467 10.4343 12.4343Z"
                                                                    fill="black" />
                                                            </svg>
                                                        </span>
                                                    </div>
                                                    <div class="d-flex align-items-center mb-7">
                                                        <span class="fw-bold fs-5 text-gray-700 flex-grow-1">Consulta de
                                                            retorno</span>
                                                        <span class="svg-icon svg-icon-1 svg-icon-success">
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                                viewBox="0 0 24 24" fill="none">
                                                                <rect opacity="0.3" x="2" y="2" width="20" height="20"
                                                                    rx="10" fill="black" />
                                                                <path
                                                                    d="M10.4343 12.4343L8.75 10.75C8.33579 10.3358 7.66421 10.3358 7.25 10.75C6.83579 11.1642 6.83579 11.8358 7.25 12.25L10.2929 15.2929C10.6834 15.6834 11.3166 15.6834 11.7071 15.2929L17.25 9.75C17.6642 9.33579 17.6642 8.66421 17.25 8.25C16.8358 7.83579 16.1642 7.83579 15.75 8.25L11.5657 12.4343C11.2533 12.7467 10.7467 12.7467 10.4343 12.4343Z"
                                                                    fill="black" />
                                                            </svg>
                                                        </span>
                                                    </div>
                                                    <div class="d-flex align-items-center mb-7">
                                                        <span class="fw-bold fs-5 text-gray-700 flex-grow-1">Consulta
                                                            Oftalmológica</span>
                                                        <span class="svg-icon svg-icon-1 svg-icon-success">
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                                viewBox="0 0 24 24" fill="none">
                                                                <rect opacity="0.3" x="2" y="2" width="20" height="20"
                                                                    rx="10" fill="black" />
                                                                <path
                                                                    d="M10.4343 12.4343L8.75 10.75C8.33579 10.3358 7.66421 10.3358 7.25 10.75C6.83579 11.1642 6.83579 11.8358 7.25 12.25L10.2929 15.2929C10.6834 15.6834 11.3166 15.6834 11.7071 15.2929L17.25 9.75C17.6642 9.33579 17.6642 8.66421 17.25 8.25C16.8358 7.83579 16.1642 7.83579 15.75 8.25L11.5657 12.4343C11.2533 12.7467 10.7467 12.7467 10.4343 12.4343Z"
                                                                    fill="black" />
                                                            </svg>
                                                        </span>
                                                    </div>
                                                    <div class="d-flex align-items-center mb-7">
                                                        <span class="fw-bold fs-5 text-gray-700 flex-grow-1">Consulta
                                                            Dermatológica</span>
                                                        <span class="svg-icon svg-icon-1 svg-icon-success">
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                                viewBox="0 0 24 24" fill="none">
                                                                <rect opacity="0.3" x="2" y="2" width="20" height="20"
                                                                    rx="10" fill="black" />
                                                                <path
                                                                    d="M10.4343 12.4343L8.75 10.75C8.33579 10.3358 7.66421 10.3358 7.25 10.75C6.83579 11.1642 6.83579 11.8358 7.25 12.25L10.2929 15.2929C10.6834 15.6834 11.3166 15.6834 11.7071 15.2929L17.25 9.75C17.6642 9.33579 17.6642 8.66421 17.25 8.25C16.8358 7.83579 16.1642 7.83579 15.75 8.25L11.5657 12.4343C11.2533 12.7467 10.7467 12.7467 10.4343 12.4343Z"
                                                                    fill="black" />
                                                            </svg>
                                                        </span>
                                                    </div>
                                                    <div class="d-flex align-items-center mb-7">
                                                        <span class="fw-bold fs-5 text-gray-700 flex-grow-1">Vacinas</span>
                                                        <span class="svg-icon svg-icon-1 svg-icon-success">
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                                viewBox="0 0 24 24" fill="none">
                                                                <rect opacity="0.3" x="2" y="2" width="20" height="20"
                                                                    rx="10" fill="black" />
                                                                <path
                                                                    d="M10.4343 12.4343L8.75 10.75C8.33579 10.3358 7.66421 10.3358 7.25 10.75C6.83579 11.1642 6.83579 11.8358 7.25 12.25L10.2929 15.2929C10.6834 15.6834 11.3166 15.6834 11.7071 15.2929L17.25 9.75C17.6642 9.33579 17.6642 8.66421 17.25 8.25C16.8358 7.83579 16.1642 7.83579 15.75 8.25L11.5657 12.4343C11.2533 12.7467 10.7467 12.7467 10.4343 12.4343Z"
                                                                    fill="black" />
                                                            </svg>
                                                        </span>
                                                    </div>
                                                    <div class="d-flex align-items-center mb-7">
                                                        <span class="fw-bold fs-5 text-gray-700 flex-grow-1">Resultado de
                                                            Exames</span>
                                                        <span class="svg-icon svg-icon-1 svg-icon-success">
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                                viewBox="0 0 24 24" fill="none">
                                                                <rect opacity="0.3" x="2" y="2" width="20" height="20"
                                                                    rx="10" fill="black" />
                                                                <path
                                                                    d="M10.4343 12.4343L8.75 10.75C8.33579 10.3358 7.66421 10.3358 7.25 10.75C6.83579 11.1642 6.83579 11.8358 7.25 12.25L10.2929 15.2929C10.6834 15.6834 11.3166 15.6834 11.7071 15.2929L17.25 9.75C17.6642 9.33579 17.6642 8.66421 17.25 8.25C16.8358 7.83579 16.1642 7.83579 15.75 8.25L11.5657 12.4343C11.2533 12.7467 10.7467 12.7467 10.4343 12.4343Z"
                                                                    fill="black" />
                                                            </svg>
                                                        </span>
                                                    </div>
                                                    <div class="d-flex align-items-center mb-7">
                                                        <span class="fw-bold fs-5 text-gray-700 flex-grow-1">Relatório de
                                                            Adestramento</span>
                                                        <span class="svg-icon svg-icon-1 svg-icon-success">
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                                viewBox="0 0 24 24" fill="none">
                                                                <rect opacity="0.3" x="2" y="2" width="20" height="20"
                                                                    rx="10" fill="black" />
                                                                <path
                                                                    d="M10.4343 12.4343L8.75 10.75C8.33579 10.3358 7.66421 10.3358 7.25 10.75C6.83579 11.1642 6.83579 11.8358 7.25 12.25L10.2929 15.2929C10.6834 15.6834 11.3166 15.6834 11.7071 15.2929L17.25 9.75C17.6642 9.33579 17.6642 8.66421 17.25 8.25C16.8358 7.83579 16.1642 7.83579 15.75 8.25L11.5657 12.4343C11.2533 12.7467 10.7467 12.7467 10.4343 12.4343Z"
                                                                    fill="black" />
                                                            </svg>
                                                        </span>
                                                    </div>
                                                    <div class="d-flex align-items-center mb-7">
                                                        <span class="fw-bold fs-5 text-gray-700 flex-grow-1">Consultoria
                                                            Comportamental</span>
                                                        <span class="svg-icon svg-icon-1 svg-icon-success">
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                                viewBox="0 0 24 24" fill="none">
                                                                <rect opacity="0.3" x="2" y="2" width="20" height="20"
                                                                    rx="10" fill="black" />
                                                                <path
                                                                    d="M10.4343 12.4343L8.75 10.75C8.33579 10.3358 7.66421 10.3358 7.25 10.75C6.83579 11.1642 6.83579 11.8358 7.25 12.25L10.2929 15.2929C10.6834 15.6834 11.3166 15.6834 11.7071 15.2929L17.25 9.75C17.6642 9.33579 17.6642 8.66421 17.25 8.25C16.8358 7.83579 16.1642 7.83579 15.75 8.25L11.5657 12.4343C11.2533 12.7467 10.7467 12.7467 10.4343 12.4343Z"
                                                                    fill="black" />
                                                            </svg>
                                                        </span>
                                                    </div>
                                                    <div class="d-flex align-items-center mb-7">
                                                        <span
                                                            class="fw-bold fs-5 text-gray-700 flex-grow-1">Receitas</span>
                                                        <span class="svg-icon svg-icon-1 svg-icon-success">
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                                viewBox="0 0 24 24" fill="none">
                                                                <rect opacity="0.3" x="2" y="2" width="20" height="20"
                                                                    rx="10" fill="black" />
                                                                <path
                                                                    d="M10.4343 12.4343L8.75 10.75C8.33579 10.3358 7.66421 10.3358 7.25 10.75C6.83579 11.1642 6.83579 11.8358 7.25 12.25L10.2929 15.2929C10.6834 15.6834 11.3166 15.6834 11.7071 15.2929L17.25 9.75C17.6642 9.33579 17.6642 8.66421 17.25 8.25C16.8358 7.83579 16.1642 7.83579 15.75 8.25L11.5657 12.4343C11.2533 12.7467 10.7467 12.7467 10.4343 12.4343Z"
                                                                    fill="black" />
                                                            </svg>
                                                        </span>
                                                    </div>
                                                    <div class="d-flex align-items-center mb-7">
                                                        <span
                                                            class="fw-bold fs-5 text-gray-700 flex-grow-1">Orçamentos</span>
                                                        <span class="svg-icon svg-icon-1 svg-icon-success">
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                                viewBox="0 0 24 24" fill="none">
                                                                <rect opacity="0.3" x="2" y="2" width="20" height="20"
                                                                    rx="10" fill="black" />
                                                                <path
                                                                    d="M10.4343 12.4343L8.75 10.75C8.33579 10.3358 7.66421 10.3358 7.25 10.75C6.83579 11.1642 6.83579 11.8358 7.25 12.25L10.2929 15.2929C10.6834 15.6834 11.3166 15.6834 11.7071 15.2929L17.25 9.75C17.6642 9.33579 17.6642 8.66421 17.25 8.25C16.8358 7.83579 16.1642 7.83579 15.75 8.25L11.5657 12.4343C11.2533 12.7467 10.7467 12.7467 10.4343 12.4343Z"
                                                                    fill="black" />
                                                            </svg>
                                                        </span>
                                                    </div>
                                                    <div class="d-flex align-items-center mb-7">
                                                        <span class="fw-bold fs-5 text-gray-700 flex-grow-1">PDV</span>
                                                        <span class="svg-icon svg-icon-1 svg-icon-success">
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                                viewBox="0 0 24 24" fill="none">
                                                                <rect opacity="0.3" x="2" y="2" width="20" height="20"
                                                                    rx="10" fill="black" />
                                                                <path
                                                                    d="M10.4343 12.4343L8.75 10.75C8.33579 10.3358 7.66421 10.3358 7.25 10.75C6.83579 11.1642 6.83579 11.8358 7.25 12.25L10.2929 15.2929C10.6834 15.6834 11.3166 15.6834 11.7071 15.2929L17.25 9.75C17.6642 9.33579 17.6642 8.66421 17.25 8.25C16.8358 7.83579 16.1642 7.83579 15.75 8.25L11.5657 12.4343C11.2533 12.7467 10.7467 12.7467 10.4343 12.4343Z"
                                                                    fill="black" />
                                                            </svg>
                                                        </span>
                                                    </div>
                                                    <div class="d-flex align-items-center mb-7">
                                                        <span class="fw-bold fs-5 text-gray-700 flex-grow-1">Gerenciamento
                                                            de Estoque</span>
                                                        <span class="svg-icon svg-icon-1 svg-icon-success">
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                                viewBox="0 0 24 24" fill="none">
                                                                <rect opacity="0.3" x="2" y="2" width="20" height="20"
                                                                    rx="10" fill="black" />
                                                                <path
                                                                    d="M10.4343 12.4343L8.75 10.75C8.33579 10.3358 7.66421 10.3358 7.25 10.75C6.83579 11.1642 6.83579 11.8358 7.25 12.25L10.2929 15.2929C10.6834 15.6834 11.3166 15.6834 11.7071 15.2929L17.25 9.75C17.6642 9.33579 17.6642 8.66421 17.25 8.25C16.8358 7.83579 16.1642 7.83579 15.75 8.25L11.5657 12.4343C11.2533 12.7467 10.7467 12.7467 10.4343 12.4343Z"
                                                                    fill="black" />
                                                            </svg>
                                                        </span>
                                                    </div>
                                                    <div class="d-flex align-items-center mb-7">
                                                        <span class="fw-bold fs-5 text-gray-700 flex-grow-1">Produtos
                                                            Ilimitados</span>
                                                        <span class="svg-icon svg-icon-1 svg-icon-success">
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                                viewBox="0 0 24 24" fill="none">
                                                                <rect opacity="0.3" x="2" y="2" width="20" height="20"
                                                                    rx="10" fill="black" />
                                                                <path
                                                                    d="M10.4343 12.4343L8.75 10.75C8.33579 10.3358 7.66421 10.3358 7.25 10.75C6.83579 11.1642 6.83579 11.8358 7.25 12.25L10.2929 15.2929C10.6834 15.6834 11.3166 15.6834 11.7071 15.2929L17.25 9.75C17.6642 9.33579 17.6642 8.66421 17.25 8.25C16.8358 7.83579 16.1642 7.83579 15.75 8.25L11.5657 12.4343C11.2533 12.7467 10.7467 12.7467 10.4343 12.4343Z"
                                                                    fill="black" />
                                                            </svg>
                                                        </span>
                                                    </div>
                                                    <div class="d-flex align-items-center mb-7">
                                                        <span class="fw-bold fs-5 text-gray-700 flex-grow-1">Contas a
                                                            Pagar</span>
                                                        <span class="svg-icon svg-icon-1 svg-icon-success">
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                                viewBox="0 0 24 24" fill="none">
                                                                <rect opacity="0.3" x="2" y="2" width="20" height="20"
                                                                    rx="10" fill="black" />
                                                                <path
                                                                    d="M10.4343 12.4343L8.75 10.75C8.33579 10.3358 7.66421 10.3358 7.25 10.75C6.83579 11.1642 6.83579 11.8358 7.25 12.25L10.2929 15.2929C10.6834 15.6834 11.3166 15.6834 11.7071 15.2929L17.25 9.75C17.6642 9.33579 17.6642 8.66421 17.25 8.25C16.8358 7.83579 16.1642 7.83579 15.75 8.25L11.5657 12.4343C11.2533 12.7467 10.7467 12.7467 10.4343 12.4343Z"
                                                                    fill="black" />
                                                            </svg>
                                                        </span>
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="d-flex flex-center flex-row-fluid pt-12">
                            <button type="reset" class="btn btn-light me-3" data-bs-dismiss="modal">Fechar</button>
                            @if (Auth::user()->update_plano == 1)
                                <button type="reset" class="btn btn-danger me-3" data-bs-dismiss="modal">Indisponível</button>
                            @else
                                <button type="button" id="mudar" class="btn btn-primary">Mudar de Plano</button>
                            @endif
                        </div>
                </form>
            </div>
        </div>
    </div>
    </div>
@endsection
@section('css')
    <link rel="shortcut icon" href="{{ url('adm') }}/assets/media/logos/favicon.ico" />
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700" />
    <link href="{{ url('adm') }}/assets/plugins/custom/datatables/datatables.bundle.css" rel="stylesheet"
        type="text/css" />
    <link href="{{ url('adm') }}/assets/plugins/global/plugins.bundle.css" rel="stylesheet" type="text/css" />
    <link href="{{ url('adm') }}/assets/css/style.bundle.css" rel="stylesheet" type="text/css" />
@endsection

@section('js')
    <script src="{{ url('adm') }}/assets/plugins/global/plugins.bundle.js"></script>
    <script src="{{ url('adm') }}/assets/js/scripts.bundle.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/account/settings/deactivate-account.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/modals/two-factor-authentication.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/widgets.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/apps/chat/chat.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/modals/create-app.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/modals/upgrade-plan.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/intro.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/authentication/password-reset/new-password.js"></script>

    <script>
        $(document).ready(function() {
            $("#anual").hide();

            $("#mudar").on("click", function() {
                Swal.fire({
                    title: 'Atenção!',
                    text: 'Deseja realmente mudar seu plano?',
                    icon: 'info',
                    showCancelButton: true,
                    confirmButtonText: 'Sim',
                    cancelButtonText: 'Não',
                    customClass: {
                        confirmButton: 'btn btn-success',
                        cancelButton: 'btn btn-danger'
                    },
                }).then((result) => {
                    if (result.value) {
                        Swal.fire(
                            'Aguarde...',
                            'Seu novo plano esta sendo configurado',
                            'success'
                        )
                        document.getElementById("UpdatePlano").submit();
                    } else if (result.dismiss === Swal.DismissReason.cancel) {
                        Swal.fire(
                            'Cancelado',
                            'Solicitação cancelada',
                            'error'
                        )
                    }
                });
            });
        });

        function Periodo(id) {
            if (id == 1) {
                $("#valorperido").val(1);
            } else if (id == 12) {
                $("#valorperido").val(12);
            }
        }
    </script>
@endsection
