@extends('layouts.base')
@section('titulo', 'Home')
@section('content')
    <div class="content d-flex flex-column flex-column-fluid" id="kt_content">
        <div class="toolbar" id="kt_toolbar">
            <div id="kt_toolbar_container" class="container-fluid d-flex flex-stack">
                <div data-kt-swapper="true" data-kt-swapper-mode="prepend"
                    data-kt-swapper-parent="{default: '#kt_content_container', 'lg': '#kt_toolbar_container'}"
                    class="page-title d-flex align-items-center flex-wrap me-3 mb-5 mb-lg-0">
                    <h1 class="d-flex align-items-center text-dark fw-bolder fs-3 my-1">Dashboard</h1>
                </div>
            </div>
        </div>
        <div class="post d-flex flex-column-fluid" id="kt_post">
            <div id="kt_content_container" class="container-xxl">
                <div class="row g-5 g-xl-8">

                    <div class="col-xl-3">
                        <a href="{{ route('todos.anuncios',1) }}" target="_blank" class="card bg-dark hoverable card-xl-stretch mb-xl-8">
                             <div class="card-body">
                                <span class="svg-icon svg-icon-primary svg-icon-3x ms-n1">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <rect x="8" y="9" width="3" height="10" rx="1.5" fill="currentColor"></rect>
                                        <rect opacity="0.5" x="13" y="5" width="3" height="14" rx="1.5" fill="currentColor"></rect>
                                        <rect x="18" y="11" width="3" height="8" rx="1.5" fill="currentColor"></rect>
                                        <rect x="3" y="13" width="3" height="6" rx="1.5" fill="currentColor"></rect>
                                    </svg>
                                </span>
                                <div class="text-white-900 fw-bold fs-2 mb-2 mt-5">{{ count($anuncios->where('status',1)) }}</div>
                                <div class="fw-semibold text-gray-400">Anúncios Ativos</div>
                            </div>
                        </a>
                    </div>

                    <div class="col-xl-3">
                        <a href="{{ route('anuncios.patrocinados') }}" target="_blank" class="card bg-dark hoverable card-xl-stretch mb-xl-8">
                             <div class="card-body">
                                <span class="svg-icon svg-icon-primary svg-icon-3x ms-n1">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <rect x="8" y="9" width="3" height="10" rx="1.5" fill="currentColor"></rect>
                                        <rect opacity="0.5" x="13" y="5" width="3" height="14" rx="1.5" fill="currentColor"></rect>
                                        <rect x="18" y="11" width="3" height="8" rx="1.5" fill="currentColor"></rect>
                                        <rect x="3" y="13" width="3" height="6" rx="1.5" fill="currentColor"></rect>
                                    </svg>
                                </span>
                                <div class="text-white-900 fw-bold fs-2 mb-2 mt-5">{{ count($anuncios->where('thumb','!=','')->where('status',1)) }}</div>
                                <div class="fw-semibold text-gray-400">Anúncios Pagos</div>
                            </div>
                        </a>
                    </div>

                    <div class="col-xl-3">
                        <a href="{{ route('anuncios.free') }}" target="_blank" class="card bg-dark hoverable card-xl-stretch mb-xl-8">
                             <div class="card-body">
                                <span class="svg-icon svg-icon-primary svg-icon-3x ms-n1">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <rect x="8" y="9" width="3" height="10" rx="1.5" fill="currentColor"></rect>
                                        <rect opacity="0.5" x="13" y="5" width="3" height="14" rx="1.5" fill="currentColor"></rect>
                                        <rect x="18" y="11" width="3" height="8" rx="1.5" fill="currentColor"></rect>
                                        <rect x="3" y="13" width="3" height="6" rx="1.5" fill="currentColor"></rect>
                                    </svg>
                                </span>
                                <div class="text-white-900 fw-bold fs-2 mb-2 mt-5">{{ count($anuncios->where('thumb','')->where('status',1)) }}</div>
                                <div class="fw-semibold text-gray-400">Anúncios Grátis</div>
                            </div>
                        </a>
                    </div>

                    <div class="col-xl-3">
                        <a href="#" class="card bg-dark hoverable card-xl-stretch mb-xl-8">
                             <div class="card-body">
                                <span class="svg-icon svg-icon-primary svg-icon-3x ms-n1">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <rect x="8" y="9" width="3" height="10" rx="1.5" fill="currentColor"></rect>
                                        <rect opacity="0.5" x="13" y="5" width="3" height="14" rx="1.5" fill="currentColor"></rect>
                                        <rect x="18" y="11" width="3" height="8" rx="1.5" fill="currentColor"></rect>
                                        <rect x="3" y="13" width="3" height="6" rx="1.5" fill="currentColor"></rect>
                                    </svg>
                                </span>
                                <div class="text-white-900 fw-bold fs-2 mb-2 mt-5">{{ $anuncios->sum('visitas') }}</div>
                                <div class="fw-semibold text-gray-400">Anúncios Visitados</div>
                            </div>
                        </a>
                    </div>

                    <div class="col-xl-3">
                        <a href="#" class="card bg-dark hoverable card-xl-stretch mb-xl-8">
                             <div class="card-body">
                                <span class="svg-icon svg-icon-primary svg-icon-3x ms-n1">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <rect x="8" y="9" width="3" height="10" rx="1.5" fill="currentColor"></rect>
                                        <rect opacity="0.5" x="13" y="5" width="3" height="14" rx="1.5" fill="currentColor"></rect>
                                        <rect x="18" y="11" width="3" height="8" rx="1.5" fill="currentColor"></rect>
                                        <rect x="3" y="13" width="3" height="6" rx="1.5" fill="currentColor"></rect>
                                    </svg>
                                </span>
                                <div class="text-white-900 fw-bold fs-2 mb-2 mt-5">{{ $anuncios->sum('ligar') }}</div>
                                <div class="fw-semibold text-gray-400">Cliques ligar</div>
                            </div>
                        </a>
                    </div>

                    <div class="col-xl-3">
                        <a href="#" class="card bg-dark hoverable card-xl-stretch mb-xl-8">
                             <div class="card-body">
                                <span class="svg-icon svg-icon-primary svg-icon-3x ms-n1">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <rect x="8" y="9" width="3" height="10" rx="1.5" fill="currentColor"></rect>
                                        <rect opacity="0.5" x="13" y="5" width="3" height="14" rx="1.5" fill="currentColor"></rect>
                                        <rect x="18" y="11" width="3" height="8" rx="1.5" fill="currentColor"></rect>
                                        <rect x="3" y="13" width="3" height="6" rx="1.5" fill="currentColor"></rect>
                                    </svg>
                                </span>
                                <div class="text-white-900 fw-bold fs-2 mb-2 mt-5">{{ $anuncios->sum('conversar') }}</div>
                                <div class="fw-semibold text-gray-400">Clicks WhatsApp</div>
                            </div>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('css')
    <link href="{{ url('adm') }}/assets/plugins/custom/fullcalendar/fullcalendar.bundle.css" rel="stylesheet"
        type="text/css" />
    <link href="{{ url('adm') }}/assets/plugins/global/plugins.bundle.css" rel="stylesheet" type="text/css" />
    <link href="{{ url('adm') }}/assets/css/style.bundle.css" rel="stylesheet" type="text/css" />
    {{-- <link href="{{ url('adm') }}/assets/css/style.dark.bundle.css" rel="stylesheet" type="text/css" /> --}}
@endsection

@section('js')
    <script src="{{ url('adm') }}/assets/plugins/global/plugins.bundle.js"></script>
    <script src="{{ url('adm') }}/assets/js/scripts.bundle.js"></script>
    <script src="{{ url('adm') }}/assets/plugins/custom/fullcalendar/fullcalendar.bundle.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/widgets.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/apps/chat/chat.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/modals/create-app.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/modals/upgrade-plan.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/intro.js"></script>
@endsection
