@extends('layouts.base')
@section('titulo', 'Protocolos')
@section('content')
    <div class="content d-flex flex-column flex-column-fluid" id="kt_content">
        <div class="toolbar" id="kt_toolbar">
            <div id="kt_toolbar_container" class="container-fluid d-flex flex-stack">
                <div data-kt-swapper="true" data-kt-swapper-mode="prepend"
                    data-kt-swapper-parent="{default: '#kt_content_container', 'lg': '#kt_toolbar_container'}"
                    class="page-title d-flex align-items-center flex-wrap me-3 mb-5 mb-lg-0">
                    <h1 class="d-flex align-items-center text-dark fw-bolder fs-3 my-1">{{$cliente->name}}</h1>
                    <span class="h-20px border-gray-200 border-start mx-4"></span>
                    <ul class="breadcrumb breadcrumb-separatorless fw-bold fs-7 my-1">
                        <li class="breadcrumb-item text-muted">
                            <a href="{{ route('home') }}" class="text-muted text-hover-primary">Home</a>
                        </li>
                        <li class="breadcrumb-item"><span class="bullet bg-gray-200 w-5px h-2px"></span></li>
                        <li class="breadcrumb-item text-muted"><a href="{{ route('clientes.index') }}"
                                class="text-muted text-hover-primary">Listar Clientes</a></li>
                        <li class="breadcrumb-item"><span class="bullet bg-gray-200 w-5px h-2px"></span></li>
                        <li class="breadcrumb-item text-dark">{{ $cliente->name }}</li>
                    </ul>
                </div>
            </div>
        </div>
        <div class="post d-flex flex-column-fluid" id="kt_post">
            <div id="kt_content_container" class="container-xxl">
                @include('admin.clientes.base')

                <!--inicio::CONTEÚDO DINÂMICO-->
                <div class="card">

                    <div class="card-body pt-0">
                        <table class="table align-middle table-row-dashed fs-6 gy-5" id="kt_table_users">
                            <thead>
                                <tr class="text-start text-muted fw-bolder fs-7 text-uppercase gs-0">
                                    <th class="min-w-125px">Animal/Tutor</th>
                                    <th class="min-w-125px">Prot.</th>
                                    <th class="min-w-125px">Vet.</th>
                                    <th class="min-w-125px">Próxima Aplicação</th>
                                    <th class="text-end min-w-100px">Ações</th>
                                </tr>
                            </thead>
                            <tbody class="text-gray-600 fw-bold">
                                @foreach ($protocolos as $vacina)
                                    <tr>
                                        <td class="d-flex align-items-center">
                                            <div class="symbol symbol-circle symbol-50px overflow-hidden me-3">
                                                <a href="view.html">
                                                    <div class="symbol-label">
                                                        <img src="{{ url("storage/{$vacina->animal->image}") }}"
                                                            alt="Emma Smith" class="w-100" />
                                                    </div>
                                                </a>
                                            </div>
                                            <div class="d-flex flex-column">
                                                <a href="view.html" class="text-gray-800 text-hover-primary mb-1">
                                                    {{ $vacina->animal->nome }}
                                                </a>
                                                <span>{{$vacina->tutor->name}}</span>
                                            </div>
                                        </td>
                                        <td> {{ $vacina->tipo->tipo }} - {{ $vacina->protocolo->protocolo }}</td>
                                        <td>
                                            <img src="{{ url('adm') }}/assets/images/doctor.png" width="20">
                                            {{ $vacina->user->sexo }}
                                            {{ $vacina->user->name }}
                                            {{ $vacina->user->cmrv }}
                                        </td>
                                        <td>
                                            <span class="badge badge-light-danger">
                                                {{ $diaSemana[date('w', strtotime($dose->programacao))] }},
                                                {{ date('d', strtotime($dose->programacao)) }} de
                                                {{ $mes[date('m', strtotime($dose->programacao))] }} de
                                                {{ date('Y', strtotime($dose->programacao)) }}
                                            </span>
                                        </td>
                                        <td class="text-end">
                                            <a href="{{ route('protocolo.vacinacao.cliente', $vacina->id) }}"
                                                class="btn btn-sm btn-light btn-active-light-primary">Gerenciar
                                                Protocolo</a>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
                <!--end::CONTEÚDO DINÂMICO-->
            </div>
        </div>
    </div>
@endsection
@section('css')
    <link rel="shortcut icon" href="{{ url('adm') }}/assets/media/logos/favicon.ico" />
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700" />
    <link href="{{ url('adm') }}/assets/plugins/custom/datatables/datatables.bundle.css" rel="stylesheet"
        type="text/css" />
    <link href="{{ url('adm') }}/assets/plugins/global/plugins.bundle.css" rel="stylesheet" type="text/css" />
    <link href="{{ url('adm') }}/assets/css/style.bundle.css" rel="stylesheet" type="text/css" />
@endsection

@section('js')

    <script>
        $(document).ready(function() {
            $("#self").on("change", function() {
                document.getElementById("formSelf").submit();
            });
            Inputmask({
                "mask": "[9][.][9][.][9][.][9][9][9]KG"
            }).mask("#peso");
            Inputmask({
                "mask": "99/99/9999"
            }).mask("#nascimento");

            $("#especie").change(function() {
                const url = $("#personForm").attr("data-especie-url");
                especie = $(this).val();
                $.ajax({
                    url: url,
                    data: {
                        'especie': especie
                    },
                    success: function(data) {
                        $("#raca").html(data);
                    }
                });
            });
        });
    </script>
    <script src="{{ url('adm') }}/assets/plugins/global/plugins.bundle.js"></script>
    <script src="{{ url('adm') }}/assets/js/scripts.bundle.js"></script>
    <!--begin::Page Vendors Javascript(used by this page)-->
    <script src="{{ url('adm') }}/assets/plugins/custom/datatables/datatables.bundle.js"></script>
    <!--end::Page Vendors Javascript-->
    <!--begin::Page Custom Javascript(used by this page)-->
    <script src="{{ url('adm') }}/assets/js/custom/pages/projects/settings/settings.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/apps/user-management/users/list/table.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/apps/user-management/users/list/export-users.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/apps/user-management/users/list/add.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/widgets.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/apps/chat/chat.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/modals/create-app.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/modals/upgrade-plan.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/intro.js"></script>
    <!--end::Page Custom Javascript-->
@endsection
