@extends('layouts.base')
@section('titulo', 'Clientes')
@section('content')
    <div class="content d-flex flex-column flex-column-fluid" id="kt_content">
        <div class="toolbar" id="kt_toolbar">
            <div id="kt_toolbar_container" class="container-fluid d-flex flex-stack">
                <div data-kt-swapper="true" data-kt-swapper-mode="prepend"
                    data-kt-swapper-parent="{default: '#kt_content_container', 'lg': '#kt_toolbar_container'}"
                    class="page-title d-flex align-items-center flex-wrap me-3 mb-5 mb-lg-0">
                    <h1 class="d-flex align-items-center text-dark fw-bolder fs-3 my-1">Clientes Cadastrados({{ $TotalClientes }})</h1>
                </div>
                <div class="d-flex align-items-center py-1">
                    <div class="me-4">
                        <a href="{{route('clientes.index')}}" class="btn btn-sm btn-primary">Listar Clientes</a>
                    </div>
                </div>
            </div>
        </div>

        <div class="post d-flex flex-column-fluid" id="kt_post">
            <!--begin::Container-->
            <div id="kt_content_container" class="container-xxl">
                <!--begin::Card-->
                <div class="card">
                    <!--begin::Card header-->
                    <div class="card-header border-0 pt-6">
                        <!--begin::Card title-->
                        <div class="card-title">
                            <!--begin::Search-->
                            <div class="d-flex align-items-center position-relative my-1">
                                <!--begin::Svg Icon | path: icons/duotune/general/gen021.svg-->
                                <span class="svg-icon svg-icon-1 position-absolute ms-6">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                                        <rect opacity="0.5" x="17.0365" y="15.1223" width="8.15546" height="2" rx="1" transform="rotate(45 17.0365 15.1223)" fill="black"></rect>
                                        <path d="M11 19C6.55556 19 3 15.4444 3 11C3 6.55556 6.55556 3 11 3C15.4444 3 19 6.55556 19 11C19 15.4444 15.4444 19 11 19ZM11 5C7.53333 5 5 7.53333 5 11C5 14.4667 7.53333 17 11 17C14.4667 17 17 14.4667 17 11C17 7.53333 14.4667 5 11 5Z" fill="black"></path>
                                    </svg>
                                </span>
                                <!--end::Svg Icon-->
                                <input type="text" data-kt-user-table-filter="search" class="form-control form-control-solid w-250px ps-14" placeholder="Busca rápida">
                            </div>
                        </div>
                        <div class="card-toolbar">
                            <div class="d-flex justify-content-end" data-kt-user-table-toolbar="base">
                                <a href="{{ route('clientes.create') }}" class="btn btn-primary btn-sm">
                                    <span class="svg-icon svg-icon-2">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                            fill="none">
                                            <rect opacity="0.5" x="11.364" y="20.364" width="16" height="2" rx="1"
                                                transform="rotate(-90 11.364 20.364)" fill="black"></rect>
                                            <rect x="4.36396" y="11.364" width="16" height="2" rx="1" fill="black"></rect>
                                        </svg>
                                    </span>
                                    Novo Cliente
                                </a>
                            </div>
                            <div class="d-flex justify-content-end align-items-center d-none"
                                data-kt-user-table-toolbar="selected">
                                <div class="fw-bolder me-5">
                                    <span class="me-2" data-kt-user-table-select="selected_count"></span>Selected
                                </div>
                                <button type="button" class="btn btn-danger"
                                    data-kt-user-table-select="delete_selected">Excluir Selecionados</button>
                            </div>
                        </div>
                        <!--end::Card toolbar-->
                    </div>
                    <!--end::Card header-->
                    <!--begin::Card body-->
                    <div class="card-body pt-0">
                        <!--begin::Table-->
                        <div id="kt_table_users_wrapper" class="dataTables_wrapper dt-bootstrap4 no-footer">
                            <div class="table-responsive">
                                <table class="table align-middle table-row-dashed fs-6 gy-5 dataTable no-footer"
                                    id="kt_table_users">
                                    <!--begin::Table head-->
                                    <thead>
                                        <!--begin::Table row-->
                                        <tr class="text-start text-muted fw-bolder fs-7 text-uppercase gs-0">
                                            <th class="w-10px pe-2 sorting_disabled" rowspan="1" colspan="1"
                                                style="width: 29.25px;" aria-label="">
                                                <div
                                                    class="form-check form-check-sm form-check-custom form-check-solid me-3">
                                                    <input class="form-check-input" type="checkbox" data-kt-check="true"
                                                        data-kt-check-target="#kt_table_users .form-check-input" value="1">
                                                </div>
                                            </th>
                                            <th class="min-w-125px sorting" tabindex="0" aria-controls="kt_table_users"
                                                rowspan="1" colspan="1" style="width: 316.067px;"
                                                aria-label="User: activate to sort column ascending">
                                                Nome
                                            </th>
                                            <th class="min-w-125px sorting" tabindex="0" aria-controls="kt_table_users"
                                                rowspan="1" colspan="1" style="width: 156px;"
                                                aria-label="Role: activate to sort column ascending">Celular</th>
                                            <th class="min-w-125px sorting" tabindex="0" aria-controls="kt_table_users"
                                                rowspan="1" colspan="1" style="width: 156px;"
                                                aria-label="Last login: activate to sort column ascending">E-mail</th>
                                            <th class="text-end min-w-100px sorting_disabled" rowspan="1" colspan="1"
                                                style="width: 125.25px;" aria-label="Actions">Ações</th>
                                        </tr>
                                        <!--end::Table row-->
                                    </thead>

                                    <tbody class="text-gray-600 fw-bold">
                                        @foreach ($clientes as $cliente)
                                            <tr class="odd">
                                                <td>
                                                    <div
                                                        class="form-check form-check-sm form-check-custom form-check-solid">
                                                        <input class="form-check-input" type="checkbox" value="1">
                                                    </div>
                                                </td>
                                                <td class="d-flex align-items-center">
                                                    <div class="symbol symbol-circle symbol-50px overflow-hidden me-3">
                                                        <a href="">
                                                            <div class="symbol-label">
                                                                <img src="{{!empty($cliente->foto) ? url("storage/{$cliente->foto}") : url('admin/assets/media/user.png') }}" alt="{{ $cliente->name }}" class="w-100">
                                                            </div>
                                                        </a>
                                                    </div>
                                                    <div class="d-flex flex-column">
                                                        <a href=""
                                                            class="text-gray-800 text-hover-primary mb-1">{{ $cliente->name }}</a>
                                                    </div>
                                                </td>
                                                <td>{{ $cliente->celular }}</td>
                                                <td>{{ $cliente->email }}</td>
                                                <td class="text-end">
                                                    <a href="{{route('cliente.perfil',$cliente->id)}}" class="btn btn-primary btn-active-light-primary btn-sm"
                                                        data-kt-menu-trigger="click"
                                                        data-kt-menu-placement="bottom-end">
                                                        Abrir Perfil
                                                    </a>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('css')
    <link rel="shortcut icon" href="{{url('adm')}}/assets/media/logos/favicon.ico" />
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700" />
    <link href="{{url('adm')}}/assets/plugins/custom/datatables/datatables.bundle.css" rel="stylesheet" type="text/css" />
    <link href="{{url('adm')}}/assets/plugins/global/plugins.bundle.css" rel="stylesheet" type="text/css" />
    <link href="{{url('adm')}}/assets/css/style.bundle.css" rel="stylesheet" type="text/css" />
@endsection

@section('js')

    <script src="{{url('adm')}}/assets/plugins/global/plugins.bundle.js"></script>
    <script src="{{url('adm')}}/assets/js/scripts.bundle.js"></script>
    <!--begin::Page Vendors Javascript(used by this page)-->
    <script src="{{url('adm')}}/assets/plugins/custom/datatables/datatables.bundle.js"></script>
    <!--end::Page Vendors Javascript-->
    <!--begin::Page Custom Javascript(used by this page)-->
    <script src="{{url('adm')}}/assets/js/custom/apps/user-management/users/list/table.js"></script>
    <script src="{{url('adm')}}/assets/js/custom/apps/user-management/users/list/export-users.js"></script>
    <script src="{{url('adm')}}/assets/js/custom/apps/user-management/users/list/add.js"></script>
    <script src="{{url('adm')}}/assets/js/custom/widgets.js"></script>
    <script src="{{url('adm')}}/assets/js/custom/apps/chat/chat.js"></script>
    <script src="{{url('adm')}}/assets/js/custom/modals/create-app.js"></script>
    <script src="{{url('adm')}}/assets/js/custom/modals/upgrade-plan.js"></script>
    <script src="{{url('adm')}}/assets/js/custom/intro.js"></script>
    <!--end::Page Custom Javascript-->
@endsection
