@extends('layouts.base')
@section('titulo', 'Atendimentos')
@section('content')
    <div class="content d-flex flex-column flex-column-fluid" id="kt_content">
        <div class="toolbar" id="kt_toolbar">
            <div id="kt_toolbar_container" class="container-fluid d-flex flex-stack">
                <div data-kt-swapper="true" data-kt-swapper-mode="prepend"
                    data-kt-swapper-parent="{default: '#kt_content_container', 'lg': '#kt_toolbar_container'}"
                    class="page-title d-flex align-items-center flex-wrap me-3 mb-5 mb-lg-0">
                    <h1 class="d-flex align-items-center text-dark fw-bolder fs-3 my-1">{{$cliente->name}}</h1>
                    <span class="h-20px border-gray-200 border-start mx-4"></span>
                    <ul class="breadcrumb breadcrumb-separatorless fw-bold fs-7 my-1">
                        <li class="breadcrumb-item text-muted">
                            <a href="{{ route('home') }}" class="text-muted text-hover-primary">Home</a>
                        </li>
                        <li class="breadcrumb-item"><span class="bullet bg-gray-200 w-5px h-2px"></span></li>
                        <li class="breadcrumb-item text-muted"><a href="{{ route('clientes.index') }}"
                                class="text-muted text-hover-primary">Listar Clientes</a></li>
                        <li class="breadcrumb-item"><span class="bullet bg-gray-200 w-5px h-2px"></span></li>
                        <li class="breadcrumb-item text-dark">{{ $cliente->name }}</li>
                    </ul>
                </div>
            </div>
        </div>
        <div class="post d-flex flex-column-fluid" id="kt_post">
            <div id="kt_content_container" class="container-xxl">
                @include('admin.clientes.base')
                <!--begin::CONTEÚDO DINÂMICO-->
                <div class="card">
                    <!--begin::Card head-->
                    <div class="card-header card-header-stretch">
                        <!--begin::Title-->
                        <div class="card-title d-flex align-items-center">
                            <!--begin::Svg Icon | path: icons/duotune/general/gen014.svg-->
                            <span class="svg-icon svg-icon-1 svg-icon-primary me-3 lh-0">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M20 19.725V18.725C20 18.125 19.6 17.725 19 17.725H5C4.4 17.725 4 18.125 4 18.725V19.725H3C2.4 19.725 2 20.125 2 20.725V21.725H22V20.725C22 20.125 21.6 19.725 21 19.725H20Z" fill="black"/>
                                    <path opacity="0.3" d="M22 6.725V7.725C22 8.325 21.6 8.725 21 8.725H18C18.6 8.725 19 9.125 19 9.725C19 10.325 18.6 10.725 18 10.725V15.725C18.6 15.725 19 16.125 19 16.725V17.725H15V16.725C15 16.125 15.4 15.725 16 15.725V10.725C15.4 10.725 15 10.325 15 9.725C15 9.125 15.4 8.725 16 8.725H13C13.6 8.725 14 9.125 14 9.725C14 10.325 13.6 10.725 13 10.725V15.725C13.6 15.725 14 16.125 14 16.725V17.725H10V16.725C10 16.125 10.4 15.725 11 15.725V10.725C10.4 10.725 10 10.325 10 9.725C10 9.125 10.4 8.725 11 8.725H8C8.6 8.725 9 9.125 9 9.725C9 10.325 8.6 10.725 8 10.725V15.725C8.6 15.725 9 16.125 9 16.725V17.725H5V16.725C5 16.125 5.4 15.725 6 15.725V10.725C5.4 10.725 5 10.325 5 9.725C5 9.125 5.4 8.725 6 8.725H3C2.4 8.725 2 8.325 2 7.725V6.725L11 2.225C11.6 1.925 12.4 1.925 13.1 2.225L22 6.725ZM12 3.725C11.2 3.725 10.5 4.425 10.5 5.225C10.5 6.025 11.2 6.725 12 6.725C12.8 6.725 13.5 6.025 13.5 5.225C13.5 4.425 12.8 3.725 12 3.725Z" fill="black"/>
                                </svg>
                            </span>
                            <!--end::Svg Icon-->
                            <h3 class="fw-bolder m-0 text-gray-800">Atendimentos</h3>
                        </div>
                        <!--end::Title-->
                        <!--begin::Toolbar-->
                        <div class="card-toolbar m-0">
                            <!--begin::Tab nav-->
                            <ul class="nav nav-tabs nav-line-tabs nav-stretch fs-6 border-0 fw-bolder" role="tablist">
                                <li class="nav-item" role="presentation">
                                    <a id="kt_activity_today_tab" class="nav-link justify-content-center text-active-gray-800 active" data-bs-toggle="tab" role="tab" href="#kt_activity_today">Today</a>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <a id="kt_activity_week_tab" class="nav-link justify-content-center text-active-gray-800" data-bs-toggle="tab" role="tab" href="#kt_activity_week">Week</a>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <a id="kt_activity_month_tab" class="nav-link justify-content-center text-active-gray-800" data-bs-toggle="tab" role="tab" href="#kt_activity_month">Month</a>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <a id="kt_activity_year_tab" class="nav-link justify-content-center text-active-gray-800 text-hover-gray-800" data-bs-toggle="tab" role="tab" href="#kt_activity_year">2021</a>
                                </li>
                            </ul>
                            <!--end::Tab nav-->
                        </div>
                        <!--end::Toolbar-->
                    </div>
                    <!--end::Card head-->
                    <!--begin::Card body-->
                    <div class="card-body">
                        <table
                        class="table align-middle table-row-dashed fs-6 gy-5 dataTable no-footer"
                        id="kt_table_users">
                        <thead>
                            <tr class="text-start text-muted fw-bolder fs-7 text-uppercase gs-0">
                                <th class="w-10px pe-2 sorting_disabled" rowspan="1" colspan="1"
                                    style="width: 29.25px;" aria-label="">
                                    <div class="form-check form-check-sm form-check-custom form-check-solid me-3">
                                        <input class="form-check-input" type="checkbox" data-kt-check="true" data-kt-check-target="#kt_table_users .form-check-input" value="1">
                                    </div>
                                </th>
                                <th class="min-w-125px sorting" tabindex="0"
                                    aria-controls="kt_table_users" rowspan="1" colspan="1"
                                    style="width: 316.067px;"
                                    aria-label="User: activate to sort column ascending">
                                    Nome
                                </th>
                                <th class="min-w-125px sorting" tabindex="0"
                                    aria-controls="kt_table_users" rowspan="1" colspan="1"
                                    style="width: 156px;"
                                    aria-label="Role: activate to sort column ascending">
                                    Raça
                                </th>
                                <th class="min-w-125px sorting" tabindex="0"
                                    aria-controls="kt_table_users" rowspan="1" colspan="1"
                                    style="width: 156px;"
                                    aria-label="Last login: activate to sort column ascending">
                                    Spécie</th>
                                <th class="text-end min-w-100px sorting_disabled" rowspan="1"
                                    colspan="1" style="width: 125.25px;" aria-label="Actions">
                                    Ações
                                </th>
                            </tr>
                        </thead>

                        <tbody class="text-gray-600 fw-bold">
                            @foreach ($animais as $animal)
                                <tr class="odd">
                                    <td>
                                        <div
                                            class="form-check form-check-sm form-check-custom form-check-solid">
                                            <input class="form-check-input" type="checkbox"
                                                value="1">
                                        </div>
                                    </td>
                                    <td class="d-flex align-items-center">
                                        <div
                                            class="symbol symbol-circle symbol-50px overflow-hidden me-3">
                                            <a href="">
                                                <div class="symbol-label">
                                                    <img src="{{ !empty($animal->image) ? url("storage/{$animal->image}") : url('admin/assets/images/dog.png') }}"
                                                        alt="{{ $animal->nome }}"
                                                        class="w-100">
                                                </div>
                                            </a>
                                        </div>
                                        <div class="d-flex flex-column">
                                            <a href=""  class="text-gray-800 text-hover-primary mb-1">{{ $animal->nome }}</a>
                                        </div>
                                    </td>
                                    <td>{{$animal->especie_nome}}</td>
                                    <td>{{$animal->raca_nome}}</td>
                                    <td class="text-end">
                                        <a href="{{ route('animal.perfil', $animal->id) }}"
                                            class="btn btn-primary btn-active-light-primary btn-sm"
                                            data-kt-menu-trigger="click"
                                            data-kt-menu-placement="bottom-end">
                                            Perfil
                                        </a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                    </div>
                    <!--end::Card body-->
                </div>
                <!--end::CONTEÚDO DINÂMICO-->
            </div>
        </div>
    </div>
@endsection
@section('css')
    <link rel="shortcut icon" href="{{ url('adm') }}/assets/media/logos/favicon.ico" />
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700" />
    <link href="{{ url('adm') }}/assets/plugins/custom/datatables/datatables.bundle.css" rel="stylesheet"
        type="text/css" />
    <link href="{{ url('adm') }}/assets/plugins/global/plugins.bundle.css" rel="stylesheet" type="text/css" />
    <link href="{{ url('adm') }}/assets/css/style.bundle.css" rel="stylesheet" type="text/css" />
@endsection

@section('js')

    <script>
        $(document).ready(function() {
            $("#self").on("change", function() {
                document.getElementById("formSelf").submit();
            });
            Inputmask({
                "mask": "[9][.][9][.][9][.][9][9][9]KG"
            }).mask("#peso");
            Inputmask({
                "mask": "99/99/9999"
            }).mask("#nascimento");

            $("#especie").change(function() {
                const url = $("#personForm").attr("data-especie-url");
                especie = $(this).val();
                $.ajax({
                    url: url,
                    data: {
                        'especie': especie
                    },
                    success: function(data) {
                        $("#raca").html(data);
                    }
                });
            });
        });
    </script>
    <script src="{{ url('adm') }}/assets/plugins/global/plugins.bundle.js"></script>
    <script src="{{ url('adm') }}/assets/js/scripts.bundle.js"></script>
    <!--begin::Page Vendors Javascript(used by this page)-->
    <script src="{{ url('adm') }}/assets/plugins/custom/datatables/datatables.bundle.js"></script>
    <!--end::Page Vendors Javascript-->
    <!--begin::Page Custom Javascript(used by this page)-->
    <script src="{{ url('adm') }}/assets/js/custom/pages/projects/settings/settings.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/apps/user-management/users/list/table.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/apps/user-management/users/list/export-users.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/apps/user-management/users/list/add.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/widgets.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/apps/chat/chat.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/modals/create-app.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/modals/upgrade-plan.js"></script>
    <script src="{{ url('adm') }}/assets/js/custom/intro.js"></script>
    <!--end::Page Custom Javascript-->
@endsection
