@extends('layouts.base')
@section('titulo', 'Gerenciamento de Categorias')
@section('content')
    <div class="content d-flex flex-column flex-column-fluid" id="kt_content">
        <div class="toolbar" id="kt_toolbar">
            <div id="kt_toolbar_container" class="container-fluid d-flex flex-stack">
                <div data-kt-swapper="true" data-kt-swapper-mode="prepend"
                    data-kt-swapper-parent="{default: '#kt_content_container', 'lg': '#kt_toolbar_container'}"
                    class="page-title d-flex align-items-center flex-wrap me-3 mb-5 mb-lg-0">
                    <h1 class="d-flex align-items-center text-dark fw-bolder fs-3 my-1">Gerenciamento de Categorias</h1>
                </div>
                <div class="d-flex align-items-center py-1">

                </div>
            </div> 
        </div>
        <div class="post d-flex flex-column-fluid" id="kt_post">
            <div id="kt_content_container" class="container-xxl">
                @if (session('success'))
                    <div class="alert alert-success d-flex align-items-center p-5 mb-10">
                        <span class="svg-icon svg-icon-2hx svg-icon-success me-4">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                                <path opacity="0.3"
                                    d="M20.5543 4.37824L12.1798 2.02473C12.0626 1.99176 11.9376 1.99176 11.8203 2.02473L3.44572 4.37824C3.18118 4.45258 3 4.6807 3 4.93945V13.569C3 14.6914 3.48509 15.8404 4.4417 16.984C5.17231 17.8575 6.18314 18.7345 7.446 19.5909C9.56752 21.0295 11.6566 21.912 11.7445 21.9488C11.8258 21.9829 11.9129 22 12.0001 22C12.0872 22 12.1744 21.983 12.2557 21.9488C12.3435 21.912 14.4326 21.0295 16.5541 19.5909C17.8169 18.7345 18.8277 17.8575 19.5584 16.984C20.515 15.8404 21 14.6914 21 13.569V4.93945C21 4.6807 20.8189 4.45258 20.5543 4.37824Z"
                                    fill="black"></path>
                                <path
                                    d="M10.5606 11.3042L9.57283 10.3018C9.28174 10.0065 8.80522 10.0065 8.51412 10.3018C8.22897 10.5912 8.22897 11.0559 8.51412 11.3452L10.4182 13.2773C10.8099 13.6747 11.451 13.6747 11.8427 13.2773L15.4859 9.58051C15.771 9.29117 15.771 8.82648 15.4859 8.53714C15.1948 8.24176 14.7183 8.24176 14.4272 8.53714L11.7002 11.3042C11.3869 11.6221 10.874 11.6221 10.5606 11.3042Z"
                                    fill="black"></path>
                            </svg>
                        </span>
                        <div class="d-flex flex-column">
                            <h4 class="mb-1 text-success">{{ session('success') }}</h4>
                        </div>
                    </div>
                @endif
                @if (session('error'))
                    <div class="alert alert-danger d-flex align-items-center p-5 mb-10">
                        <span class="svg-icon svg-icon-2hx svg-icon-danger me-4">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                                <path opacity="0.3"
                                    d="M20.5543 4.37824L12.1798 2.02473C12.0626 1.99176 11.9376 1.99176 11.8203 2.02473L3.44572 4.37824C3.18118 4.45258 3 4.6807 3 4.93945V13.569C3 14.6914 3.48509 15.8404 4.4417 16.984C5.17231 17.8575 6.18314 18.7345 7.446 19.5909C9.56752 21.0295 11.6566 21.912 11.7445 21.9488C11.8258 21.9829 11.9129 22 12.0001 22C12.0872 22 12.1744 21.983 12.2557 21.9488C12.3435 21.912 14.4326 21.0295 16.5541 19.5909C17.8169 18.7345 18.8277 17.8575 19.5584 16.984C20.515 15.8404 21 14.6914 21 13.569V4.93945C21 4.6807 20.8189 4.45258 20.5543 4.37824Z"
                                    fill="black"></path>
                                <path
                                    d="M10.5606 11.3042L9.57283 10.3018C9.28174 10.0065 8.80522 10.0065 8.51412 10.3018C8.22897 10.5912 8.22897 11.0559 8.51412 11.3452L10.4182 13.2773C10.8099 13.6747 11.451 13.6747 11.8427 13.2773L15.4859 9.58051C15.771 9.29117 15.771 8.82648 15.4859 8.53714C15.1948 8.24176 14.7183 8.24176 14.4272 8.53714L11.7002 11.3042C11.3869 11.6221 10.874 11.6221 10.5606 11.3042Z"
                                    fill="black"></path>
                            </svg>
                        </span>
                        <div class="d-flex flex-column">
                            <h4 class="mb-1 text-danger">{{ session('error') }}</h4>
                        </div>
                    </div>
                @endif
                <div class="card">
                    <div class="card-body p-lg-17">
                        <div class="d-flex flex-column flex-lg-row mb-17">
                             <div class="flex-lg-row-fluid me-0 me-lg-20">
                                <a href="#" data-bs-toggle="modal" data-bs-target="#nova_categoria" class="btn btn-sm btn-primary mt-5">Nova Categoria</a>
                                <br><br>
                                @foreach ($level1 as $l1)
                                <div class="mb-17" id="hide_level1{{ $l1->id }}">
                                   <div class="m-0">
                                   
                                        <h4 class="fs-1 text-gray-800 w-bolder mb-6">
                                            {{ $l1->level1 }}<br>
                                            <a href="{{ route('anuncios.categoria',$l1->id) }}" target="_blank"><span class="badge badge-light-warning">Anúncios desta categoria</span></a>
                                            <span onclick="javascript:Editar({{ $l1->id }})" class="badge badge-light-success">Editar</span>
                                            <span class="badge badge-light-danger" onclick="javascript:DellLevel1({{ $l1->id }})">Excluir</span></h4>
                                            </h4>
                                    </div>
                                    @if(!empty($l1->level2))
                                    @foreach ($l1->level2 as $cat_level2)
                                    <div class="m-0" id="hide_level2{{ $cat_level2->id }}">
                                        <div class="d-flex align-items-center collapsible py-3 toggle mb-0 collapsed" data-bs-toggle="collapse" data-bs-target="#level2{{ $cat_level2->id }}" aria-expanded="false">
                                            <div class="btn btn-sm btn-icon mw-20px btn-active-color-primary me-5">
                                                <span class="svg-icon toggle-on svg-icon-primary svg-icon-1">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                                                        <rect opacity="0.3" x="2" y="2" width="20" height="20" rx="5" fill="black"></rect>
                                                        <rect x="6.0104" y="10.9247" width="12" height="2" rx="1" fill="black"></rect>
                                                    </svg>
                                                </span>
                                                <span class="svg-icon toggle-off svg-icon-1">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                                                        <rect opacity="0.3" x="2" y="2" width="20" height="20" rx="5" fill="black"></rect>
                                                        <rect x="10.8891" y="17.8033" width="12" height="2" rx="1" transform="rotate(-90 10.8891 17.8033)" fill="black"></rect>
                                                        <rect x="6.01041" y="10.9247" width="12" height="2" rx="1" fill="black"></rect>
                                                    </svg>
                                                </span>
                                            </div>
                                            <h4 class="text-gray-700 fw-bolder cursor-pointer mb-0">{{ $cat_level2->titulo }}
                                                <a href="{{ route('anuncios.categoria.sub',[$cat_level2->categoria_id,$cat_level2->id]) }}" target="_blank"><span class="badge badge-light-warning">Anúncios desta categoria</span></a>
                                                <span onclick="javascript:DellLevel2({{ $cat_level2->id }})" class="badge badge-light-danger">Excluir</span>
                                            </h4>
                                        </div>
                                        <div id="level2{{ $cat_level2->id }}" class="fs-6 ms-1 collapse" style="">

                                        </div>
                                        <div class="separator separator-dashed"></div>
                                    </div>
                                    @endforeach
                                    @endif
                                    <button onclick="javascript:NewLevel2({{ $l1->id }})" class="btn btn-sm btn-primary mt-5">Categoria Nivel 2</button>
                                </div>
                                @endforeach
                               
                                <div class="modal fade" id="nova_categoria" tabindex="-1" aria-hidden="true">
                                    <div class="modal-dialog modal-dialog-centered mw-650px">
                                        <div class="modal-content rounded">
                                            <div class="modal-header pb-0 border-0 justify-content-end">
                                                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                                                    <span class="svg-icon svg-icon-1">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                                            fill="none">
                                                            <rect opacity="0.5" x="6" y="17.3137" width="16" height="2" rx="1"
                                                                transform="rotate(-45 6 17.3137)" fill="black" />
                                                            <rect x="7.41422" y="6" width="16" height="2" rx="1" transform="rotate(45 7.41422 6)"
                                                                fill="black" />
                                                        </svg>
                                                    </span>
                                                </div>
                                            </div>
                                            <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                                                <form enctype="multipart/form-data" id="kt_modal_new_target_form" class="form" method="POST" action="{{ route('categoria.store') }}">
                                                    @csrf
                                                    <div class="mb-13 text-center">
                                                        <h1 class="mb-3">Adicionar Nova Categoria</h1>
                                                    </div>
                                                    <div class="d-flex flex-column mb-8 fv-row">
                                                        <label class="d-flex align-items-center fs-6 fw-bold mb-2">
                                                            <span class="required">Título</span>
                                                        </label>
                                                        <input type="text" name="level1" class="form-control form-control-lg form-control-solid" placeholder="Título">
                                                    </div>
                                                    <div class="d-flex flex-column mb-8 fv-row">
                                                        <label class="d-flex align-items-center fs-6 fw-bold mb-2">
                                                            <span class="required">KeyWords (Ex.: Clínica médica próximo a mim, Consulta médica geral, Clínica de saúde, Médico de família, Exames médicos)</span>
                                                        </label>
                                                        <input type="text" name="keywords" id="keywords" class="form-control form-control-lg form-control-solid" placeholder="KeyWords">
                                                    </div>
                                                    <div class="d-flex flex-column mb-8 fv-row">
                                                        <label class="d-flex align-items-center fs-6 fw-bold mb-2">
                                                            <span class="required">Ico</span>
                                                        </label>
                                                        <input type="file" name="ico" id="ico" class="form-control form-control-lg form-control-solid">
                                                    </div>
                                                    <div class="row mb-6">
                                                        <label class="col-lg-4 col-form-label required fw-bold fs-6">Destaque na Home</label>
                                                        <div class="col-lg-8 fv-row fv-plugins-icon-container">
                                                            <div class="form-check form-switch form-check-custom form-check-solid">
                                                                <input class="form-check-input" type="checkbox" value="1" id="destaque" name="destaque">
                                                                <label class="form-check-label fw-bold text-gray-400 ms-3" for="status">Sim</label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="text-center">
                                                        <button type="submit" name="executar" class="btn btn-primary" id="salvar">Salvar</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="modal fade" id="nova_categoria_velel2" tabindex="-1" aria-hidden="true">
                                    <div class="modal-dialog modal-dialog-centered mw-650px">
                                        <div class="modal-content rounded">
                                            <div class="modal-header pb-0 border-0 justify-content-end">
                                                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                                                    <span class="svg-icon svg-icon-1">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                                            fill="none">
                                                            <rect opacity="0.5" x="6" y="17.3137" width="16" height="2" rx="1"
                                                                transform="rotate(-45 6 17.3137)" fill="black" />
                                                            <rect x="7.41422" y="6" width="16" height="2" rx="1" transform="rotate(45 7.41422 6)"
                                                                fill="black" />
                                                        </svg>
                                                    </span>
                                                </div>
                                            </div>
                                            <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                                                <form enctype="multipart/form-data" id="kt_modal_new_target_form" class="form" method="POST" action="{{ route('sub.categoria.store') }}">
                                                    @csrf
                                                    <div class="mb-13 text-center">
                                                        <h1 class="mb-3">Adicionar Nova Categoria</h1>
                                                    </div>
                                                    <div class="d-flex flex-column mb-8 fv-row">
                                                        <label class="d-flex align-items-center fs-6 fw-bold mb-2">
                                                            <span class="required">Categoria Principal</span>
                                                        </label>
                                                        <input id="id" name="categoria_id" type="hidden" class="form-control form-control-lg form-control-solid">
                                                        <input disabled id="level1" name="level1" type="text" class="form-control form-control-lg form-control-solid">
                                                    </div>
                                                    <div class="d-flex flex-column mb-8 fv-row">
                                                        <label class="d-flex align-items-center fs-6 fw-bold mb-2">
                                                            <span class="required">Título</span>
                                                        </label>
                                                        <input type="text" name="titulo" class="form-control form-control-lg form-control-solid" placeholder="Título">
                                                    </div>
                                                    <div class="text-center">
                                                        <button type="submit" name="executar" class="btn btn-primary" id="salvar">Salvar</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="modal fade" id="nova_categoria_velel3" tabindex="-1" aria-hidden="true">
                                    <div class="modal-dialog modal-dialog-centered mw-650px">
                                        <div class="modal-content rounded">
                                            <div class="modal-header pb-0 border-0 justify-content-end">
                                                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                                                    <span class="svg-icon svg-icon-1">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                                            fill="none">
                                                            <rect opacity="0.5" x="6" y="17.3137" width="16" height="2" rx="1"
                                                                transform="rotate(-45 6 17.3137)" fill="black" />
                                                            <rect x="7.41422" y="6" width="16" height="2" rx="1" transform="rotate(45 7.41422 6)"
                                                                fill="black" />
                                                        </svg>
                                                    </span>
                                                </div>
                                            </div>
                                            <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15" id="result_level3">

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!--end::Content-->
                        </div>
                        <!--end::Layout-->
                    </div>
                    <!--end::Body-->
                </div>
                <!--end::Careers - List-->
            </div>
        </div>

        <div class="modal fade" id="editar_categoria" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered mw-650px">
                <div class="modal-content rounded">
                    <div class="modal-header pb-0 border-0 justify-content-end">
                        <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                            <span class="svg-icon svg-icon-1">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                    fill="none">
                                    <rect opacity="0.5" x="6" y="17.3137" width="16" height="2" rx="1"
                                        transform="rotate(-45 6 17.3137)" fill="black" />
                                    <rect x="7.41422" y="6" width="16" height="2" rx="1" transform="rotate(45 7.41422 6)"
                                        fill="black" />
                                </svg>
                            </span>
                        </div>
                    </div>
                    <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                        <form enctype="multipart/form-data" id="kt_modal_new_target_form" class="form" method="POST" action="{{ route('categoria.update') }}">
                            @csrf
                            <input type="hidden" id="id_level1" name="id">
                            <div class="mb-13 text-center">
                                <h1 class="mb-3">Editar Categoria</h1>
                            </div>
                            <div class="d-flex flex-column mb-8 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold mb-2">
                                    <span class="required">Título</span>
                                </label>
                                <input type="text" name="titulo" id="titulo" class="form-control form-control-lg form-control-solid" placeholder="Título">
                            </div>
                            <div class="d-flex flex-column mb-8 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold mb-2">
                                    <span class="required">KeyWords (Ex.: Clínica médica próximo a mim, Consulta médica geral, Clínica de saúde, Médico de família, Exames médicos)</span>
                                </label>
                                <input type="text" name="keywords" id="keywords" class="form-control form-control-lg form-control-solid" placeholder="KeyWords">
                            </div>
                            <div class="d-flex flex-column mb-8 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold mb-2">
                                    <span class="required">Ico</span>
                                </label>
                                <input type="file" name="ico" id="ico" class="form-control form-control-lg form-control-solid">
                            </div>
                            <div class="row mb-6">
                                <label class="col-lg-4 col-form-label required fw-bold fs-6">Destaque na Home</label>
                                <div class="col-lg-8 fv-row fv-plugins-icon-container">
                                    <div class="form-check form-switch form-check-custom form-check-solid">
                                        <input class="form-check-input" type="checkbox" value="1" id="destaque" name="destaque">
                                        <label class="form-check-label fw-bold text-gray-400 ms-3" for="status">Sim</label>
                                    </div>
                                </div>
                            </div>
                            <div class="text-center">
                                <button type="submit" name="executar" class="btn btn-primary" id="salvar">Salvar</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

    </div>
@endsection

@section('css')
    <link href="{{ url('adm') }}/assets/plugins/custom/fullcalendar/fullcalendar.bundle.css" rel="stylesheet" type="text/css" />
    <link href="{{ url('adm') }}/assets/plugins/global/plugins.bundle.css" rel="stylesheet" type="text/css" />
    <link href="{{ url('adm') }}/assets/css/style.bundle.css" rel="stylesheet" type="text/css" />
@endsection

@section('js')
<script src="{{ url('adm') }}/assets/plugins/global/plugins.bundle.js"></script>
<script src="{{ url('adm') }}/assets/js/scripts.bundle.js"></script>
<script src="{{ url('adm') }}/assets/plugins/custom/prismjs/prismjs.bundle.js"></script>
<script src="{{ url('adm') }}/assets/plugins/custom/ckeditor/ckeditor-classic.bundle.js"></script>
<script src="{{ url('adm') }}/assets/js/custom/documentation/documentation.js"></script>
<script src="{{ url('adm') }}/assets/js/custom/documentation/search.js"></script>
<script src="{{ url('adm') }}/assets/js/custom/documentation/editors/ckeditor/classic.js"></script>
    <script>
        Inputmask({
            "mask": "999.999.999-99"
        }).mask("#cpf");
        Inputmask({
            "mask": "99/99"
        }).mask("#aniv");
        Inputmask({
            "mask": "(99) 99999-9999"
        }).mask("#celular");
        Inputmask({
            "mask": "99999-999"
        }).mask("#cep");
    </script>

    <script>
        $(document).ready(function() {

        });

        function Editar(id){
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: "{{ route('get.level1') }}",
                method: 'POST',
                data: {
                    level1: id
                },
                success: function(result) {
                    $("#editar_categoria").modal('show');
                    $("#titulo").val(result.level1);
                    $("#id_level1").val(result.id);
                    $("#keywords").val(result.keywords);
                }
            });

        }

        function NewLevel2(id){
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: "{{ route('get.level1') }}",
                method: 'POST',
                data: {
                    level1: id
                },
                success: function(result) {
                    $("#level1").val(result.level1);
                    $("#id").val(result.id);
                    $("#nova_categoria_velel2").modal('show');
                }
            });
        }

        function NewLevel3(id){
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: "{{ route('get.level2') }}",
                method: 'POST',
                data: {
                    level1: id
                },
                success: function(result) {
                    $("#result_level3").html(result);
                    $("#nova_categoria_velel3").modal('show');
                }
            });
        }


        function DellLevel1(id){
            Swal.fire({
                title: 'Atenção!',
                text: 'Deseja realmente remover esta categoria?',
                icon: 'info',
                showCancelButton: true,
                confirmButtonText: 'Sim',
                cancelButtonText: 'Não',
                customClass: {
                    confirmButton: 'btn btn-success',
                    cancelButton: 'btn btn-danger'
                },
                }).then((result) => {
                    if (result.value) {
                        $.ajaxSetup({
                            headers: {
                                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                            }
                        });
                        $.ajax({
                            url: "{{route('level1.destroy')}}",
                            method: 'POST',
                            data: {
                                id: id,
                            },
                            success: function(result) {
                                if(result == 1){
                                    Swal.fire(
                                        'Atenção!',
                                        'Categoria não poder ser removida',
                                        'error'
                                    )
                                }else{
                                    Swal.fire(
                                        'Sucesso!',
                                        'Categoria Removida',
                                        'success'
                                    );
                                    $("#hide_level1"+id).hide();
                                }
                            }
                        });

                    } else if (result.dismiss === Swal.DismissReason.cancel) {
                        Swal.fire(
                        'Cancelado',
                        'Solicitação cancelada',
                        'error'
                        )
                    }
                });
        }

        function DellLevel2(id){
            Swal.fire({
                title: 'Atenção!',
                text: 'Deseja realmente remover esta categoria?',
                icon: 'info',
                showCancelButton: true,
                confirmButtonText: 'Sim',
                cancelButtonText: 'Não',
                customClass: {
                    confirmButton: 'btn btn-success',
                    cancelButton: 'btn btn-danger'
                },
                }).then((result) => {
                    if (result.value) {
                        $.ajaxSetup({
                            headers: {
                                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                            }
                        });
                        $.ajax({
                            url: "{{route('level2.destroy')}}",
                            method: 'POST',
                            data: {
                                id: id,
                            },
                            success: function(result) {
                                if(result == 1){
                                    Swal.fire(
                                        'Atenção!',
                                        'Categoria não poder ser removida',
                                        'error'
                                    )
                                }else{
                                    Swal.fire(
                                        'Sucesso!',
                                        'Categoria Removida',
                                        'success'
                                    );
                                    $("#hide_level2"+id).hide();
                                }
                            }
                        });

                    } else if (result.dismiss === Swal.DismissReason.cancel) {
                        Swal.fire(
                        'Cancelado',
                        'Solicitação cancelada',
                        'error'
                        )
                    }
                });
        }


    </script>
@endsection

{{-- 

@extends('layouts.base')
@section('titulo', 'Categorias')
@section('content')
    <div class="content d-flex flex-column flex-column-fluid" id="kt_content">
        <div class="toolbar" id="kt_toolbar">
            <div id="kt_toolbar_container" class="container-fluid d-flex flex-stack">
                <div data-kt-swapper="true" data-kt-swapper-mode="prepend"
                    data-kt-swapper-parent="{default: '#kt_content_container', 'lg': '#kt_toolbar_container'}"
                    class="page-title d-flex align-items-center flex-wrap me-3 mb-5 mb-lg-0">
                    <h1 class="d-flex align-items-center text-dark fw-bolder fs-3 my-1">Categorias</h1>
                </div>
            </div>
        </div>

        <div class="post d-flex flex-column-fluid" id="kt_post">
            <!--begin::Container-->
            <div id="kt_content_container" class="container-xxl">
                @if (session('success'))
                <div class="alert alert-success d-flex align-items-center p-5 mb-10">
                    <span class="svg-icon svg-icon-2hx svg-icon-success me-4">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                            <path opacity="0.3"
                                d="M20.5543 4.37824L12.1798 2.02473C12.0626 1.99176 11.9376 1.99176 11.8203 2.02473L3.44572 4.37824C3.18118 4.45258 3 4.6807 3 4.93945V13.569C3 14.6914 3.48509 15.8404 4.4417 16.984C5.17231 17.8575 6.18314 18.7345 7.446 19.5909C9.56752 21.0295 11.6566 21.912 11.7445 21.9488C11.8258 21.9829 11.9129 22 12.0001 22C12.0872 22 12.1744 21.983 12.2557 21.9488C12.3435 21.912 14.4326 21.0295 16.5541 19.5909C17.8169 18.7345 18.8277 17.8575 19.5584 16.984C20.515 15.8404 21 14.6914 21 13.569V4.93945C21 4.6807 20.8189 4.45258 20.5543 4.37824Z"
                                fill="black"></path>
                            <path
                                d="M10.5606 11.3042L9.57283 10.3018C9.28174 10.0065 8.80522 10.0065 8.51412 10.3018C8.22897 10.5912 8.22897 11.0559 8.51412 11.3452L10.4182 13.2773C10.8099 13.6747 11.451 13.6747 11.8427 13.2773L15.4859 9.58051C15.771 9.29117 15.771 8.82648 15.4859 8.53714C15.1948 8.24176 14.7183 8.24176 14.4272 8.53714L11.7002 11.3042C11.3869 11.6221 10.874 11.6221 10.5606 11.3042Z"
                                fill="black"></path>
                        </svg>
                    </span>
                    <div class="d-flex flex-column">
                        <h4 class="mb-1 text-success">{{ session('success') }}</h4>
                    </div>
                </div>
            @endif
                <!--begin::Card-->
                <div class="card">
                    <!--begin::Card header-->
                    <div class="card-header border-0 pt-6">
                        <!--begin::Card title-->
                        <div class="card-title">
                            <!--begin::Search-->
                            <div class="d-flex align-items-center position-relative my-1">
                                <!--begin::Svg Icon | path: icons/duotune/general/gen021.svg-->
                                <span class="svg-icon svg-icon-1 position-absolute ms-6">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                                        <rect opacity="0.5" x="17.0365" y="15.1223" width="8.15546" height="2" rx="1" transform="rotate(45 17.0365 15.1223)" fill="black"></rect>
                                        <path d="M11 19C6.55556 19 3 15.4444 3 11C3 6.55556 6.55556 3 11 3C15.4444 3 19 6.55556 19 11C19 15.4444 15.4444 19 11 19ZM11 5C7.53333 5 5 7.53333 5 11C5 14.4667 7.53333 17 11 17C14.4667 17 17 14.4667 17 11C17 7.53333 14.4667 5 11 5Z" fill="black"></path>
                                    </svg>
                                </span>
                                <!--end::Svg Icon-->
                                <input type="text" data-kt-user-table-filter="search" class="form-control form-control-solid w-250px ps-14" placeholder="Busca rápida">
                            </div>
                        </div>
                        <div class="card-toolbar">
                            <div class="d-flex justify-content-end" data-kt-user-table-toolbar="base">
                                <a href="" class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#nova_categoria">
                                    <span class="svg-icon svg-icon-2">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                            fill="none">
                                            <rect opacity="0.5" x="11.364" y="20.364" width="16" height="2" rx="1"
                                                transform="rotate(-90 11.364 20.364)" fill="black"></rect>
                                            <rect x="4.36396" y="11.364" width="16" height="2" rx="1" fill="black"></rect>
                                        </svg>
                                    </span>
                                    Nova Categoria
                                </a>
                            </div>
                            <div class="d-flex justify-content-end align-items-center d-none"
                                data-kt-user-table-toolbar="selected">
                                <div class="fw-bolder me-5">
                                    <span class="me-2" data-kt-user-table-select="selected_count"></span>Selected
                                </div>
                                <button type="button" class="btn btn-danger"
                                    data-kt-user-table-select="delete_selected">Excluir Selecionados</button>
                            </div>
                        </div>
                        <!--end::Card toolbar-->
                    </div>
                    <!--end::Card header-->
                    <!--begin::Card body-->
                    <div class="card-body pt-0">
                        <!--begin::Table-->
                        <div id="kt_table_users_wrapper" class="dataTables_wrapper dt-bootstrap4 no-footer">
                            <div class="table-responsive">
                                <table class="table align-middle table-row-dashed fs-6 gy-5 dataTable no-footer"
                                    id="kt_table_users">
                                    <!--begin::Table head-->
                                    <thead>
                                        <!--begin::Table row-->
                                        <tr class="text-start text-muted fw-bolder fs-7 text-uppercase gs-0">
                                            <th class="w-10px pe-2 sorting_disabled" rowspan="1" colspan="1"
                                                style="width: 29.25px;" aria-label="">
                                                <div
                                                    class="form-check form-check-sm form-check-custom form-check-solid me-3">
                                                    <input class="form-check-input" type="checkbox" data-kt-check="true"
                                                        data-kt-check-target="#kt_table_users .form-check-input" value="1">
                                                </div>
                                            </th>
                                            <th class="min-w-125px sorting" tabindex="0" aria-controls="kt_table_users"
                                                rowspan="1" colspan="1" style="width: 316.067px;"
                                                aria-label="User: activate to sort column ascending">
                                                Categoria
                                            </th>
                                            <th class="min-w-125px sorting" tabindex="0" aria-controls="kt_table_users"
                                                rowspan="1" colspan="1" style="width: 316.067px;"
                                                aria-label="User: activate to sort column ascending">
                                                Destque
                                            </th>
                                            <th class="text-end min-w-100px sorting_disabled" rowspan="1" colspan="1"  style="width: 125.25px;" aria-label="Actions">Ações</th>
                                        </tr>
                                    </thead>

                                    <tbody class="text-gray-600 fw-bold">
                                        @foreach ($categorias as $categoria)
                                            <tr class="odd">
                                                <td>
                                                    <div
                                                        class="form-check form-check-sm form-check-custom form-check-solid">
                                                        <input class="form-check-input" type="checkbox" value="1">
                                                    </div>
                                                </td>
                                                <td class="d-flex align-items-center">
                                                    <div class="symbol symbol-50px overflow-hidden me-3">
                                                        <a href="">
                                                            <div class="symbol-label">
                                                                <img src="{{ !empty($categoria->ico) ? url("storage/{$categoria->ico}") : url('admin/assets/images/add-photo.png') }}" alt="{{ $categoria->ico }}" class="w-100">
                                                            </div>
                                                        </a>
                                                    </div>
                                                    <div class="d-flex flex-column">  <a href="" class="text-gray-800 text-hover-primary mb-1">{{ $categoria->id }}-{{ $categoria->level1 }}</a></div>
                                                </td>
                                                <td>
                                                    <span class="badge badge-{{ $categoria->destaque == 1 ? 'success' : 'danger' }}">{{ $categoria->destaque == 1 ? 'Sim' : 'Não' }}</span>
                                                </td>
                                                <td class="text-end">
                                                    <a data-bs-toggle="modal" data-bs-target="#editar{{$categoria->id}}" class="btn btn-primary btn-sm">Editar</a>
                                                </td>
                                            </tr>

                                            <div class="modal fade" id="editar{{$categoria->id}}" tabindex="-1" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered mw-650px">
                                                    <div class="modal-content rounded">
                                                        <div class="modal-header pb-0 border-0 justify-content-end">
                                                            <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                                                                <span class="svg-icon svg-icon-1">
                                                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                                                        fill="none">
                                                                        <rect opacity="0.5" x="6" y="17.3137" width="16" height="2" rx="1"
                                                                            transform="rotate(-45 6 17.3137)" fill="black" />
                                                                        <rect x="7.41422" y="6" width="16" height="2" rx="1" transform="rotate(45 7.41422 6)"
                                                                            fill="black" />
                                                                    </svg>
                                                                </span>
                                                            </div>
                                                        </div>
                                                        <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                                                            <form enctype="multipart/form-data" id="kt_modal_new_target_form" class="form" method="POST" action="{{ route('categoria.update', $categoria->id) }}">
                                                                @csrf
                                                                 <div class="mb-13 text-center">
                                                                    <h1 class="mb-3">Editar Categoria {{$categoria->level1}}</h1>
                                                                </div>
                                                                <input type="hidden" value="{{ $categoria->id }}" name="id" />
                                                                <div class="d-flex flex-column mb-8 fv-row">
                                                                    <label class="d-flex align-items-center fs-6 fw-bold mb-2">
                                                                        <span class="required">Título</span>
                                                                    </label>
                                                                    <input value="{{$categoria->level1}}" type="text" name="level1" id="level1" class="form-control form-control-lg form-control-solid">
                                                                </div>
                                                                <div class="d-flex flex-column mb-8 fv-row">
                                                                    <label class="d-flex align-items-center fs-6 fw-bold mb-2">
                                                                        <span class="required">Ico</span>
                                                                    </label>
                                                                    <input type="file" name="ico" id="ico" class="form-control form-control-lg form-control-solid">
                                                                </div>
                                                                <div class="row mb-6">
                                                                    <label class="col-lg-4 col-form-label required fw-bold fs-6">Destaque na Home</label>
                                                                    <div class="col-lg-8 fv-row fv-plugins-icon-container">
                                                                        <div class="form-check form-switch form-check-custom form-check-solid">
                                                                            <input {{$categoria->destaque == 1 ? 'checked=checked' : ''}} class="form-check-input" type="checkbox" value="1" name="destaque">
                                                                            <label class="form-check-label fw-bold text-gray-400 ms-3" for="status">Sim</label>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="text-center">
                                                                    <button type="submit" name="executar" class="btn btn-primary" id="salvar">Salvar</button>
                                                                </div>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="modal fade" id="nova_categoria" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered mw-650px">
                <div class="modal-content rounded">
                    <div class="modal-header pb-0 border-0 justify-content-end">
                        <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                            <span class="svg-icon svg-icon-1">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                    fill="none">
                                    <rect opacity="0.5" x="6" y="17.3137" width="16" height="2" rx="1"
                                        transform="rotate(-45 6 17.3137)" fill="black" />
                                    <rect x="7.41422" y="6" width="16" height="2" rx="1" transform="rotate(45 7.41422 6)"
                                        fill="black" />
                                </svg>
                            </span>
                        </div>
                    </div>
                    <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                        <form enctype="multipart/form-data" id="kt_modal_new_target_form" class="form" method="POST" action="{{ route('categoria.store') }}">
                            @csrf
                            <div class="mb-13 text-center">
                                <h1 class="mb-3">Adicionar Nova Categoria</h1>
                            </div>
                            <div class="d-flex flex-column mb-8 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold mb-2">
                                    <span class="required">Título</span>
                                </label>
                                <input type="text" name="titulo" id="titulo" class="form-control form-control-lg form-control-solid" placeholder="Título">
                            </div>
                            <div class="d-flex flex-column mb-8 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold mb-2">
                                    <span class="required">KeyWords</span>
                                </label>
                                <input type="text" name="keywords" id="keywords" class="form-control form-control-lg form-control-solid" placeholder="KeyWords">
                            </div>
                            <div class="d-flex flex-column mb-8 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold mb-2">
                                    <span class="required">Ico</span>
                                </label>
                                <input type="file" name="ico" id="ico" class="form-control form-control-lg form-control-solid">
                            </div>
                            <div class="row mb-6">
                                <label class="col-lg-4 col-form-label required fw-bold fs-6">Destaque na Home</label>
                                <div class="col-lg-8 fv-row fv-plugins-icon-container">
                                    <div class="form-check form-switch form-check-custom form-check-solid">
                                        <input class="form-check-input" type="checkbox" value="1" id="destaque" name="destaque">
                                        <label class="form-check-label fw-bold text-gray-400 ms-3" for="status">Sim</label>
                                    </div>
                                </div>
                            </div>
                            <div class="text-center">
                                <button type="submit" name="executar" class="btn btn-primary" id="salvar">Salvar</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

    </div>
@endsection

@section('css')
    <link rel="shortcut icon" href="{{url('adm')}}/assets/media/logos/favicon.ico" />
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700" />
    <link href="{{url('adm')}}/assets/plugins/custom/datatables/datatables.bundle.css" rel="stylesheet" type="text/css" />
    <link href="{{url('adm')}}/assets/plugins/global/plugins.bundle.css" rel="stylesheet" type="text/css" />
    <link href="{{url('adm')}}/assets/css/style.bundle.css" rel="stylesheet" type="text/css" />
@endsection

@section('js')
    <script src="{{url('adm')}}/assets/plugins/global/plugins.bundle.js"></script>
    <script src="{{url('adm')}}/assets/js/scripts.bundle.js"></script>
    <!--begin::Page Vendors Javascript(used by this page)-->
    <script src="{{url('adm')}}/assets/plugins/custom/datatables/datatables.bundle.js"></script>
    <!--end::Page Vendors Javascript-->
    <!--begin::Page Custom Javascript(used by this page)-->
    <script src="{{url('adm')}}/assets/js/custom/apps/user-management/users/list/table.js"></script>
    <script src="{{url('adm')}}/assets/js/custom/apps/user-management/users/list/export-users.js"></script>
    <script src="{{url('adm')}}/assets/js/custom/apps/user-management/users/list/add.js"></script>
    <script src="{{url('adm')}}/assets/js/custom/widgets.js"></script>
    <script src="{{url('adm')}}/assets/js/custom/apps/chat/chat.js"></script>
    <script src="{{url('adm')}}/assets/js/custom/modals/create-app.js"></script>
    <script src="{{url('adm')}}/assets/js/custom/modals/upgrade-plan.js"></script>
    <script src="{{url('adm')}}/assets/js/custom/intro.js"></script>
    <!--end::Page Custom Javascript-->
@endsection --}}
