@extends('layouts.base')
@section('titulo', 'Gerenciamento de Categorias')
@section('content')
    <div class="content d-flex flex-column flex-column-fluid" id="kt_content">
        <div class="toolbar" id="kt_toolbar">
            <div id="kt_toolbar_container" class="container-fluid d-flex flex-stack">
                <div data-kt-swapper="true" data-kt-swapper-mode="prepend"
                    data-kt-swapper-parent="{default: '#kt_content_container', 'lg': '#kt_toolbar_container'}"
                    class="page-title d-flex align-items-center flex-wrap me-3 mb-5 mb-lg-0">
                    <h1 class="d-flex align-items-center text-dark fw-bolder fs-3 my-1">Gerenciamento de Categorias</h1>
                </div>
                <div class="d-flex align-items-center py-1">

                </div>
            </div>
        </div>
        <div class="post d-flex flex-column-fluid" id="kt_post">
            <div id="kt_content_container" class="container-xxl">
                @if (session('success'))
                    <div class="alert alert-success d-flex align-items-center p-5 mb-10">
                        <span class="svg-icon svg-icon-2hx svg-icon-success me-4">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                                <path opacity="0.3"
                                    d="M20.5543 4.37824L12.1798 2.02473C12.0626 1.99176 11.9376 1.99176 11.8203 2.02473L3.44572 4.37824C3.18118 4.45258 3 4.6807 3 4.93945V13.569C3 14.6914 3.48509 15.8404 4.4417 16.984C5.17231 17.8575 6.18314 18.7345 7.446 19.5909C9.56752 21.0295 11.6566 21.912 11.7445 21.9488C11.8258 21.9829 11.9129 22 12.0001 22C12.0872 22 12.1744 21.983 12.2557 21.9488C12.3435 21.912 14.4326 21.0295 16.5541 19.5909C17.8169 18.7345 18.8277 17.8575 19.5584 16.984C20.515 15.8404 21 14.6914 21 13.569V4.93945C21 4.6807 20.8189 4.45258 20.5543 4.37824Z"
                                    fill="black"></path>
                                <path
                                    d="M10.5606 11.3042L9.57283 10.3018C9.28174 10.0065 8.80522 10.0065 8.51412 10.3018C8.22897 10.5912 8.22897 11.0559 8.51412 11.3452L10.4182 13.2773C10.8099 13.6747 11.451 13.6747 11.8427 13.2773L15.4859 9.58051C15.771 9.29117 15.771 8.82648 15.4859 8.53714C15.1948 8.24176 14.7183 8.24176 14.4272 8.53714L11.7002 11.3042C11.3869 11.6221 10.874 11.6221 10.5606 11.3042Z"
                                    fill="black"></path>
                            </svg>
                        </span>
                        <div class="d-flex flex-column">
                            <h4 class="mb-1 text-success">{{ session('success') }}</h4>
                        </div>
                    </div>
                @endif
                @if (session('error'))
                    <div class="alert alert-danger d-flex align-items-center p-5 mb-10">
                        <span class="svg-icon svg-icon-2hx svg-icon-danger me-4">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                                <path opacity="0.3"
                                    d="M20.5543 4.37824L12.1798 2.02473C12.0626 1.99176 11.9376 1.99176 11.8203 2.02473L3.44572 4.37824C3.18118 4.45258 3 4.6807 3 4.93945V13.569C3 14.6914 3.48509 15.8404 4.4417 16.984C5.17231 17.8575 6.18314 18.7345 7.446 19.5909C9.56752 21.0295 11.6566 21.912 11.7445 21.9488C11.8258 21.9829 11.9129 22 12.0001 22C12.0872 22 12.1744 21.983 12.2557 21.9488C12.3435 21.912 14.4326 21.0295 16.5541 19.5909C17.8169 18.7345 18.8277 17.8575 19.5584 16.984C20.515 15.8404 21 14.6914 21 13.569V4.93945C21 4.6807 20.8189 4.45258 20.5543 4.37824Z"
                                    fill="black"></path>
                                <path
                                    d="M10.5606 11.3042L9.57283 10.3018C9.28174 10.0065 8.80522 10.0065 8.51412 10.3018C8.22897 10.5912 8.22897 11.0559 8.51412 11.3452L10.4182 13.2773C10.8099 13.6747 11.451 13.6747 11.8427 13.2773L15.4859 9.58051C15.771 9.29117 15.771 8.82648 15.4859 8.53714C15.1948 8.24176 14.7183 8.24176 14.4272 8.53714L11.7002 11.3042C11.3869 11.6221 10.874 11.6221 10.5606 11.3042Z"
                                    fill="black"></path>
                            </svg>
                        </span>
                        <div class="d-flex flex-column">
                            <h4 class="mb-1 text-danger">{{ session('error') }}</h4>
                        </div>
                    </div>
                @endif
                <div class="card">
                    <div class="card-body p-lg-17">
                        <div class="d-flex flex-column flex-lg-row mb-17">
                             <div class="flex-lg-row-fluid me-0 me-lg-20">
                                <a href="#" data-bs-toggle="modal" data-bs-target="#nova_categoria" class="btn btn-sm btn-primary mt-5">Nova Categoria</a>
                                <br><br>
                                @foreach ($level1 as $l1)
                                <div class="mb-17" id="hide_level1{{ $l1->id }}">
                                   <div class="m-0">
                                    <img src="{{ url("storage/{$l1->ico}") }}" width="100">
                                        <h4 class="fs-1 text-gray-800 w-bolder mb-6">
                                            {{ $l1->level1 }}<br>
                                            <a href="{{ route('anuncios.categoria',$l1->id) }}" target="_blank"><span class="badge badge-light-warning">Anúncios desta categoria</span></a>
                                            <span onclick="javascript:Editar({{ $l1->id }})" class="badge badge-light-success">Editar</span>
                                            <span class="badge badge-light-danger" onclick="javascript:DellLevel1({{ $l1->id }})">Excluir</span></h4>
                                            </h4>
                                    </div>
                                </div>
                                @endforeach
                                <div class="modal fade" id="nova_categoria" tabindex="-1" aria-hidden="true">
                                    <div class="modal-dialog modal-dialog-centered mw-650px">
                                        <div class="modal-content rounded">
                                            <div class="modal-header pb-0 border-0 justify-content-end">
                                                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                                                    <span class="svg-icon svg-icon-1">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                                            fill="none">
                                                            <rect opacity="0.5" x="6" y="17.3137" width="16" height="2" rx="1"
                                                                transform="rotate(-45 6 17.3137)" fill="black" />
                                                            <rect x="7.41422" y="6" width="16" height="2" rx="1" transform="rotate(45 7.41422 6)"
                                                                fill="black" />
                                                        </svg>
                                                    </span>
                                                </div>
                                            </div>
                                            <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                                                <form enctype="multipart/form-data" id="kt_modal_new_target_form" class="form" method="POST" action="{{ route('categoria.store') }}">
                                                    @csrf
                                                    <div class="mb-13 text-center">
                                                        <h1 class="mb-3">Adicionar Nova Categoria</h1>
                                                    </div>
                                                    <div class="d-flex flex-column mb-8 fv-row">
                                                        <label class="d-flex align-items-center fs-6 fw-bold mb-2">
                                                            <span class="required">Título</span>
                                                        </label>
                                                        <input type="text" name="titulo" class="form-control form-control-lg form-control-solid" placeholder="Título">
                                                    </div>
                                                    <div class="d-flex flex-column mb-8 fv-row">
                                                        <label class="d-flex align-items-center fs-6 fw-bold mb-2">
                                                            <span class="required">Ico</span>
                                                        </label>
                                                        <input type="file" name="ico" id="ico" class="form-control form-control-lg form-control-solid">
                                                    </div>
                                                    <div class="row mb-6">
                                                        <label class="col-lg-4 col-form-label required fw-bold fs-6">Destaque na Home</label>
                                                        <div class="col-lg-8 fv-row fv-plugins-icon-container">
                                                            <div class="form-check form-switch form-check-custom form-check-solid">
                                                                <input class="form-check-input" type="checkbox" value="1" id="destaque" name="destaque">
                                                                <label class="form-check-label fw-bold text-gray-400 ms-3" for="status">Sim</label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="text-center">
                                                        <button type="submit" name="executar" class="btn btn-primary" id="salvar">Salvar</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="modal fade" id="nova_categoria_velel2" tabindex="-1" aria-hidden="true">
                                    <div class="modal-dialog modal-dialog-centered mw-650px">
                                        <div class="modal-content rounded">
                                            <div class="modal-header pb-0 border-0 justify-content-end">
                                                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                                                    <span class="svg-icon svg-icon-1">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                                            fill="none">
                                                            <rect opacity="0.5" x="6" y="17.3137" width="16" height="2" rx="1"
                                                                transform="rotate(-45 6 17.3137)" fill="black" />
                                                            <rect x="7.41422" y="6" width="16" height="2" rx="1" transform="rotate(45 7.41422 6)"
                                                                fill="black" />
                                                        </svg>
                                                    </span>
                                                </div>
                                            </div>
                                            <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                                                <form enctype="multipart/form-data" id="kt_modal_new_target_form" class="form" method="POST" action="{{ route('sub.categoria.store') }}">
                                                    @csrf
                                                    <div class="mb-13 text-center">
                                                        <h1 class="mb-3">Adicionar Nova Categoria</h1>
                                                    </div>
                                                    <div class="d-flex flex-column mb-8 fv-row">
                                                        <label class="d-flex align-items-center fs-6 fw-bold mb-2">
                                                            <span class="required">Categoria Principal</span>
                                                        </label>
                                                        <input id="id" name="categoria_id" type="hidden" class="form-control form-control-lg form-control-solid">
                                                        <input disabled id="level1" name="level1" type="text" class="form-control form-control-lg form-control-solid">
                                                    </div>
                                                    <div class="d-flex flex-column mb-8 fv-row">
                                                        <label class="d-flex align-items-center fs-6 fw-bold mb-2">
                                                            <span class="required">Título</span>
                                                        </label>
                                                        <input type="text" name="titulo" class="form-control form-control-lg form-control-solid" placeholder="Título">
                                                    </div>
                                                    <div class="text-center">
                                                        <button type="submit" name="executar" class="btn btn-primary" id="salvar">Salvar</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="modal fade" id="nova_categoria_velel3" tabindex="-1" aria-hidden="true">
                                    <div class="modal-dialog modal-dialog-centered mw-650px">
                                        <div class="modal-content rounded">
                                            <div class="modal-header pb-0 border-0 justify-content-end">
                                                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                                                    <span class="svg-icon svg-icon-1">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                                            fill="none">
                                                            <rect opacity="0.5" x="6" y="17.3137" width="16" height="2" rx="1"
                                                                transform="rotate(-45 6 17.3137)" fill="black" />
                                                            <rect x="7.41422" y="6" width="16" height="2" rx="1" transform="rotate(45 7.41422 6)"
                                                                fill="black" />
                                                        </svg>
                                                    </span>
                                                </div>
                                            </div>
                                            <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15" id="result_level3">

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!--end::Content-->
                        </div>
                        <!--end::Layout-->
                    </div>
                    <!--end::Body-->
                </div>
                <!--end::Careers - List-->
            </div>
        </div>

        <div class="modal fade" id="editar_categoria" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered mw-650px">
                <div class="modal-content rounded">
                    <div class="modal-header pb-0 border-0 justify-content-end">
                        <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                            <span class="svg-icon svg-icon-1">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                    fill="none">
                                    <rect opacity="0.5" x="6" y="17.3137" width="16" height="2" rx="1"
                                        transform="rotate(-45 6 17.3137)" fill="black" />
                                    <rect x="7.41422" y="6" width="16" height="2" rx="1" transform="rotate(45 7.41422 6)"
                                        fill="black" />
                                </svg>
                            </span>
                        </div>
                    </div>
                    <div class="modal-body scroll-y px-10 px-lg-15 pt-0 pb-15">
                        <form enctype="multipart/form-data" id="kt_modal_new_target_form" class="form" method="POST" action="{{ route('categoria.update') }}">
                            @csrf
                            <input type="hidden" id="id_level1" name="id">
                            <div class="mb-13 text-center">
                                <h1 class="mb-3">Editar Categoria</h1>
                            </div>
                            <div class="d-flex flex-column mb-8 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold mb-2">
                                    <span class="required">Título</span>
                                </label>
                                <input type="text" name="titulo" id="titulo" class="form-control form-control-lg form-control-solid" placeholder="Título">
                            </div>
                            <div class="d-flex flex-column mb-8 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold mb-2">
                                    <span class="required">Ico</span>
                                </label>
                                <input type="file" name="ico" id="ico" class="form-control form-control-lg form-control-solid">
                            </div>
                            <div class="row mb-6">
                                <label class="col-lg-4 col-form-label required fw-bold fs-6">Destaque na Home</label>
                                <div class="col-lg-8 fv-row fv-plugins-icon-container">
                                    <div class="form-check form-switch form-check-custom form-check-solid">
                                        <input class="form-check-input" type="checkbox" value="1" id="destaque" name="destaque">
                                        <label class="form-check-label fw-bold text-gray-400 ms-3" for="status">Sim</label>
                                    </div>
                                </div>
                            </div>
                            <div class="text-center">
                                <button type="submit" name="executar" class="btn btn-primary" id="salvar">Salvar</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

    </div>
@endsection

@section('css')
    <link href="{{ url('adm') }}/assets/plugins/custom/fullcalendar/fullcalendar.bundle.css" rel="stylesheet" type="text/css" />
    <link href="{{ url('adm') }}/assets/plugins/global/plugins.bundle.css" rel="stylesheet" type="text/css" />
    <link href="{{ url('adm') }}/assets/css/style.bundle.css" rel="stylesheet" type="text/css" />
@endsection

@section('js')
<script src="{{ url('adm') }}/assets/plugins/global/plugins.bundle.js"></script>
<script src="{{ url('adm') }}/assets/js/scripts.bundle.js"></script>
<script src="{{ url('adm') }}/assets/plugins/custom/prismjs/prismjs.bundle.js"></script>
<script src="{{ url('adm') }}/assets/plugins/custom/ckeditor/ckeditor-classic.bundle.js"></script>
<script src="{{ url('adm') }}/assets/js/custom/documentation/documentation.js"></script>
<script src="{{ url('adm') }}/assets/js/custom/documentation/search.js"></script>
<script src="{{ url('adm') }}/assets/js/custom/documentation/editors/ckeditor/classic.js"></script>
    <script>
        Inputmask({
            "mask": "999.999.999-99"
        }).mask("#cpf");
        Inputmask({
            "mask": "99/99"
        }).mask("#aniv");
        Inputmask({
            "mask": "(99) 99999-9999"
        }).mask("#celular");
        Inputmask({
            "mask": "99999-999"
        }).mask("#cep");
    </script>

    <script>
        $(document).ready(function() {

        });

        function Editar(id){
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: "{{ route('get.level1') }}",
                method: 'POST',
                data: {
                    level1: id
                },
                success: function(result) {
                    $("#editar_categoria").modal('show');
                    $("#titulo").val(result.level1);
                    $("#id_level1").val(result.id);
                }
            });

        }

        function NewLevel2(id){
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: "{{ route('get.level1') }}",
                method: 'POST',
                data: {
                    level1: id
                },
                success: function(result) {
                    $("#level1").val(result.level1);
                    $("#id").val(result.id);
                    $("#nova_categoria_velel2").modal('show');
                }
            });
        }

        function NewLevel3(id){
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: "{{ route('get.level2') }}",
                method: 'POST',
                data: {
                    level1: id
                },
                success: function(result) {
                    $("#result_level3").html(result);
                    $("#nova_categoria_velel3").modal('show');
                }
            });
        }


        function DellLevel1(id){
            Swal.fire({
                title: 'Atenção!',
                text: 'Deseja realmente remover esta categoria?',
                icon: 'info',
                showCancelButton: true,
                confirmButtonText: 'Sim',
                cancelButtonText: 'Não',
                customClass: {
                    confirmButton: 'btn btn-success',
                    cancelButton: 'btn btn-danger'
                },
                }).then((result) => {
                    if (result.value) {
                        $.ajaxSetup({
                            headers: {
                                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                            }
                        });
                        $.ajax({
                            url: "{{route('level1.destroy')}}",
                            method: 'POST',
                            data: {
                                id: id,
                            },
                            success: function(result) {
                                if(result == 1){
                                    Swal.fire(
                                        'Atenção!',
                                        'Categoria não poder ser removida',
                                        'error'
                                    )
                                }else{
                                    Swal.fire(
                                        'Sucesso!',
                                        'Categoria Removida',
                                        'success'
                                    );
                                    $("#hide_level1"+id).hide();
                                }
                            }
                        });

                    } else if (result.dismiss === Swal.DismissReason.cancel) {
                        Swal.fire(
                        'Cancelado',
                        'Solicitação cancelada',
                        'error'
                        )
                    }
                });
        }

        function DellLevel2(id){
            Swal.fire({
                title: 'Atenção!',
                text: 'Deseja realmente remover esta categoria?',
                icon: 'info',
                showCancelButton: true,
                confirmButtonText: 'Sim',
                cancelButtonText: 'Não',
                customClass: {
                    confirmButton: 'btn btn-success',
                    cancelButton: 'btn btn-danger'
                },
                }).then((result) => {
                    if (result.value) {
                        $.ajaxSetup({
                            headers: {
                                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                            }
                        });
                        $.ajax({
                            url: "{{route('level2.destroy')}}",
                            method: 'POST',
                            data: {
                                id: id,
                            },
                            success: function(result) {
                                if(result == 1){
                                    Swal.fire(
                                        'Atenção!',
                                        'Categoria não poder ser removida',
                                        'error'
                                    )
                                }else{
                                    Swal.fire(
                                        'Sucesso!',
                                        'Categoria Removida',
                                        'success'
                                    );
                                    $("#hide_level2"+id).hide();
                                }
                            }
                        });

                    } else if (result.dismiss === Swal.DismissReason.cancel) {
                        Swal.fire(
                        'Cancelado',
                        'Solicitação cancelada',
                        'error'
                        )
                    }
                });
        }


    </script>
@endsection
