<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Loja extends Model
{
    use HasFactory;
    protected $fillable = [
        'potencia',
        'numero',
        'loja',
        'endereco',
        'numeroend',
        'complemento',
        'bairro',
        'oriente',
        'estado',
        'cep',
        'cnpj',
        'fundacao',
        'rito',
        'reunioes',
        'horario',
        'vm',
        'vigilante1',
        'vigilante2',
        'razao',
    ];

    public function potencia()
    {
        return $this->hasOne('App\Models\Potencia', 'id', 'potencia');
    }
    public function telefones()
    {
        return $this->hasMany(LojaTelefone::class, 'lojaID', 'id');
    }
}
