<?php

namespace App\Http\Controllers;

use App\Models\Slide;
use Illuminate\Http\Request;
use GuzzleHttp\Client;

class AjaxController extends Controller
{
    public function slides(Request $request)
    {
        $client = new Client();
        $slides = [];
        $exe_slides = Slide::orderby('ordem')->get();
        foreach ($exe_slides as $dds_slide) {
            try { 
                if ($dds_slide->evento_id != 0) {
                    $response = $client->request('GET', 'https://apihml.ticketmaker.com.br/v1/event/filter?id=' . $dds_slide->evento_id, [
                        'headers' => [
                            'TM-PORTAL-APIKEY' => env('APIKEY'),
                            'accept' => 'application/json',
                            'content-type' => 'application/json',
                        ],
                    ]);

                    $res_slide = json_decode($response->getBody()->getContents(), true);
                    if (!empty($res_slide) && isset($res_slide[0])) {
                        if (date('Y-m-d', strtotime($res_slide[0]['dataEvento'])) >= date('Y-m-d')) {
                            $set_slide = [
                                'id' => $dds_slide,
                                'evento_id' => $res_slide[0]['id'],
                                'data' => $res_slide[0]['dataEvento'],
                                'titulo' => $res_slide[0]['titulo'],
                                'local' => $res_slide[0]['local'],
                                'botao' => $res_slide[0]['qtdPacotes'] > 0 ? 'Compre Aqui' : 'Vendas em Breve',
                                'link' => $res_slide[0]['link'],
                                'image' => $res_slide[0]['banner'],
                                "dataEvento" => $res_slide[0]['dataEvento'],
                            ];
                        } else {
                            $set_slide = [
                                'id' => $dds_slide->id,
                                'evento_id' => $res_slide[0]['id'],
                                'data' => $res_slide[0]['dataEvento'],
                                'titulo' => $res_slide[0]['titulo'],
                                'local' => $res_slide[0]['local'],
                                'botao' => $res_slide[0]['qtdPacotes'] > 0 ? 'Compre Aqui' : 'Vendas em Breve',
                                'link' => $res_slide[0]['link'],
                                'image' => $res_slide[0]['banner'],
                                "dataEvento" => $res_slide[0]['dataEvento'],
                            ];
                        }
                    } else {
                        $dds_slide->delete();
                    }
                } else {
                    $set_slide = [
                        'id' => $dds_slide,
                        'evento_id' => $dds_slide->evento_id,
                        'data' => $dds_slide->data,
                        'titulo' => $dds_slide->titulo,
                        'local' => $dds_slide->local,
                        'botao' => $dds_slide->botao,
                        'link' => $dds_slide->link,
                        'image' => $dds_slide->image,
                        'subtitulo' => $dds_slide->subtitulo,
                    ];
                }

                $slides[] = $set_slide;
            } catch (\Exception $e) {
                // Adicione aqui o tratamento para a exceção, como log ou ação específica.
                // Por exemplo: logger()->error('Erro ao processar slide: ' . $e->getMessage());
            }
        }
        return response()->json($slides);
    }
}
