<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Estado;
use App\Models\Fatura;
use App\Models\Plano;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Str;
use Mail;

class UserController extends Controller
{
    public function index()
    {
        $users = User::get();
        return view('admin.usuarios.index',compact('users'));
    }

    public function create()
    {
        $estados = Estado::get();
        return view('admin.usuarios.create',compact('estados'));
    }

    public function store(Request $request)
    {

        $dados              = $request->all();
        $dados['status']    = 'Ativo';
        $dados['nivel']     = $request->nivel == 1 ? 1 : 4;
        $dados['founder']   = $request->founder == 1 ? 1 : 0;
        $dados['password']  = bcrypt($request->email);
        // dd($dados);
        if (User::where('email', $request->email)->first()) {
            return redirect()->back()->with('error', 'Este e-mail já esta cadastrado');
        }
        if ($request->thumb) {
            $nameFile       = Str::of($request->foto)->slug('-') . rand() . '.' . $request->foto->getClientOriginalExtension();
            $dados['foto'] = $request->foto->storeAs('usuarios', $nameFile);
        }else{
            $dados['foto'] = '';
        }

        User::create($dados);

        Mail::send('email-boas-vindas-cliente', [
            'name' => $request->name,
            'email' => $request->email,
            'telefone' => $request->telefone,
            'assunto' => $request->assunto,
            'senha' => $request->email,
        ], function ($mail) use ($request) {
            $mail->from(env('MAIL_FROM_ADDRESS'), env('APP_NAME'));
            $mail->to($request->email)->subject('Cadastro Aplicativo Chibarro Grei');
        });

        return redirect()
            ->route('user.create')
            ->with('success', 'Usuário cadastrado com sucesso');
    }

    public function MeusDados()
    {
        $class = 'pessoal';
        return view('admin.perfil.dados', ['class' => $class]);
    }

    public function UpdateFoto(Request $request)
    {
        $user = User::find(Auth::user()->id);
        $nameFile       = Str::of(Auth::user()->name)->slug('-') . rand() . '.' . $request->foto->getClientOriginalExtension();
        $dados['foto']  = $request->foto->storeAs('self', $nameFile);

        $user->update($dados);
        return redirect()->back()->with('success', 'Dados atualizado com sucesso');
    }

    public function UpdatePerfilApp(Request $request, $id)
    {
        $dados = $request->all();
        if ($request->senha != $request->senha2 && $request->senha2 != null) {
            return redirect()->back()->with('error', 'As senhas devem ser iguais');
        } else {
            $user                   = User::find($id);
            $nome                   = $request->name;
            if ($request->arq) {
                $nameFile               = Str::of($nome)->slug('-') . rand() . '.' . $request->arq->getClientOriginalExtension();
                $dados['foto']          = $request->arq->storeAs('fotos', $nameFile);
            }
            if ($request->senha2) {
                $dados['password']          = bcrypt($request->senha);
            }
            $user->update($dados);
            return redirect()->back()->with('success', 'Dados atualizado com sucesso');
        }
    }

    public function UpdatePerfil(Request $request)
    {
        dd($request->all());
        if (!$user = User::find($request->id)) {
            return redirect()->back();
        }
        $dados                  = $request->all();
        if ($request->senha && $request->senha == $request->senha2) {
            $dados['password']     = bcrypt($request->senha);
        }
        // dd($request->all(),$dados);
        $user->update($dados);
        return redirect()
            ->back()
            ->with('success', 'Dados atualizado com sucesso');
    }

    public function show($id)
    {
        $user = User::find($id);
        return view('admin.usuarios.show',['user'=>$user]);
    }

    public function update(Request $request, $id)
    {
        $user = User::find($id);
        $dados = $request->all();
        $dados['fundador'] = !empty($request->fundador) ? 1 : 0;
        $user->update($dados);

        return redirect()->back()->with('success','Dados atualizado com sucesso');
    }


}
