<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Anuncio;
use App\Models\Categoria;
use App\Models\SubCategoria;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class CategoriaController extends Controller
{
 
    public function index()
    {
        $level1 = Categoria::get();
        // foreach($level1 as $cat){
        //     $anuncios = Anuncio::where('categoria_id',$cat->id)->get();
        //     foreach($anuncios as $anuncio){
        //         $exe = Anuncio::find($anuncio->id);
        //         $dados = [
        //             'level1' => $cat->titulo
        //         ];
        //         $exe->update($dados);
        //     }

        // }
        return view('admin.categorias.index', compact('level1'));
    }

    public function create()
    {
    } 

    public function store(Request $request)
    {
        $dados              = $request->all();
        if($request->ico){
            $nameFile           = Str::of($request->titulo)->slug('-') . rand() . '.' . $request->ico->getClientOriginalExtension();
            $dados['ico']       = $request->ico->storeAs('categorias', $nameFile);
        }
        $dados['url_level1']           = Str::of($request->titulo)->slug('-');
        Categoria::create($dados);

        return redirect()->back()->with('success', 'Categoria cadastrada com sucesso');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }


    public function update(Request $request)
    {
        $update = 0;
        $categoria = Categoria::find($request->id);
        if($request->titulo != $categoria->titulo){
            $update = 1;
        }
        if(!$categoria){
            return redirect()->back();
        }

        $dados              = $request->all();
        if($request->ico){
            $nameFile           = Str::of($request->titulo)->slug('-') . rand() . '.' . $request->ico->getClientOriginalExtension();
            $dados['ico']       = $request->ico->storeAs('categorias', $nameFile);
        }
        $dados['url']       = Str::of($request->titulo)->slug('-');
        if($request->destaque){
            $dados['destaque'] = '1';
        }else{
            $dados['destaque'] = '0'; 
        }
        $categoria->update($dados);

        $anuncios = Anuncio::where('categoria_id',$request->id)->get();
        foreach($anuncios as $anuncio){
            $exe = Anuncio::find($anuncio->id);
            $dados = [
                'level1' => $request->titulo
            ];
            $exe->update($dados);
        }
        return redirect()->back()->with('success', 'Categoria atualizada com sucesso');
    }

    public function destroy($id)
    {

    }

    public function GetCategorias(Request $request)
    {
        $subs = SubCategoria::where('categoria_id',$request->categoria_id)->get();
        return view('admin.ajax.subcategorias',compact('subs'));
    }


    public function GetLevel1(Request $request)
    {
        $categoria = Categoria::find($request->level1);
        // dd($categoria);
        return response()->json(['level1' => $categoria->titulo, 'id' => $categoria->id, 'keywords' => $categoria->keywords]);
    }

    public function DestroyLevel1(Request $request)
    {
        $level1 = Categoria::find($request->id);
        $level2 = SubCategoria::where('categoria_id', $request->id)->get();
        $anuncio = Anuncio::where('categoria_id',$level1)->first();
        if (count($level2) > 0) {
            return  1;
        }
        if(!empty($anuncio->id)){
            return  1;
        }
        $level1->delete();
    }

    public function DestroyLevel2(Request $request)
    {
        $level2 = SubCategoria::find($request->id);
        $anuncio = Anuncio::where('sub_categoria_id',$level2)->first();
        if(!empty($anuncio->id)){
            return  1;
        }
        $level2->delete();
    }
}
