<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Anuncio;
use App\Models\AnuncioPessoas;
use App\Models\AnuncioTelefone;
use App\Models\Categoria;
use App\Models\Estado;
use App\Models\PalavraChave;
use App\Models\Potencia;
use App\Models\SubCategoria;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;
use Image;

class AnuncioController extends Controller
{

    public function anuncios()
    {
        $mostar = 0;
        $anuncios = [];
        return view('admin.anuncios.ativos', compact('anuncios'), ['mostar' => $mostar]);
    }

    public function buscar(Request $request)
    {
        $anuncios = Anuncio::where('fantasia', 'LIKE', '%' . $request->s . '%')
            ->orWhere('razao', 'LIKE', '%' . $request->s . '%')
            ->orWhere('contrato', 'LIKE', '%' . $request->s . '%')
            ->orWhere('cidade', 'LIKE', '%' . $request->s . '%')
            ->orWhere('estado', 'LIKE', '%' . $request->s . '%')
            ->orWhere('bairro', 'LIKE', '%' . $request->s . '%')

            ->get();
        $mostar = 1;
        return view('admin.anuncios.ativos', compact('anuncios'), ['mostar' => $mostar]);
    }

    public function patrocinados()
    {
        $anuncios = Anuncio::where('thumb', '!=', '')->where('status', 1)->with('anunciante')->get();
        return view('admin.anuncios.ativos', compact('anuncios'));
    }

    public function free()
    {
        $anuncios = Anuncio::where('thumb', '')->with('anunciante')->get();
        return view('admin.anuncios.ativos', compact('anuncios'));
    }

    // DB::getPdo()->lastInsertId()
    public function create()
    {
        $anuncio = Anuncio::where('userID', Auth::user()->id)->where('status', '10')->first();
        if (!$anuncio) {
            $set['userID'] = Auth::user()->id;
            $set['status']  = 10;
            $set['visitas']  = 10;
            Anuncio::create($set);
            $anuncio = DB::getPdo()->lastInsertId();
        }

        @$telefones      = AnuncioTelefone::where('anuncioID', $anuncio->id)->get();
        $estados         = Estado::get();
        $anunciantes     = User::where('nivel', '4')->get();
        $representantes  = User::where('nivel', 1)->orWhere('nivel', 2)->get();
        $categorias      = Categoria::get();
        $potencias      = Potencia::get();

        // dd($anuncio);
        return redirect()->route('anuncio.show', $anuncio->id);
    }

    public function store(Request $request)
    {

        $anuncio    =   Anuncio::find($request->anuncio_id);
        $dados      =   $request->all();


        if ($request->rabin) {
            if (!empty($request->thumb)) {
                $nameFile           = Str::of($request->thumb)->slug('-') . rand() . '.' . $request->thumb->getClientOriginalExtension();
                $thumb     = $request->thumb->storeAs('anuncios', $nameFile);
                $dados['thumb']     = "https://2023.agendamaconicabrasil.com.br/storage/" . $thumb;
            }
            $anuncio->update($dados);
            // dd($request->all(),$dados);
            return redirect()->back()->with('success', 'Anuncio atualizado com sucesso');
        }

        if (!empty($request->representanteID)) {
            $repr                   = User::find($request->representanteID);
            $dados['representante'] = $repr->nome;
        }


        $categoria              = Categoria::find($request->categoria_id);
        $dados['categoriaID']   = $categoria->id;
        $dados['categoria']     = $categoria->level1;
        $dados['keywords']      = $categoria->keywords;

        $socio                  = AnuncioPessoas::where('anuncioID', $request->anuncio_id)->first();
        $dados['titulo']        = $socio->titulo;
        $dados['nome']          = $socio->nome;
        $dados['cpf']           = $socio->cpf;
        $dados['nascimento']    = $socio->nascimento;
        $dados['sangue']        = $socio->sangue;

        if (!empty($request->thumb)) {
            $nameFile           = Str::of($request->thumb)->slug('-') . rand() . '.' . $request->thumb->getClientOriginalExtension();
            $thumb     = $request->thumb->storeAs('anuncios', $nameFile);
            $dados['thumb']     = "https://2023.agendamaconicabrasil.com.br/storage/" . $thumb;
        }

        $palavras = explode(',', $request->palavras);
        foreach ($palavras as $palavra) {
            $verifica = PalavraChave::where('chave', $palavra)->first();
            if (empty($verifica)) {
                PalavraChave::create([
                    'categoria_id' => $categoria->id,
                    'chave' => $palavra,
                ]);
            }
        }

        $dados['vencimento']    = date('Y-m-d', strtotime("+1year"));
        $dados['status']        = 'Publicado';
        $anuncio->update($dados);

        // dd($request->all(),$dados,$categoria);
        return redirect()->back()->with('success', 'Anuncio Criado com sucesso');
    }

    public function show($id)
    {
        $anuncio = Anuncio::find($id);
        if (!$anuncio) {
            $set['user_id'] = Auth::user()->id;
            $set['status']  = 10;
            Anuncio::create($set);
            $anuncio = DB::getPdo()->lastInsertId();
        }

        $estados         = Estado::get();
        $anunciantes     = User::where('nivel', '4')->get();
        $representantes  = User::where('nivel', 1)->orWhere('nivel', 2)->get();
        $categorias      = Categoria::orderby('level1', 'ASC')->get();
        $potencias      = Potencia::get();

        return view('admin.anuncios.show', compact('estados', 'anunciantes', 'categorias', 'representantes', 'categorias', 'potencias'), ['anuncio' => $anuncio]);
    }

    public function edit($id)
    {
    }

    public function update(Request $request, $id)
    {

        $anuncio    = Anuncio::find($id);
        $categoria  = Categoria::find($request->categoria_id);
        $sub        = SubCategoria::find($request->sub_categoria_id);

        $dados = $request->all();
        $dados['user_id'] = Auth::user()->id;


        if (!empty($request->thumb)) {
            $nameFile           = Str::of($request->thumb)->slug('-') . rand() . '.' . $request->ico->getClientOriginalExtension();
            $dados['thumb']     = "https://2023.agendamaconicabrasil.com.br/storage/" . $request->thumb->storeAs('anuncios', $nameFile);


            // $imagem = Image::make($request->thumb)->orientate()->fit(600, null, function ($constraint) {
            //     $constraint->aspectRatio();
            // });
            // $FotoUrl        = $request->thumb->hashName("anuncios");
            // Storage::disk('local')->put($FotoUrl, $imagem->encode());
            // $dados['thumb']     = "https://2023.agendamaconicabrasil.com.br/storage/".$FotoUrl;
        }

        if (!empty($request->no_image)) {
            $dados['thumb'] = NULL;
        }
        if ($request->banner) {
            $nameFile       = Str::of($request->titulo)->slug('-') . rand() . '.' . $request->banner->getClientOriginalExtension();
            $dados['banner'] = $request->banner->storeAs('banner', $nameFile);
        }
        $dados['url']       = Str::of($request->titulo)->slug('-');

        if ($request->no_banner == 1) {
            $dados['banner'] = '';
        }

        $dados['destaque']  = !empty($request->destaque) ? $request->destaque : '';
        $dados['status']    = 1;
        $dados['level1']    = @$categoria->titulo;
        $dados['level2']    = !empty($sub->titulo) ? $sub->titulo : '';
        $anuncio->update($dados);
        // dd($request->all());
        return redirect()->back()->with('success', 'Anúncio atualizado com sucesso');
    }

    public function destroy($id)
    {
        $anuncio = Anuncio::find($id);
        $telefones = AnuncioTelefone::where('anuncioID', $id)->get();
        foreach ($telefones as $telefone) {
            $tel = AnuncioTelefone::find($telefone->id);
            $tel->delete();
        }
        $anuncio->delete();
        return redirect()->route('todos.anuncios');
    }

    public function AddTelefone(Request $request)
    {
        $dados['anuncioID']     = $request->id;
        $dados['tipo']          = $request->tipo;
        $dados['numero']        = tiraMoeda($request->numero);
        AnuncioTelefone::create($dados);
        $telefones              = AnuncioTelefone::where('anuncioID', $request->id)->get();

        return view('admin.ajax.telefones', compact('telefones'));
    }

    public function AddSocio(Request $request)
    {
        $exe                = Anuncio::find($request->id);
        if (empty($exe->nome)) {
            if ($exe) {
                $exe->update([
                    'cpf'           => $request->cpf,
                    'nome'          => $request->nome,
                    'titulo_ir'     => $request->titulo,
                    'nascimento'    => $request->nascimento,
                    'sangue'        => $request->sangue,
                ]);
                $array['anuncio']   = $exe;
            }
        }

        AnuncioPessoas::create([
            'anuncioID' => $request->id,
            'titulo'    => $request->titulo,
            'nome'      => $request->nome,
            'cpf'       => $request->cpf,
            'nascimento' => $request->nascimento,
            'sangue'    => $request->sangue,
        ]);
        $socios     = AnuncioPessoas::where('anuncioID', $request->id)->get();

        return view('admin.ajax.socios', compact('socios'));
    }

    public function RemoveTelefone(Request $request)
    {
        $exe        = AnuncioTelefone::find($request->id);
        $exe->delete();
    }

    public function RemoveSocio(Request $request)
    {
        $exe        = AnuncioPessoas::find($request->id);
        $exe->delete();
    }

    public function duplicar($id)
    {
        $exe = Anuncio::find($id);

        $anuncio =  Anuncio::create([
            "status" => $exe['status'],
            "anuncioID" => $exe['anuncioID'],
            "userID" => $exe['userID'],
            "cnpj" => $exe['cnpj'],
            "razao" => $exe['razao'],
            "fantasia" => $exe['fantasia'],
            "representanteID" => $exe['representanteID'],
            "representante" => $exe['representante'],
            "contrato" => $exe['contrato'],
            "vencimento" => $exe['vencimento'],
            "categoriaID" => $exe['categoriaID'],
            "categoria" => $exe['categoria'],
            "keywords" => $exe['keywords'],
            "endereco" => $exe['endereco'],
            "complemento" => $exe['complemento'],
            "numero" => $exe['numero'],
            "bairro" => $exe['bairro'],
            "cidade" => $exe['cidade'],
            "estado" => $exe['estado'],
            "url" => $exe['url'],
            "visitas" => $exe['visitas'],
            "click_telefone" => $exe['click_telefone'],
            "qtd_share" => $exe['qtd_share'],
            "destaque" => $exe['destaque'],
            "email" => $exe['email'],
            "email2" => $exe['email2'],
            "site" => $exe['site'],
            "facebook" => $exe['facebook'],
            "instagram" => $exe['instagram'],
            "faternal" => $exe['faternal'],
            "tel0800" => $exe['tel0800'],
            "cep" => $exe['cep'],
            "thumb" => $exe['thumb'],
            "titulo_ir" => $exe['titulo_ir'],
            "nome" => $exe['nome'],
            "cpf" => $exe['cpf'],
            "nascimento" => $exe['nascimento'],
            "lojaID" => $exe['lojaID'],
            "sangue" => $exe['sangue'],
            "potencia" => $exe['potencia'],
            "loja" => $exe['loja'],
            "numero_loja" => $exe['numero_loja'],
            "parcelamento" => $exe['parcelamento'],
            "valor_contrato" => $exe['valor_contrato'],
            "termos_contrato" => $exe['termos_contrato'],
            "level1_id" => $exe['level1_id'],
            "level1" => $exe['level1'],
            "level2_id" => $exe['level2_id'],
            "level2" => $exe['level2'],
            "nova_categoria" => $exe['nova_categoria'],
        ]);
        
        foreach($exe->Socios as $socio){
            AnuncioPessoas::create([
                'anuncioID'     => $anuncio->id,
                'titulo'        => $socio->titulo,
                'nome'          => $socio->nome,
                'cpf'           => $socio->cpf,
                'nascimento'    => $socio->nascimento,
                'sangue'        => $socio->sangue,
            ]);
        }
        
        foreach($exe->telefones as $tel){
            AnuncioTelefone::create([
                'anuncioID'     => $anuncio->id,
                'tipo'          => $tel->tipo,
                'numero'        => $tel->numero,
            ]);
        }

        
        // dd($anuncio,$exe->Socios,$exe->telefones);
        return redirect()->route('anuncio.show', $anuncio->id);
    }


    public function AnunciosCategoria($level1_id)
    {
        $anuncios = Anuncio::where('categoria_id', $level1_id)->get();
        return view('admin.anuncios.ativos', compact('anuncios'));
    }
    public function AnunciosCategoriaSub($level1_id, $level2_id)
    {
        $anuncios = Anuncio::where('categoria_id', $level1_id)->where('sub_categoria_id', $level2_id)->get();
        return view('admin.anuncios.ativos', compact('anuncios'));
    }

    public function ConsultaCNPJ(Request $request)
    {
        $estados = Estado::get();
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://www.receitaws.com.br/v1/cnpj/" . setUri2($request->cnpj),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_HTTPHEADER => array(
                "Cookie: JSESSIONID=ed179333b826d9026424e4b7dd183e4d36c2892d"
            ),
        ));

        $response = curl_exec($curl);
        curl_close($curl);
        $res = json_decode($response, true);

        return view('admin.ajax.cnpj', compact('estados'), [
            'fantasia'      => $res['fantasia'],
            'razao'         => $res['nome'],
            'responsavel'   => !empty($res['qsa'][0]['nome']) ? $res['qsa'][0]['nome'] : '',
            'email'     => $res['email'],
            'telefone'  => $res['telefone'],
            'cep'       => $res['cep'],
            'endereco'  => $res['logradouro'],
            'numero'    => $res['numero'],
            'bairro'    => $res['bairro'],
            'municipio' => $res['municipio'],
            'uf'        => $res['uf'],
        ]);
    }


    function rabin($contrato)
    {
        $anuncio = Anuncio::where('contrato', $contrato)->first();
        // dd($anuncio);
        return view('admin.anuncios.rabin', ['anuncio' => $anuncio]);
    }
}
