<?php

function lmWord($string, $words = '400')
{
    $string = strip_tags($string);
    $count = strlen($string);

    if ($count <= $words) {
        return $string;
    } else {
        $strpos = strrpos(substr($string, 0, $words), ' ');
        return substr($string, 0, $strpos);
    }
}

function setUri($string)
{
    $a = 'ÀÁÂÃÄÅÆÇÈÉÊËÌÍÎÏÐÑÒÓÔÕÖØÙÚÛÜüÝÞßàáâãäåæçèéêëìíîïðñòóôõöøùúûýýþÿŔŕ"!@#$%&*()_-+={[}]/?;:.,\\\'<>°ºª';
    $b = 'aaaaaaaceeeeiiiidnoooooouuuuuybsaaaaaaaceeeeiiiidnoooooouuuyybyRr                                 ';
    $string = utf8_decode($string);
    $string = strtr($string, utf8_decode($a), $b);
    $string = strip_tags(trim($string));
    $string = str_replace(" ", "-", $string);
    $string = str_replace(array("-----", "----", "---", "--"), "-", $string);
    return strtolower(utf8_encode($string));
}
function setUri2($string)
{
    $a = 'ÀÁÂÃÄÅÆÇÈÉÊËÌÍÎÏÐÑÒÓÔÕÖØÙÚÛÜüÝÞßàáâãäåæçèéêëìíîïðñòóôõöøùúûýýþÿŔŕ"!@#$%&*()_-+={[}]/?;:.,\\\'<>°ºª';
    $b = 'aaaaaaaceeeeiiiidnoooooouuuuuybsaaaaaaaceeeeiiiidnoooooouuuyybyRr                                 ';
    $string = utf8_decode($string);
    $string = strtr($string, utf8_decode($a), $b);
    $string = strip_tags(trim($string));
    $string = str_replace(" ", "", $string);
    $string = str_replace(array("-----", "----", "---", "--"), "", $string);
    return strtolower(utf8_encode($string));
}

function setUri3($string)
{
    $a = '"!@#$%&*()_-+={[}]/?;:.,\\\'<>°ºª';
    $b = '                                 ';
    $string = utf8_decode($string);
    $string = strtr($string, utf8_decode($a), $b);
    $string = strip_tags(trim($string));
    $string = str_replace(" ", " ", $string);
    $string = str_replace(array("-----", "----", "---", "--"), " ", $string);
    return strtolower(utf8_encode($string));
}

function tiraMoeda($valor)
{
    $novoValor = preg_replace("/[^0-9\s]/", "", $valor);
    return $novoValor;
}

function moeda($valor)
{
    if (is_numeric($valor)) {
        $valorEmReais = number_format($valor / 100, 2, ",", ".");
        return $valorEmReais;
    } else {
        // Trate o caso em que $valor não é numérico
        return '0,00';
    }
}


function dolar($valor)
{
    $valor = number_format($valor / 100, 2, ".", "");
    str_replace('.', '%', $valor);
    str_replace(',', '.', $valor);
    return str_replace('%', ',', $valor);
}

function peso($valor)
{
    $valor = number_format($valor / 1000, 3, ".", ",");
    str_replace('.', '%', $valor);
    str_replace(',', '.', $valor);
    return str_replace('%', ',', $valor);
}

function formatCnpjCpf($value)
{
    $CPF_LENGTH = 11;
    $cnpj_cpf = preg_replace("/\D/", '', $value);
    if (strlen($cnpj_cpf) === $CPF_LENGTH) {
        return preg_replace("/(\d{3})(\d{3})(\d{3})(\d{2})/", "\$1.\$2.\$3-\$4", $cnpj_cpf);
    }
    return preg_replace("/(\d{2})(\d{3})(\d{3})(\d{4})(\d{2})/", "\$1.\$2.\$3/\$4-\$5", $cnpj_cpf);
}

function DiferencaPorcentagem($v1, $v2)
{
    $perguntas = $v1;
    $acertos = $v2;
    return ((($perguntas - $acertos) / $perguntas) * 100);
}

function gerarCodigo($qtd)
{
    $senha = "123456789";
    //    $senha = "0123456789abcdefghijlmnopqrstuvxz";
    srand((float) microtime() * 1000000);
    $cod = false;
    for ($i = 0; $i < $qtd; $i++) :
        $cod .= $senha[rand() % strlen($senha)];
    endfor;
    return $cod;
}

function porcentagem($pctm, $total)
{
    $valor_descontado = $total - ($total / 100 * $pctm);
    return  $total - $valor_descontado;
}

function Dias($inicio, $fim)
{
    $data_inicio = new DateTime($inicio);
    $data_fim = new DateTime($fim);

    // Resgata diferença entre as datas
    $dateInterval = $data_inicio->diff($data_fim);
    $dias = $dateInterval->d + ($dateInterval->y * 12);
    return $dias;
}

function Intervalo($inicio, $fim)
{
    $inicio = $inicio;
    $fim = $fim;

    // Converte as duas datas para um objeto DateTime do PHP
    $inicio = DateTime::createFromFormat('H:i:s', $inicio);

    $fim = DateTime::createFromFormat('H:i:s', $fim);

    $intervalo = $inicio->diff($fim);

    // Formata a diferença de horas para
    // aparecer no formato 00:00:00 na página
    print $intervalo->format('%H:%I:%S');
}

function calcularIdade($dataNascimento) {
    $agora = new DateTime();
    $dataNasc = new DateTime($dataNascimento);
    $intervalo = $agora->diff($dataNasc);
    $anos = $intervalo->y;
    $meses = $intervalo->m;
    $dias = $intervalo->d;
    return "$anos anos, $meses meses e $dias dias";
}

function validarCPF($cpf) {
    $cpf = preg_replace('/[^0-9]/', '', $cpf);
    $digitoA = 0;
    $digitoB = 0;
    for ($i = 0, $x = 10; $i <= 8; $i++, $x--) {
        $digitoA += $cpf[$i] * $x;
    }
    for ($i = 0, $x = 11; $i <= 9; $i++, $x--) {
        if (str_repeat($i, 11) == $cpf) {
            return false;
        }
        $digitoB += $cpf[$i] * $x;
    }
    $somaA = (($digitoA % 11) < 2 ) ? 0 : 11 - ($digitoA % 11);
    $somaB = (($digitoB % 11) < 2 ) ? 0 : 11 - ($digitoB % 11);
    if ($somaA != $cpf[9] || $somaB != $cpf[10]) {
        return false;
    } else {
        return true;
    }
 }

 function MediaEstrelas($avaliacoes) {
    if (!is_array($avaliacoes)) {
        $avaliacoes = [$avaliacoes]; // Envolve o valor inteiro em um array
    }
    $totalAvaliacoes = count($avaliacoes);
    $totalPontos = array_sum($avaliacoes);

    if ($totalAvaliacoes > 0) {
        $media = $totalPontos / $totalAvaliacoes;
        $mediaFormatada = number_format($media, 1);
        $mediaDecimal = $mediaFormatada / 10;
        return $mediaDecimal;
    } else {
        return 0; // Retorna 0 se não houver avaliações
    }
}


function CountTime($dataInicial, $dataFinal) {
    $dataInicio = strtotime($dataInicial);
    $dataFim = strtotime($dataFinal);

    $diferenca = $dataInicio - $dataFim; // Troquei a ordem da subtração

    if ($diferenca < 60) {
        return "agora";
    } else if ($diferenca < 3600) {
        $minutos = floor($diferenca / 60);
        return $minutos . " minuto" . ($minutos > 1 ? "s" : "") . " atrás";
    } else if ($diferenca < 86400) {
        $horas = floor($diferenca / 3600);
        return $horas . " hora" . ($horas > 1 ? "s" : "") . " atrás";
    } else if ($diferenca < 2592000) {
        $dias = floor($diferenca / 86400);
        return $dias . " dia" . ($dias > 1 ? "s" : "") . " atrás";
    } else if ($diferenca < 31536000) {
        $meses = floor($diferenca / 2592000);
        return $meses . " mês" . ($meses > 1 ? "es" : "") . " atrás";
    } else {
        $anos = floor($diferenca / 31536000);
        return $anos . " ano" . ($anos > 1 ? "s" : "") . " atrás";
    }
}

function CalcularVencimento($dataVencimento)
{
    // Obter a data de hoje
    $hoje = date('Y-m-d');

    // Converter as datas para objetos DateTime
    $dataVencimento = new DateTime($dataVencimento);
    $dataHoje = new DateTime($hoje);

    // Verificar se a data de vencimento é anterior à data de hoje
    if ($dataVencimento > $dataHoje) {
        // Calcular a diferença em dias
        $intervalo = $dataHoje->diff($dataVencimento);
        $diasVencidos = $intervalo->days;

        return $diasVencidos." dias";
    }
}


function getUltimaPalavra($string) {
    // Remove espaços em branco no início e no final da string
    $string = trim($string);
    // Divide a string em palavras usando espaços como delimitador
    $palavras = explode(' ', $string);
    // Obtém a última palavra do array
    $ultimaPalavra = end($palavras);
    return $ultimaPalavra;
}

function Sobrenome($string) {
    // Remove espaços em branco no início e no final da string
    $string = trim($string);
    // Divide a string em palavras usando espaços como delimitador
    $palavras = explode(' ', $string);
    // Obtém a última palavra do array
    $ultimaPalavra = end($palavras);
    return $ultimaPalavra;
}

function intro($string, $limiteCaracteres) {
    if (strlen($string) > $limiteCaracteres) {
        $string = substr($string, 0, $limiteCaracteres) . "...";
    }
    return $string;
}
